/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEndpointRequest extends ComprehendRequest implements
        ToCopyableBuilder<CreateEndpointRequest.Builder, CreateEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(CreateEndpointRequest::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(CreateEndpointRequest::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<Integer> DESIRED_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredInferenceUnits").getter(getter(CreateEndpointRequest::desiredInferenceUnits))
            .setter(setter(Builder::desiredInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInferenceUnits").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateEndpointRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateEndpointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            MODEL_ARN_FIELD, DESIRED_INFERENCE_UNITS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));

    private final String endpointName;

    private final String modelArn;

    private final Integer desiredInferenceUnits;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private CreateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.modelArn = builder.modelArn;
        this.desiredInferenceUnits = builder.desiredInferenceUnits;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for all subsequent requests
     * to this resource.
     * </p>
     * 
     * @return This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for all subsequent
     *         requests to this resource.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The desired number of inference units to be used by the model using this endpoint. Each inference unit represents
     * of a throughput of 100 characters per second.
     * </p>
     * 
     * @return The desired number of inference units to be used by the model using this endpoint. Each inference unit
     *         represents of a throughput of 100 characters per second.
     */
    public final Integer desiredInferenceUnits() {
        return desiredInferenceUnits;
    }

    /**
     * <p>
     * An idempotency token provided by the customer. If this token matches a previous endpoint creation request, Amazon
     * Comprehend will not return a <code>ResourceInUseException</code>.
     * </p>
     * 
     * @return An idempotency token provided by the customer. If this token matches a previous endpoint creation
     *         request, Amazon Comprehend will not return a <code>ResourceInUseException</code>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the endpoint.
     * For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales
     * department.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the
     *         endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by
     *         the sales department.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(desiredInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointRequest)) {
            return false;
        }
        CreateEndpointRequest other = (CreateEndpointRequest) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(desiredInferenceUnits(), other.desiredInferenceUnits())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEndpointRequest").add("EndpointName", endpointName()).add("ModelArn", modelArn())
                .add("DesiredInferenceUnits", desiredInferenceUnits()).add("ClientRequestToken", clientRequestToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "DesiredInferenceUnits":
            return Optional.ofNullable(clazz.cast(desiredInferenceUnits()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointRequest, T> g) {
        return obj -> g.apply((CreateEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEndpointRequest> {
        /**
         * <p>
         * This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for all subsequent
         * requests to this resource.
         * </p>
         * 
         * @param endpointName
         *        This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for all
         *        subsequent requests to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The desired number of inference units to be used by the model using this endpoint. Each inference unit
         * represents of a throughput of 100 characters per second.
         * </p>
         * 
         * @param desiredInferenceUnits
         *        The desired number of inference units to be used by the model using this endpoint. Each inference unit
         *        represents of a throughput of 100 characters per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredInferenceUnits(Integer desiredInferenceUnits);

        /**
         * <p>
         * An idempotency token provided by the customer. If this token matches a previous endpoint creation request,
         * Amazon Comprehend will not return a <code>ResourceInUseException</code>.
         * </p>
         * 
         * @param clientRequestToken
         *        An idempotency token provided by the customer. If this token matches a previous endpoint creation
         *        request, Amazon Comprehend will not return a <code>ResourceInUseException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the
         * endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the
         * sales department.
         * </p>
         * 
         * @param tags
         *        Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the
         *        endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use
         *        by the sales department.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the
         * endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the
         * sales department.
         * </p>
         * 
         * @param tags
         *        Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the
         *        endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use
         *        by the sales department.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the
         * endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the
         * sales department.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String endpointName;

        private String modelArn;

        private Integer desiredInferenceUnits;

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointRequest model) {
            super(model);
            endpointName(model.endpointName);
            modelArn(model.modelArn);
            desiredInferenceUnits(model.desiredInferenceUnits);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getModelArn() {
            return modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        public final Integer getDesiredInferenceUnits() {
            return desiredInferenceUnits;
        }

        @Override
        public final Builder desiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
            return this;
        }

        public final void setDesiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointRequest build() {
            return new CreateEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
