/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePiiEntitiesDetectionJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribePiiEntitiesDetectionJobResponse.Builder, DescribePiiEntitiesDetectionJobResponse> {
    private static final SdkField<PiiEntitiesDetectionJobProperties> PII_ENTITIES_DETECTION_JOB_PROPERTIES_FIELD = SdkField
            .<PiiEntitiesDetectionJobProperties> builder(MarshallingType.SDK_POJO)
            .memberName("PiiEntitiesDetectionJobProperties")
            .getter(getter(DescribePiiEntitiesDetectionJobResponse::piiEntitiesDetectionJobProperties))
            .setter(setter(Builder::piiEntitiesDetectionJobProperties))
            .constructor(PiiEntitiesDetectionJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntitiesDetectionJobProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PII_ENTITIES_DETECTION_JOB_PROPERTIES_FIELD));

    private final PiiEntitiesDetectionJobProperties piiEntitiesDetectionJobProperties;

    private DescribePiiEntitiesDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.piiEntitiesDetectionJobProperties = builder.piiEntitiesDetectionJobProperties;
    }

    /**
     * Returns the value of the PiiEntitiesDetectionJobProperties property for this object.
     * 
     * @return The value of the PiiEntitiesDetectionJobProperties property for this object.
     */
    public final PiiEntitiesDetectionJobProperties piiEntitiesDetectionJobProperties() {
        return piiEntitiesDetectionJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(piiEntitiesDetectionJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePiiEntitiesDetectionJobResponse)) {
            return false;
        }
        DescribePiiEntitiesDetectionJobResponse other = (DescribePiiEntitiesDetectionJobResponse) obj;
        return Objects.equals(piiEntitiesDetectionJobProperties(), other.piiEntitiesDetectionJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePiiEntitiesDetectionJobResponse")
                .add("PiiEntitiesDetectionJobProperties", piiEntitiesDetectionJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PiiEntitiesDetectionJobProperties":
            return Optional.ofNullable(clazz.cast(piiEntitiesDetectionJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePiiEntitiesDetectionJobResponse, T> g) {
        return obj -> g.apply((DescribePiiEntitiesDetectionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePiiEntitiesDetectionJobResponse> {
        /**
         * Sets the value of the PiiEntitiesDetectionJobProperties property for this object.
         *
         * @param piiEntitiesDetectionJobProperties
         *        The new value for the PiiEntitiesDetectionJobProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntitiesDetectionJobProperties(PiiEntitiesDetectionJobProperties piiEntitiesDetectionJobProperties);

        /**
         * Sets the value of the PiiEntitiesDetectionJobProperties property for this object.
         *
         * This is a convenience that creates an instance of the {@link PiiEntitiesDetectionJobProperties.Builder}
         * avoiding the need to create one manually via {@link PiiEntitiesDetectionJobProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link PiiEntitiesDetectionJobProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #piiEntitiesDetectionJobProperties(PiiEntitiesDetectionJobProperties)}.
         * 
         * @param piiEntitiesDetectionJobProperties
         *        a consumer that will call methods on {@link PiiEntitiesDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #piiEntitiesDetectionJobProperties(PiiEntitiesDetectionJobProperties)
         */
        default Builder piiEntitiesDetectionJobProperties(
                Consumer<PiiEntitiesDetectionJobProperties.Builder> piiEntitiesDetectionJobProperties) {
            return piiEntitiesDetectionJobProperties(PiiEntitiesDetectionJobProperties.builder()
                    .applyMutation(piiEntitiesDetectionJobProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private PiiEntitiesDetectionJobProperties piiEntitiesDetectionJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePiiEntitiesDetectionJobResponse model) {
            super(model);
            piiEntitiesDetectionJobProperties(model.piiEntitiesDetectionJobProperties);
        }

        public final PiiEntitiesDetectionJobProperties.Builder getPiiEntitiesDetectionJobProperties() {
            return piiEntitiesDetectionJobProperties != null ? piiEntitiesDetectionJobProperties.toBuilder() : null;
        }

        @Override
        public final Builder piiEntitiesDetectionJobProperties(PiiEntitiesDetectionJobProperties piiEntitiesDetectionJobProperties) {
            this.piiEntitiesDetectionJobProperties = piiEntitiesDetectionJobProperties;
            return this;
        }

        public final void setPiiEntitiesDetectionJobProperties(
                PiiEntitiesDetectionJobProperties.BuilderImpl piiEntitiesDetectionJobProperties) {
            this.piiEntitiesDetectionJobProperties = piiEntitiesDetectionJobProperties != null ? piiEntitiesDetectionJobProperties
                    .build() : null;
        }

        @Override
        public DescribePiiEntitiesDetectionJobResponse build() {
            return new DescribePiiEntitiesDetectionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
