/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a document classifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassifierMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassifierMetadata.Builder, ClassifierMetadata> {
    private static final SdkField<Integer> NUMBER_OF_LABELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfLabels").getter(getter(ClassifierMetadata::numberOfLabels))
            .setter(setter(Builder::numberOfLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLabels").build()).build();

    private static final SdkField<Integer> NUMBER_OF_TRAINED_DOCUMENTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("NumberOfTrainedDocuments")
            .getter(getter(ClassifierMetadata::numberOfTrainedDocuments)).setter(setter(Builder::numberOfTrainedDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTrainedDocuments").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_TEST_DOCUMENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfTestDocuments").getter(getter(ClassifierMetadata::numberOfTestDocuments))
            .setter(setter(Builder::numberOfTestDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTestDocuments").build())
            .build();

    private static final SdkField<ClassifierEvaluationMetrics> EVALUATION_METRICS_FIELD = SdkField
            .<ClassifierEvaluationMetrics> builder(MarshallingType.SDK_POJO).memberName("EvaluationMetrics")
            .getter(getter(ClassifierMetadata::evaluationMetrics)).setter(setter(Builder::evaluationMetrics))
            .constructor(ClassifierEvaluationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_LABELS_FIELD,
            NUMBER_OF_TRAINED_DOCUMENTS_FIELD, NUMBER_OF_TEST_DOCUMENTS_FIELD, EVALUATION_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer numberOfLabels;

    private final Integer numberOfTrainedDocuments;

    private final Integer numberOfTestDocuments;

    private final ClassifierEvaluationMetrics evaluationMetrics;

    private ClassifierMetadata(BuilderImpl builder) {
        this.numberOfLabels = builder.numberOfLabels;
        this.numberOfTrainedDocuments = builder.numberOfTrainedDocuments;
        this.numberOfTestDocuments = builder.numberOfTestDocuments;
        this.evaluationMetrics = builder.evaluationMetrics;
    }

    /**
     * <p>
     * The number of labels in the input data.
     * </p>
     * 
     * @return The number of labels in the input data.
     */
    public final Integer numberOfLabels() {
        return numberOfLabels;
    }

    /**
     * <p>
     * The number of documents in the input data that were used to train the classifier. Typically this is 80 to 90
     * percent of the input documents.
     * </p>
     * 
     * @return The number of documents in the input data that were used to train the classifier. Typically this is 80 to
     *         90 percent of the input documents.
     */
    public final Integer numberOfTrainedDocuments() {
        return numberOfTrainedDocuments;
    }

    /**
     * <p>
     * The number of documents in the input data that were used to test the classifier. Typically this is 10 to 20
     * percent of the input documents, up to 10,000 documents.
     * </p>
     * 
     * @return The number of documents in the input data that were used to test the classifier. Typically this is 10 to
     *         20 percent of the input documents, up to 10,000 documents.
     */
    public final Integer numberOfTestDocuments() {
        return numberOfTestDocuments;
    }

    /**
     * <p>
     * Describes the result metrics for the test data associated with an documentation classifier.
     * </p>
     * 
     * @return Describes the result metrics for the test data associated with an documentation classifier.
     */
    public final ClassifierEvaluationMetrics evaluationMetrics() {
        return evaluationMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfLabels());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTrainedDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTestDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifierMetadata)) {
            return false;
        }
        ClassifierMetadata other = (ClassifierMetadata) obj;
        return Objects.equals(numberOfLabels(), other.numberOfLabels())
                && Objects.equals(numberOfTrainedDocuments(), other.numberOfTrainedDocuments())
                && Objects.equals(numberOfTestDocuments(), other.numberOfTestDocuments())
                && Objects.equals(evaluationMetrics(), other.evaluationMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClassifierMetadata").add("NumberOfLabels", numberOfLabels())
                .add("NumberOfTrainedDocuments", numberOfTrainedDocuments())
                .add("NumberOfTestDocuments", numberOfTestDocuments()).add("EvaluationMetrics", evaluationMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfLabels":
            return Optional.ofNullable(clazz.cast(numberOfLabels()));
        case "NumberOfTrainedDocuments":
            return Optional.ofNullable(clazz.cast(numberOfTrainedDocuments()));
        case "NumberOfTestDocuments":
            return Optional.ofNullable(clazz.cast(numberOfTestDocuments()));
        case "EvaluationMetrics":
            return Optional.ofNullable(clazz.cast(evaluationMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassifierMetadata, T> g) {
        return obj -> g.apply((ClassifierMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassifierMetadata> {
        /**
         * <p>
         * The number of labels in the input data.
         * </p>
         * 
         * @param numberOfLabels
         *        The number of labels in the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfLabels(Integer numberOfLabels);

        /**
         * <p>
         * The number of documents in the input data that were used to train the classifier. Typically this is 80 to 90
         * percent of the input documents.
         * </p>
         * 
         * @param numberOfTrainedDocuments
         *        The number of documents in the input data that were used to train the classifier. Typically this is 80
         *        to 90 percent of the input documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTrainedDocuments(Integer numberOfTrainedDocuments);

        /**
         * <p>
         * The number of documents in the input data that were used to test the classifier. Typically this is 10 to 20
         * percent of the input documents, up to 10,000 documents.
         * </p>
         * 
         * @param numberOfTestDocuments
         *        The number of documents in the input data that were used to test the classifier. Typically this is 10
         *        to 20 percent of the input documents, up to 10,000 documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTestDocuments(Integer numberOfTestDocuments);

        /**
         * <p>
         * Describes the result metrics for the test data associated with an documentation classifier.
         * </p>
         * 
         * @param evaluationMetrics
         *        Describes the result metrics for the test data associated with an documentation classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationMetrics(ClassifierEvaluationMetrics evaluationMetrics);

        /**
         * <p>
         * Describes the result metrics for the test data associated with an documentation classifier.
         * </p>
         * This is a convenience that creates an instance of the {@link ClassifierEvaluationMetrics.Builder} avoiding
         * the need to create one manually via {@link ClassifierEvaluationMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClassifierEvaluationMetrics.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluationMetrics(ClassifierEvaluationMetrics)}.
         * 
         * @param evaluationMetrics
         *        a consumer that will call methods on {@link ClassifierEvaluationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationMetrics(ClassifierEvaluationMetrics)
         */
        default Builder evaluationMetrics(Consumer<ClassifierEvaluationMetrics.Builder> evaluationMetrics) {
            return evaluationMetrics(ClassifierEvaluationMetrics.builder().applyMutation(evaluationMetrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfLabels;

        private Integer numberOfTrainedDocuments;

        private Integer numberOfTestDocuments;

        private ClassifierEvaluationMetrics evaluationMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassifierMetadata model) {
            numberOfLabels(model.numberOfLabels);
            numberOfTrainedDocuments(model.numberOfTrainedDocuments);
            numberOfTestDocuments(model.numberOfTestDocuments);
            evaluationMetrics(model.evaluationMetrics);
        }

        public final Integer getNumberOfLabels() {
            return numberOfLabels;
        }

        @Override
        public final Builder numberOfLabels(Integer numberOfLabels) {
            this.numberOfLabels = numberOfLabels;
            return this;
        }

        public final void setNumberOfLabels(Integer numberOfLabels) {
            this.numberOfLabels = numberOfLabels;
        }

        public final Integer getNumberOfTrainedDocuments() {
            return numberOfTrainedDocuments;
        }

        @Override
        public final Builder numberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
            this.numberOfTrainedDocuments = numberOfTrainedDocuments;
            return this;
        }

        public final void setNumberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
            this.numberOfTrainedDocuments = numberOfTrainedDocuments;
        }

        public final Integer getNumberOfTestDocuments() {
            return numberOfTestDocuments;
        }

        @Override
        public final Builder numberOfTestDocuments(Integer numberOfTestDocuments) {
            this.numberOfTestDocuments = numberOfTestDocuments;
            return this;
        }

        public final void setNumberOfTestDocuments(Integer numberOfTestDocuments) {
            this.numberOfTestDocuments = numberOfTestDocuments;
        }

        public final ClassifierEvaluationMetrics.Builder getEvaluationMetrics() {
            return evaluationMetrics != null ? evaluationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder evaluationMetrics(ClassifierEvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public final void setEvaluationMetrics(ClassifierEvaluationMetrics.BuilderImpl evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics != null ? evaluationMetrics.build() : null;
        }

        @Override
        public ClassifierMetadata build() {
            return new ClassifierMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
