/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DocumentClassificationJobProperties;
import software.amazon.awssdk.services.comprehend.model.DocumentClassificationJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDocumentClassificationJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListDocumentClassificationJobsResponse> {
    private static final SdkField<List<DocumentClassificationJobProperties>> DOCUMENT_CLASSIFICATION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentClassificationJobPropertiesList").getter(ListDocumentClassificationJobsResponse.getter(ListDocumentClassificationJobsResponse::documentClassificationJobPropertiesList)).setter(ListDocumentClassificationJobsResponse.setter(Builder::documentClassificationJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassificationJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentClassificationJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDocumentClassificationJobsResponse.getter(ListDocumentClassificationJobsResponse::nextToken)).setter(ListDocumentClassificationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_CLASSIFICATION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<DocumentClassificationJobProperties> documentClassificationJobPropertiesList;
    private final String nextToken;

    private ListDocumentClassificationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.documentClassificationJobPropertiesList = builder.documentClassificationJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDocumentClassificationJobPropertiesList() {
        return this.documentClassificationJobPropertiesList != null && !(this.documentClassificationJobPropertiesList instanceof SdkAutoConstructList);
    }

    public List<DocumentClassificationJobProperties> documentClassificationJobPropertiesList() {
        return this.documentClassificationJobPropertiesList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentClassificationJobPropertiesList() ? this.documentClassificationJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentClassificationJobsResponse)) {
            return false;
        }
        ListDocumentClassificationJobsResponse other = (ListDocumentClassificationJobsResponse)((Object)obj);
        return this.hasDocumentClassificationJobPropertiesList() == other.hasDocumentClassificationJobPropertiesList() && Objects.equals(this.documentClassificationJobPropertiesList(), other.documentClassificationJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDocumentClassificationJobsResponse").add("DocumentClassificationJobPropertiesList", this.hasDocumentClassificationJobPropertiesList() ? this.documentClassificationJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentClassificationJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.documentClassificationJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentClassificationJobsResponse, T> g) {
        return obj -> g.apply((ListDocumentClassificationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DocumentClassificationJobProperties> documentClassificationJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentClassificationJobsResponse model) {
            super(model);
            this.documentClassificationJobPropertiesList(model.documentClassificationJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<DocumentClassificationJobProperties.Builder> getDocumentClassificationJobPropertiesList() {
            if (this.documentClassificationJobPropertiesList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.documentClassificationJobPropertiesList != null ? (Collection)this.documentClassificationJobPropertiesList.stream().map(DocumentClassificationJobProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentClassificationJobPropertiesList(Collection<DocumentClassificationJobProperties> documentClassificationJobPropertiesList) {
            this.documentClassificationJobPropertiesList = DocumentClassificationJobPropertiesListCopier.copy(documentClassificationJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassificationJobPropertiesList(DocumentClassificationJobProperties ... documentClassificationJobPropertiesList) {
            this.documentClassificationJobPropertiesList(Arrays.asList(documentClassificationJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassificationJobPropertiesList(Consumer<DocumentClassificationJobProperties.Builder> ... documentClassificationJobPropertiesList) {
            this.documentClassificationJobPropertiesList(Stream.of(documentClassificationJobPropertiesList).map(c -> (DocumentClassificationJobProperties)((DocumentClassificationJobProperties.Builder)DocumentClassificationJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentClassificationJobPropertiesList(Collection<DocumentClassificationJobProperties.BuilderImpl> documentClassificationJobPropertiesList) {
            this.documentClassificationJobPropertiesList = DocumentClassificationJobPropertiesListCopier.copyFromBuilder(documentClassificationJobPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDocumentClassificationJobsResponse build() {
            return new ListDocumentClassificationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDocumentClassificationJobsResponse> {
        public Builder documentClassificationJobPropertiesList(Collection<DocumentClassificationJobProperties> var1);

        public Builder documentClassificationJobPropertiesList(DocumentClassificationJobProperties ... var1);

        public Builder documentClassificationJobPropertiesList(Consumer<DocumentClassificationJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

