/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.AugmentedManifestsListItem;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerAnnotations;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerAugmentedManifestsListCopier;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerEntityList;
import software.amazon.awssdk.services.comprehend.model.EntityTypesListCopier;
import software.amazon.awssdk.services.comprehend.model.EntityTypesListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityRecognizerInputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityRecognizerInputDataConfig> {
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(EntityRecognizerInputDataConfig.getter(EntityRecognizerInputDataConfig::dataFormatAsString)).setter(EntityRecognizerInputDataConfig.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<List<EntityTypesListItem>> ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityTypes").getter(EntityRecognizerInputDataConfig.getter(EntityRecognizerInputDataConfig::entityTypes)).setter(EntityRecognizerInputDataConfig.setter(Builder::entityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityTypesListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EntityRecognizerDocuments> DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Documents").getter(EntityRecognizerInputDataConfig.getter(EntityRecognizerInputDataConfig::documents)).setter(EntityRecognizerInputDataConfig.setter(Builder::documents)).constructor(EntityRecognizerDocuments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build()}).build();
    private static final SdkField<EntityRecognizerAnnotations> ANNOTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Annotations").getter(EntityRecognizerInputDataConfig.getter(EntityRecognizerInputDataConfig::annotations)).setter(EntityRecognizerInputDataConfig.setter(Builder::annotations)).constructor(EntityRecognizerAnnotations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build()}).build();
    private static final SdkField<EntityRecognizerEntityList> ENTITY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityList").getter(EntityRecognizerInputDataConfig.getter(EntityRecognizerInputDataConfig::entityList)).setter(EntityRecognizerInputDataConfig.setter(Builder::entityList)).constructor(EntityRecognizerEntityList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityList").build()}).build();
    private static final SdkField<List<AugmentedManifestsListItem>> AUGMENTED_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AugmentedManifests").getter(EntityRecognizerInputDataConfig.getter(EntityRecognizerInputDataConfig::augmentedManifests)).setter(EntityRecognizerInputDataConfig.setter(Builder::augmentedManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AugmentedManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AugmentedManifestsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FORMAT_FIELD, ENTITY_TYPES_FIELD, DOCUMENTS_FIELD, ANNOTATIONS_FIELD, ENTITY_LIST_FIELD, AUGMENTED_MANIFESTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataFormat;
    private final List<EntityTypesListItem> entityTypes;
    private final EntityRecognizerDocuments documents;
    private final EntityRecognizerAnnotations annotations;
    private final EntityRecognizerEntityList entityList;
    private final List<AugmentedManifestsListItem> augmentedManifests;

    private EntityRecognizerInputDataConfig(BuilderImpl builder) {
        this.dataFormat = builder.dataFormat;
        this.entityTypes = builder.entityTypes;
        this.documents = builder.documents;
        this.annotations = builder.annotations;
        this.entityList = builder.entityList;
        this.augmentedManifests = builder.augmentedManifests;
    }

    public EntityRecognizerDataFormat dataFormat() {
        return EntityRecognizerDataFormat.fromValue(this.dataFormat);
    }

    public String dataFormatAsString() {
        return this.dataFormat;
    }

    public boolean hasEntityTypes() {
        return this.entityTypes != null && !(this.entityTypes instanceof SdkAutoConstructList);
    }

    public List<EntityTypesListItem> entityTypes() {
        return this.entityTypes;
    }

    public EntityRecognizerDocuments documents() {
        return this.documents;
    }

    public EntityRecognizerAnnotations annotations() {
        return this.annotations;
    }

    public EntityRecognizerEntityList entityList() {
        return this.entityList;
    }

    public boolean hasAugmentedManifests() {
        return this.augmentedManifests != null && !(this.augmentedManifests instanceof SdkAutoConstructList);
    }

    public List<AugmentedManifestsListItem> augmentedManifests() {
        return this.augmentedManifests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.documents());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotations());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityList());
        hashCode = 31 * hashCode + Objects.hashCode(this.augmentedManifests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerInputDataConfig)) {
            return false;
        }
        EntityRecognizerInputDataConfig other = (EntityRecognizerInputDataConfig)obj;
        return Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.entityTypes(), other.entityTypes()) && Objects.equals(this.documents(), other.documents()) && Objects.equals(this.annotations(), other.annotations()) && Objects.equals(this.entityList(), other.entityList()) && Objects.equals(this.augmentedManifests(), other.augmentedManifests());
    }

    public String toString() {
        return ToString.builder((String)"EntityRecognizerInputDataConfig").add("DataFormat", (Object)this.dataFormatAsString()).add("EntityTypes", this.entityTypes()).add("Documents", (Object)this.documents()).add("Annotations", (Object)this.annotations()).add("EntityList", (Object)this.entityList()).add("AugmentedManifests", this.augmentedManifests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "EntityTypes": {
                return Optional.ofNullable(clazz.cast(this.entityTypes()));
            }
            case "Documents": {
                return Optional.ofNullable(clazz.cast(this.documents()));
            }
            case "Annotations": {
                return Optional.ofNullable(clazz.cast(this.annotations()));
            }
            case "EntityList": {
                return Optional.ofNullable(clazz.cast(this.entityList()));
            }
            case "AugmentedManifests": {
                return Optional.ofNullable(clazz.cast(this.augmentedManifests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerInputDataConfig, T> g) {
        return obj -> g.apply((EntityRecognizerInputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataFormat;
        private List<EntityTypesListItem> entityTypes = DefaultSdkAutoConstructList.getInstance();
        private EntityRecognizerDocuments documents;
        private EntityRecognizerAnnotations annotations;
        private EntityRecognizerEntityList entityList;
        private List<AugmentedManifestsListItem> augmentedManifests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerInputDataConfig model) {
            this.dataFormat(model.dataFormat);
            this.entityTypes(model.entityTypes);
            this.documents(model.documents);
            this.annotations(model.annotations);
            this.entityList(model.entityList);
            this.augmentedManifests(model.augmentedManifests);
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(EntityRecognizerDataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public final Collection<EntityTypesListItem.Builder> getEntityTypes() {
            return this.entityTypes != null ? (Collection)this.entityTypes.stream().map(EntityTypesListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entityTypes(Collection<EntityTypesListItem> entityTypes) {
            this.entityTypes = EntityTypesListCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityTypesListItem ... entityTypes) {
            this.entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(Consumer<EntityTypesListItem.Builder> ... entityTypes) {
            this.entityTypes(Stream.of(entityTypes).map(c -> (EntityTypesListItem)((EntityTypesListItem.Builder)EntityTypesListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntityTypes(Collection<EntityTypesListItem.BuilderImpl> entityTypes) {
            this.entityTypes = EntityTypesListCopier.copyFromBuilder(entityTypes);
        }

        public final EntityRecognizerDocuments.Builder getDocuments() {
            return this.documents != null ? this.documents.toBuilder() : null;
        }

        @Override
        public final Builder documents(EntityRecognizerDocuments documents) {
            this.documents = documents;
            return this;
        }

        public final void setDocuments(EntityRecognizerDocuments.BuilderImpl documents) {
            this.documents = documents != null ? documents.build() : null;
        }

        public final EntityRecognizerAnnotations.Builder getAnnotations() {
            return this.annotations != null ? this.annotations.toBuilder() : null;
        }

        @Override
        public final Builder annotations(EntityRecognizerAnnotations annotations) {
            this.annotations = annotations;
            return this;
        }

        public final void setAnnotations(EntityRecognizerAnnotations.BuilderImpl annotations) {
            this.annotations = annotations != null ? annotations.build() : null;
        }

        public final EntityRecognizerEntityList.Builder getEntityList() {
            return this.entityList != null ? this.entityList.toBuilder() : null;
        }

        @Override
        public final Builder entityList(EntityRecognizerEntityList entityList) {
            this.entityList = entityList;
            return this;
        }

        public final void setEntityList(EntityRecognizerEntityList.BuilderImpl entityList) {
            this.entityList = entityList != null ? entityList.build() : null;
        }

        public final Collection<AugmentedManifestsListItem.Builder> getAugmentedManifests() {
            return this.augmentedManifests != null ? (Collection)this.augmentedManifests.stream().map(AugmentedManifestsListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder augmentedManifests(Collection<AugmentedManifestsListItem> augmentedManifests) {
            this.augmentedManifests = EntityRecognizerAugmentedManifestsListCopier.copy(augmentedManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder augmentedManifests(AugmentedManifestsListItem ... augmentedManifests) {
            this.augmentedManifests(Arrays.asList(augmentedManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder augmentedManifests(Consumer<AugmentedManifestsListItem.Builder> ... augmentedManifests) {
            this.augmentedManifests(Stream.of(augmentedManifests).map(c -> (AugmentedManifestsListItem)((AugmentedManifestsListItem.Builder)AugmentedManifestsListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAugmentedManifests(Collection<AugmentedManifestsListItem.BuilderImpl> augmentedManifests) {
            this.augmentedManifests = EntityRecognizerAugmentedManifestsListCopier.copyFromBuilder(augmentedManifests);
        }

        public EntityRecognizerInputDataConfig build() {
            return new EntityRecognizerInputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityRecognizerInputDataConfig> {
        public Builder dataFormat(String var1);

        public Builder dataFormat(EntityRecognizerDataFormat var1);

        public Builder entityTypes(Collection<EntityTypesListItem> var1);

        public Builder entityTypes(EntityTypesListItem ... var1);

        public Builder entityTypes(Consumer<EntityTypesListItem.Builder> ... var1);

        public Builder documents(EntityRecognizerDocuments var1);

        default public Builder documents(Consumer<EntityRecognizerDocuments.Builder> documents) {
            return this.documents((EntityRecognizerDocuments)((EntityRecognizerDocuments.Builder)EntityRecognizerDocuments.builder().applyMutation(documents)).build());
        }

        public Builder annotations(EntityRecognizerAnnotations var1);

        default public Builder annotations(Consumer<EntityRecognizerAnnotations.Builder> annotations) {
            return this.annotations((EntityRecognizerAnnotations)((EntityRecognizerAnnotations.Builder)EntityRecognizerAnnotations.builder().applyMutation(annotations)).build());
        }

        public Builder entityList(EntityRecognizerEntityList var1);

        default public Builder entityList(Consumer<EntityRecognizerEntityList.Builder> entityList) {
            return this.entityList((EntityRecognizerEntityList)((EntityRecognizerEntityList.Builder)EntityRecognizerEntityList.builder().applyMutation(entityList)).build());
        }

        public Builder augmentedManifests(Collection<AugmentedManifestsListItem> var1);

        public Builder augmentedManifests(AugmentedManifestsListItem ... var1);

        public Builder augmentedManifests(Consumer<AugmentedManifestsListItem.Builder> ... var1);
    }
}

