/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.AttributeNamesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AugmentedManifestsListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AugmentedManifestsListItem> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AugmentedManifestsListItem.getter(AugmentedManifestsListItem::s3Uri)).setter(AugmentedManifestsListItem.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AugmentedManifestsListItem.getter(AugmentedManifestsListItem::attributeNames)).setter(AugmentedManifestsListItem.setter(Builder::attributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, ATTRIBUTE_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final List<String> attributeNames;

    private AugmentedManifestsListItem(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.attributeNames = builder.attributeNames;
    }

    public String s3Uri() {
        return this.s3Uri;
    }

    public boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AugmentedManifestsListItem)) {
            return false;
        }
        AugmentedManifestsListItem other = (AugmentedManifestsListItem)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.attributeNames(), other.attributeNames());
    }

    public String toString() {
        return ToString.builder((String)"AugmentedManifestsListItem").add("S3Uri", (Object)this.s3Uri()).add("AttributeNames", this.attributeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AugmentedManifestsListItem, T> g) {
        return obj -> g.apply((AugmentedManifestsListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AugmentedManifestsListItem model) {
            this.s3Uri(model.s3Uri);
            this.attributeNames(model.attributeNames);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNamesListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNamesListCopier.copy(attributeNames);
        }

        public AugmentedManifestsListItem build() {
            return new AugmentedManifestsListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AugmentedManifestsListItem> {
        public Builder s3Uri(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);
    }
}

