/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.InputFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDataConfig.getter(InputDataConfig::s3Uri)).setter(InputDataConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDataConfig.getter(InputDataConfig::inputFormatAsString)).setter(InputDataConfig.setter(Builder::inputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, INPUT_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String inputFormat;

    private InputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.inputFormat = builder.inputFormat;
    }

    public String s3Uri() {
        return this.s3Uri;
    }

    public InputFormat inputFormat() {
        return InputFormat.fromValue(this.inputFormat);
    }

    public String inputFormatAsString() {
        return this.inputFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.inputFormatAsString(), other.inputFormatAsString());
    }

    public String toString() {
        return ToString.builder((String)"InputDataConfig").add("S3Uri", (Object)this.s3Uri()).add("InputFormat", (Object)this.inputFormatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "InputFormat": {
                return Optional.ofNullable(clazz.cast(this.inputFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDataConfig, T> g) {
        return obj -> g.apply((InputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String inputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            this.s3Uri(model.s3Uri);
            this.inputFormat(model.inputFormat);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getInputFormat() {
            return this.inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        public InputDataConfig build() {
            return new InputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDataConfig> {
        public Builder s3Uri(String var1);

        public Builder inputFormat(String var1);

        public Builder inputFormat(InputFormat var1);
    }
}

