/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the format and location of the input data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityRecognizerInputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityRecognizerInputDataConfig.Builder, EntityRecognizerInputDataConfig> {
    private static final SdkField<List<EntityTypesListItem>> ENTITY_TYPES_FIELD = SdkField
            .<List<EntityTypesListItem>> builder(MarshallingType.LIST)
            .getter(getter(EntityRecognizerInputDataConfig::entityTypes))
            .setter(setter(Builder::entityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityTypesListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityTypesListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EntityRecognizerDocuments> DOCUMENTS_FIELD = SdkField
            .<EntityRecognizerDocuments> builder(MarshallingType.SDK_POJO)
            .getter(getter(EntityRecognizerInputDataConfig::documents)).setter(setter(Builder::documents))
            .constructor(EntityRecognizerDocuments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build()).build();

    private static final SdkField<EntityRecognizerAnnotations> ANNOTATIONS_FIELD = SdkField
            .<EntityRecognizerAnnotations> builder(MarshallingType.SDK_POJO)
            .getter(getter(EntityRecognizerInputDataConfig::annotations)).setter(setter(Builder::annotations))
            .constructor(EntityRecognizerAnnotations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build()).build();

    private static final SdkField<EntityRecognizerEntityList> ENTITY_LIST_FIELD = SdkField
            .<EntityRecognizerEntityList> builder(MarshallingType.SDK_POJO)
            .getter(getter(EntityRecognizerInputDataConfig::entityList)).setter(setter(Builder::entityList))
            .constructor(EntityRecognizerEntityList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPES_FIELD,
            DOCUMENTS_FIELD, ANNOTATIONS_FIELD, ENTITY_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EntityTypesListItem> entityTypes;

    private final EntityRecognizerDocuments documents;

    private final EntityRecognizerAnnotations annotations;

    private final EntityRecognizerEntityList entityList;

    private EntityRecognizerInputDataConfig(BuilderImpl builder) {
        this.entityTypes = builder.entityTypes;
        this.documents = builder.documents;
        this.annotations = builder.annotations;
        this.entityList = builder.entityList;
    }

    /**
     * Returns true if the EntityTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntityTypes() {
        return entityTypes != null && !(entityTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entity types in the input data for an entity recognizer. A maximum of 12 entity types can be used at one time
     * to train an entity recognizer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntityTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The entity types in the input data for an entity recognizer. A maximum of 12 entity types can be used at
     *         one time to train an entity recognizer.
     */
    public List<EntityTypesListItem> entityTypes() {
        return entityTypes;
    }

    /**
     * <p>
     * S3 location of the documents folder for an entity recognizer
     * </p>
     * 
     * @return S3 location of the documents folder for an entity recognizer
     */
    public EntityRecognizerDocuments documents() {
        return documents;
    }

    /**
     * <p>
     * S3 location of the annotations file for an entity recognizer.
     * </p>
     * 
     * @return S3 location of the annotations file for an entity recognizer.
     */
    public EntityRecognizerAnnotations annotations() {
        return annotations;
    }

    /**
     * <p>
     * S3 location of the entity list for an entity recognizer.
     * </p>
     * 
     * @return S3 location of the entity list for an entity recognizer.
     */
    public EntityRecognizerEntityList entityList() {
        return entityList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(documents());
        hashCode = 31 * hashCode + Objects.hashCode(annotations());
        hashCode = 31 * hashCode + Objects.hashCode(entityList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerInputDataConfig)) {
            return false;
        }
        EntityRecognizerInputDataConfig other = (EntityRecognizerInputDataConfig) obj;
        return Objects.equals(entityTypes(), other.entityTypes()) && Objects.equals(documents(), other.documents())
                && Objects.equals(annotations(), other.annotations()) && Objects.equals(entityList(), other.entityList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EntityRecognizerInputDataConfig").add("EntityTypes", entityTypes())
                .add("Documents", documents()).add("Annotations", annotations()).add("EntityList", entityList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityTypes":
            return Optional.ofNullable(clazz.cast(entityTypes()));
        case "Documents":
            return Optional.ofNullable(clazz.cast(documents()));
        case "Annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        case "EntityList":
            return Optional.ofNullable(clazz.cast(entityList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerInputDataConfig, T> g) {
        return obj -> g.apply((EntityRecognizerInputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityRecognizerInputDataConfig> {
        /**
         * <p>
         * The entity types in the input data for an entity recognizer. A maximum of 12 entity types can be used at one
         * time to train an entity recognizer.
         * </p>
         * 
         * @param entityTypes
         *        The entity types in the input data for an entity recognizer. A maximum of 12 entity types can be used
         *        at one time to train an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(Collection<EntityTypesListItem> entityTypes);

        /**
         * <p>
         * The entity types in the input data for an entity recognizer. A maximum of 12 entity types can be used at one
         * time to train an entity recognizer.
         * </p>
         * 
         * @param entityTypes
         *        The entity types in the input data for an entity recognizer. A maximum of 12 entity types can be used
         *        at one time to train an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(EntityTypesListItem... entityTypes);

        /**
         * <p>
         * The entity types in the input data for an entity recognizer. A maximum of 12 entity types can be used at one
         * time to train an entity recognizer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntityTypesListItem>.Builder} avoiding the
         * need to create one manually via {@link List<EntityTypesListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntityTypesListItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #entityTypes(List<EntityTypesListItem>)}.
         * 
         * @param entityTypes
         *        a consumer that will call methods on {@link List<EntityTypesListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityTypes(List<EntityTypesListItem>)
         */
        Builder entityTypes(Consumer<EntityTypesListItem.Builder>... entityTypes);

        /**
         * <p>
         * S3 location of the documents folder for an entity recognizer
         * </p>
         * 
         * @param documents
         *        S3 location of the documents folder for an entity recognizer
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(EntityRecognizerDocuments documents);

        /**
         * <p>
         * S3 location of the documents folder for an entity recognizer
         * </p>
         * This is a convenience that creates an instance of the {@link EntityRecognizerDocuments.Builder} avoiding the
         * need to create one manually via {@link EntityRecognizerDocuments#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityRecognizerDocuments.Builder#build()} is called immediately
         * and its result is passed to {@link #documents(EntityRecognizerDocuments)}.
         * 
         * @param documents
         *        a consumer that will call methods on {@link EntityRecognizerDocuments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(EntityRecognizerDocuments)
         */
        default Builder documents(Consumer<EntityRecognizerDocuments.Builder> documents) {
            return documents(EntityRecognizerDocuments.builder().applyMutation(documents).build());
        }

        /**
         * <p>
         * S3 location of the annotations file for an entity recognizer.
         * </p>
         * 
         * @param annotations
         *        S3 location of the annotations file for an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(EntityRecognizerAnnotations annotations);

        /**
         * <p>
         * S3 location of the annotations file for an entity recognizer.
         * </p>
         * This is a convenience that creates an instance of the {@link EntityRecognizerAnnotations.Builder} avoiding
         * the need to create one manually via {@link EntityRecognizerAnnotations#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityRecognizerAnnotations.Builder#build()} is called
         * immediately and its result is passed to {@link #annotations(EntityRecognizerAnnotations)}.
         * 
         * @param annotations
         *        a consumer that will call methods on {@link EntityRecognizerAnnotations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotations(EntityRecognizerAnnotations)
         */
        default Builder annotations(Consumer<EntityRecognizerAnnotations.Builder> annotations) {
            return annotations(EntityRecognizerAnnotations.builder().applyMutation(annotations).build());
        }

        /**
         * <p>
         * S3 location of the entity list for an entity recognizer.
         * </p>
         * 
         * @param entityList
         *        S3 location of the entity list for an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityList(EntityRecognizerEntityList entityList);

        /**
         * <p>
         * S3 location of the entity list for an entity recognizer.
         * </p>
         * This is a convenience that creates an instance of the {@link EntityRecognizerEntityList.Builder} avoiding the
         * need to create one manually via {@link EntityRecognizerEntityList#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityRecognizerEntityList.Builder#build()} is called immediately
         * and its result is passed to {@link #entityList(EntityRecognizerEntityList)}.
         * 
         * @param entityList
         *        a consumer that will call methods on {@link EntityRecognizerEntityList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityList(EntityRecognizerEntityList)
         */
        default Builder entityList(Consumer<EntityRecognizerEntityList.Builder> entityList) {
            return entityList(EntityRecognizerEntityList.builder().applyMutation(entityList).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<EntityTypesListItem> entityTypes = DefaultSdkAutoConstructList.getInstance();

        private EntityRecognizerDocuments documents;

        private EntityRecognizerAnnotations annotations;

        private EntityRecognizerEntityList entityList;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerInputDataConfig model) {
            entityTypes(model.entityTypes);
            documents(model.documents);
            annotations(model.annotations);
            entityList(model.entityList);
        }

        public final Collection<EntityTypesListItem.Builder> getEntityTypes() {
            return entityTypes != null ? entityTypes.stream().map(EntityTypesListItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder entityTypes(Collection<EntityTypesListItem> entityTypes) {
            this.entityTypes = EntityTypesListCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityTypesListItem... entityTypes) {
            entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(Consumer<EntityTypesListItem.Builder>... entityTypes) {
            entityTypes(Stream.of(entityTypes).map(c -> EntityTypesListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntityTypes(Collection<EntityTypesListItem.BuilderImpl> entityTypes) {
            this.entityTypes = EntityTypesListCopier.copyFromBuilder(entityTypes);
        }

        public final EntityRecognizerDocuments.Builder getDocuments() {
            return documents != null ? documents.toBuilder() : null;
        }

        @Override
        public final Builder documents(EntityRecognizerDocuments documents) {
            this.documents = documents;
            return this;
        }

        public final void setDocuments(EntityRecognizerDocuments.BuilderImpl documents) {
            this.documents = documents != null ? documents.build() : null;
        }

        public final EntityRecognizerAnnotations.Builder getAnnotations() {
            return annotations != null ? annotations.toBuilder() : null;
        }

        @Override
        public final Builder annotations(EntityRecognizerAnnotations annotations) {
            this.annotations = annotations;
            return this;
        }

        public final void setAnnotations(EntityRecognizerAnnotations.BuilderImpl annotations) {
            this.annotations = annotations != null ? annotations.build() : null;
        }

        public final EntityRecognizerEntityList.Builder getEntityList() {
            return entityList != null ? entityList.toBuilder() : null;
        }

        @Override
        public final Builder entityList(EntityRecognizerEntityList entityList) {
            this.entityList = entityList;
            return this;
        }

        public final void setEntityList(EntityRecognizerEntityList.BuilderImpl entityList) {
            this.entityList = entityList != null ? entityList.build() : null;
        }

        @Override
        public EntityRecognizerInputDataConfig build() {
            return new EntityRecognizerInputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
