/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopEntitiesDetectionJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<StopEntitiesDetectionJobResponse.Builder, StopEntitiesDetectionJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopEntitiesDetectionJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopEntitiesDetectionJobResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOB_ID_FIELD, JOB_STATUS_FIELD));

    private final String jobId;

    private final String jobStatus;

    private StopEntitiesDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobStatus = builder.jobStatus;
    }

    /**
     * <p>
     * The identifier of the entities detection job to stop.
     * </p>
     * 
     * @return The identifier of the entities detection job to stop.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was
     * previously stopped with the <code>StopEntitiesDetectionJob</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job
     *         was previously stopped with the <code>StopEntitiesDetectionJob</code> operation.
     * @see JobStatus
     */
    public JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was
     * previously stopped with the <code>StopEntitiesDetectionJob</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job
     *         was previously stopped with the <code>StopEntitiesDetectionJob</code> operation.
     * @see JobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopEntitiesDetectionJobResponse)) {
            return false;
        }
        StopEntitiesDetectionJobResponse other = (StopEntitiesDetectionJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StopEntitiesDetectionJobResponse").add("JobId", jobId()).add("JobStatus", jobStatusAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopEntitiesDetectionJobResponse, T> g) {
        return obj -> g.apply((StopEntitiesDetectionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopEntitiesDetectionJobResponse> {
        /**
         * <p>
         * The identifier of the entities detection job to stop.
         * </p>
         * 
         * @param jobId
         *        The identifier of the entities detection job to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was
         * previously stopped with the <code>StopEntitiesDetectionJob</code> operation.
         * </p>
         * 
         * @param jobStatus
         *        Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job
         *        was previously stopped with the <code>StopEntitiesDetectionJob</code> operation.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was
         * previously stopped with the <code>StopEntitiesDetectionJob</code> operation.
         * </p>
         * 
         * @param jobStatus
         *        Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job
         *        was previously stopped with the <code>StopEntitiesDetectionJob</code> operation.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private String jobId;

        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StopEntitiesDetectionJobResponse model) {
            super(model);
            jobId(model.jobId);
            jobStatus(model.jobStatus);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobStatusAsString() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public StopEntitiesDetectionJobResponse build() {
            return new StopEntitiesDetectionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
