/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartKeyPhrasesDetectionJobRequest extends ComprehendRequest implements
        ToCopyableBuilder<StartKeyPhrasesDetectionJobRequest.Builder, StartKeyPhrasesDetectionJobRequest> {
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartKeyPhrasesDetectionJobRequest::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartKeyPhrasesDetectionJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartKeyPhrasesDetectionJobRequest::dataAccessRoleArn)).setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartKeyPhrasesDetectionJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartKeyPhrasesDetectionJobRequest::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(StartKeyPhrasesDetectionJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartKeyPhrasesDetectionJobRequest::volumeKmsKeyId)).setter(setter(Builder::volumeKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartKeyPhrasesDetectionJobRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DATA_CONFIG_FIELD,
            OUTPUT_DATA_CONFIG_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, JOB_NAME_FIELD, LANGUAGE_CODE_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, VOLUME_KMS_KEY_ID_FIELD, VPC_CONFIG_FIELD));

    private final InputDataConfig inputDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final String dataAccessRoleArn;

    private final String jobName;

    private final String languageCode;

    private final String clientRequestToken;

    private final String volumeKmsKeyId;

    private final VpcConfig vpcConfig;

    private StartKeyPhrasesDetectionJobRequest(BuilderImpl builder) {
        super(builder);
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.jobName = builder.jobName;
        this.languageCode = builder.languageCode;
        this.clientRequestToken = builder.clientRequestToken;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * Specifies the format and location of the input data for the job.
     * </p>
     * 
     * @return Specifies the format and location of the input data for the job.
     */
    public InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Specifies where to send the output files.
     * </p>
     * 
     * @return Specifies where to send the output files.
     */
    public OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend
     * read access to your input data. For more information, see <a href=
     * "https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions"
     * >https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions<
     * /a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon
     *         Comprehend read access to your input data. For more information, see <a href=
     *         "https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions"
     *         >https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-
     *         permissions</a>.
     */
    public String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * The identifier of the job.
     * </p>
     * 
     * @return The identifier of the job.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the primary languages supported by Amazon
     *         Comprehend. All documents must be in the same language.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the primary languages supported by Amazon
     *         Comprehend. All documents must be in the same language.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.
     * </p>
     * 
     * @return A unique identifier for the request. If you don't set the client request token, Amazon Comprehend
     *         generates one.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume
     * attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the
     * following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Resource Name (ARN) of a KMS Key:
     * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the
     *         storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId
     *         can be either of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Resource Name (ARN) of a KMS Key:
     *         <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     */
    public String volumeKmsKeyId() {
        return volumeKmsKeyId;
    }

    /**
     * <p>
     * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are
     * using for your key phrases detection job. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
     * </p>
     * 
     * @return Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you
     *         are using for your key phrases detection job. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartKeyPhrasesDetectionJobRequest)) {
            return false;
        }
        StartKeyPhrasesDetectionJobRequest other = (StartKeyPhrasesDetectionJobRequest) obj;
        return Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartKeyPhrasesDetectionJobRequest").add("InputDataConfig", inputDataConfig())
                .add("OutputDataConfig", outputDataConfig()).add("DataAccessRoleArn", dataAccessRoleArn())
                .add("JobName", jobName()).add("LanguageCode", languageCodeAsString())
                .add("ClientRequestToken", clientRequestToken()).add("VolumeKmsKeyId", volumeKmsKeyId())
                .add("VpcConfig", vpcConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "VolumeKmsKeyId":
            return Optional.ofNullable(clazz.cast(volumeKmsKeyId()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartKeyPhrasesDetectionJobRequest, T> g) {
        return obj -> g.apply((StartKeyPhrasesDetectionJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartKeyPhrasesDetectionJobRequest> {
        /**
         * <p>
         * Specifies the format and location of the input data for the job.
         * </p>
         * 
         * @param inputDataConfig
         *        Specifies the format and location of the input data for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * Specifies the format and location of the input data for the job.
         * </p>
         * This is a convenience that creates an instance of the {@link InputDataConfig.Builder} avoiding the need to
         * create one manually via {@link InputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * Specifies where to send the output files.
         * </p>
         * 
         * @param outputDataConfig
         *        Specifies where to send the output files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * Specifies where to send the output files.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputDataConfig.Builder} avoiding the need to
         * create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon
         * Comprehend read access to your input data. For more information, see <a href=
         * "https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions"
         * >https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-
         * permissions</a>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon
         *        Comprehend read access to your input data. For more information, see <a href=
         *        "https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions"
         *        >https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-
         *        permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * The identifier of the job.
         * </p>
         * 
         * @param jobName
         *        The identifier of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The language of the input documents. You can specify any of the primary languages supported by Amazon
         * Comprehend. All documents must be in the same language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the primary languages supported by Amazon
         *        Comprehend. All documents must be in the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language of the input documents. You can specify any of the primary languages supported by Amazon
         * Comprehend. All documents must be in the same language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the primary languages supported by Amazon
         *        Comprehend. All documents must be in the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates
         * one.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for the request. If you don't set the client request token, Amazon Comprehend
         *        generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage
         * volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either
         * of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Resource Name (ARN) of a KMS Key:
         * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeKmsKeyId
         *        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the
         *        storage volume attached to the ML compute instance(s) that process the analysis job. The
         *        VolumeKmsKeyId can be either of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN) of a KMS Key:
         *        <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeKmsKeyId(String volumeKmsKeyId);

        /**
         * <p>
         * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are
         * using for your key phrases detection job. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * </p>
         * 
         * @param vpcConfig
         *        Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources
         *        you are using for your key phrases detection job. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are
         * using for your key phrases detection job. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private InputDataConfig inputDataConfig;

        private OutputDataConfig outputDataConfig;

        private String dataAccessRoleArn;

        private String jobName;

        private String languageCode;

        private String clientRequestToken;

        private String volumeKmsKeyId;

        private VpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartKeyPhrasesDetectionJobRequest model) {
            super(model);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            dataAccessRoleArn(model.dataAccessRoleArn);
            jobName(model.jobName);
            languageCode(model.languageCode);
            clientRequestToken(model.clientRequestToken);
            volumeKmsKeyId(model.volumeKmsKeyId);
            vpcConfig(model.vpcConfig);
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getLanguageCodeAsString() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getVolumeKmsKeyId() {
            return volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartKeyPhrasesDetectionJobRequest build() {
            return new StartKeyPhrasesDetectionJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
