/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEntitiesDetectionJobsResponse extends ComprehendResponse implements
        ToCopyableBuilder<ListEntitiesDetectionJobsResponse.Builder, ListEntitiesDetectionJobsResponse> {
    private static final SdkField<List<EntitiesDetectionJobProperties>> ENTITIES_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField
            .<List<EntitiesDetectionJobProperties>> builder(MarshallingType.LIST)
            .getter(getter(ListEntitiesDetectionJobsResponse::entitiesDetectionJobPropertiesList))
            .setter(setter(Builder::entitiesDetectionJobPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitiesDetectionJobPropertiesList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntitiesDetectionJobProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntitiesDetectionJobProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEntitiesDetectionJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENTITIES_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList;

    private final String nextToken;

    private ListEntitiesDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.entitiesDetectionJobPropertiesList = builder.entitiesDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EntitiesDetectionJobPropertiesList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasEntitiesDetectionJobPropertiesList() {
        return entitiesDetectionJobPropertiesList != null
                && !(entitiesDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the properties of each job that is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntitiesDetectionJobPropertiesList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list containing the properties of each job that is returned.
     */
    public List<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList() {
        return entitiesDetectionJobPropertiesList;
    }

    /**
     * <p>
     * Identifies the next page of results to return.
     * </p>
     * 
     * @return Identifies the next page of results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entitiesDetectionJobPropertiesList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesDetectionJobsResponse)) {
            return false;
        }
        ListEntitiesDetectionJobsResponse other = (ListEntitiesDetectionJobsResponse) obj;
        return Objects.equals(entitiesDetectionJobPropertiesList(), other.entitiesDetectionJobPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListEntitiesDetectionJobsResponse")
                .add("EntitiesDetectionJobPropertiesList", entitiesDetectionJobPropertiesList()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntitiesDetectionJobPropertiesList":
            return Optional.ofNullable(clazz.cast(entitiesDetectionJobPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListEntitiesDetectionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEntitiesDetectionJobsResponse> {
        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * 
         * @param entitiesDetectionJobPropertiesList
         *        A list containing the properties of each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitiesDetectionJobPropertiesList(Collection<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * 
         * @param entitiesDetectionJobPropertiesList
         *        A list containing the properties of each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitiesDetectionJobPropertiesList(EntitiesDetectionJobProperties... entitiesDetectionJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntitiesDetectionJobProperties>.Builder}
         * avoiding the need to create one manually via {@link List<EntitiesDetectionJobProperties>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntitiesDetectionJobProperties>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #entitiesDetectionJobPropertiesList(List<EntitiesDetectionJobProperties>)}.
         * 
         * @param entitiesDetectionJobPropertiesList
         *        a consumer that will call methods on {@link List<EntitiesDetectionJobProperties>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitiesDetectionJobPropertiesList(List<EntitiesDetectionJobProperties>)
         */
        Builder entitiesDetectionJobPropertiesList(
                Consumer<EntitiesDetectionJobProperties.Builder>... entitiesDetectionJobPropertiesList);

        /**
         * <p>
         * Identifies the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesDetectionJobsResponse model) {
            super(model);
            entitiesDetectionJobPropertiesList(model.entitiesDetectionJobPropertiesList);
            nextToken(model.nextToken);
        }

        public final Collection<EntitiesDetectionJobProperties.Builder> getEntitiesDetectionJobPropertiesList() {
            return entitiesDetectionJobPropertiesList != null ? entitiesDetectionJobPropertiesList.stream()
                    .map(EntitiesDetectionJobProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitiesDetectionJobPropertiesList(
                Collection<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList = EntitiesDetectionJobPropertiesListCopier
                    .copy(entitiesDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitiesDetectionJobPropertiesList(
                EntitiesDetectionJobProperties... entitiesDetectionJobPropertiesList) {
            entitiesDetectionJobPropertiesList(Arrays.asList(entitiesDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitiesDetectionJobPropertiesList(
                Consumer<EntitiesDetectionJobProperties.Builder>... entitiesDetectionJobPropertiesList) {
            entitiesDetectionJobPropertiesList(Stream.of(entitiesDetectionJobPropertiesList)
                    .map(c -> EntitiesDetectionJobProperties.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntitiesDetectionJobPropertiesList(
                Collection<EntitiesDetectionJobProperties.BuilderImpl> entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList = EntitiesDetectionJobPropertiesListCopier
                    .copyFromBuilder(entitiesDetectionJobPropertiesList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEntitiesDetectionJobsResponse build() {
            return new ListEntitiesDetectionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
