/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an entity recognizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityRecognizerMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityRecognizerMetadata.Builder, EntityRecognizerMetadata> {
    private static final SdkField<Integer> NUMBER_OF_TRAINED_DOCUMENTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(EntityRecognizerMetadata::numberOfTrainedDocuments))
            .setter(setter(Builder::numberOfTrainedDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTrainedDocuments").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_TEST_DOCUMENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EntityRecognizerMetadata::numberOfTestDocuments)).setter(setter(Builder::numberOfTestDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTestDocuments").build())
            .build();

    private static final SdkField<EntityRecognizerEvaluationMetrics> EVALUATION_METRICS_FIELD = SdkField
            .<EntityRecognizerEvaluationMetrics> builder(MarshallingType.SDK_POJO)
            .getter(getter(EntityRecognizerMetadata::evaluationMetrics)).setter(setter(Builder::evaluationMetrics))
            .constructor(EntityRecognizerEvaluationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build()).build();

    private static final SdkField<List<EntityRecognizerMetadataEntityTypesListItem>> ENTITY_TYPES_FIELD = SdkField
            .<List<EntityRecognizerMetadataEntityTypesListItem>> builder(MarshallingType.LIST)
            .getter(getter(EntityRecognizerMetadata::entityTypes))
            .setter(setter(Builder::entityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityRecognizerMetadataEntityTypesListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityRecognizerMetadataEntityTypesListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_TRAINED_DOCUMENTS_FIELD, NUMBER_OF_TEST_DOCUMENTS_FIELD, EVALUATION_METRICS_FIELD, ENTITY_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer numberOfTrainedDocuments;

    private final Integer numberOfTestDocuments;

    private final EntityRecognizerEvaluationMetrics evaluationMetrics;

    private final List<EntityRecognizerMetadataEntityTypesListItem> entityTypes;

    private EntityRecognizerMetadata(BuilderImpl builder) {
        this.numberOfTrainedDocuments = builder.numberOfTrainedDocuments;
        this.numberOfTestDocuments = builder.numberOfTestDocuments;
        this.evaluationMetrics = builder.evaluationMetrics;
        this.entityTypes = builder.entityTypes;
    }

    /**
     * <p>
     * The number of documents in the input data that were used to train the entity recognizer. Typically this is 80 to
     * 90 percent of the input documents.
     * </p>
     * 
     * @return The number of documents in the input data that were used to train the entity recognizer. Typically this
     *         is 80 to 90 percent of the input documents.
     */
    public Integer numberOfTrainedDocuments() {
        return numberOfTrainedDocuments;
    }

    /**
     * <p>
     * The number of documents in the input data that were used to test the entity recognizer. Typically this is 10 to
     * 20 percent of the input documents.
     * </p>
     * 
     * @return The number of documents in the input data that were used to test the entity recognizer. Typically this is
     *         10 to 20 percent of the input documents.
     */
    public Integer numberOfTestDocuments() {
        return numberOfTestDocuments;
    }

    /**
     * <p>
     * Detailed information about the accuracy of an entity recognizer.
     * </p>
     * 
     * @return Detailed information about the accuracy of an entity recognizer.
     */
    public EntityRecognizerEvaluationMetrics evaluationMetrics() {
        return evaluationMetrics;
    }

    /**
     * Returns true if the EntityTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntityTypes() {
        return entityTypes != null && !(entityTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Entity types from the metadata of an entity recognizer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntityTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Entity types from the metadata of an entity recognizer.
     */
    public List<EntityRecognizerMetadataEntityTypesListItem> entityTypes() {
        return entityTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTrainedDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTestDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerMetadata)) {
            return false;
        }
        EntityRecognizerMetadata other = (EntityRecognizerMetadata) obj;
        return Objects.equals(numberOfTrainedDocuments(), other.numberOfTrainedDocuments())
                && Objects.equals(numberOfTestDocuments(), other.numberOfTestDocuments())
                && Objects.equals(evaluationMetrics(), other.evaluationMetrics())
                && Objects.equals(entityTypes(), other.entityTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EntityRecognizerMetadata").add("NumberOfTrainedDocuments", numberOfTrainedDocuments())
                .add("NumberOfTestDocuments", numberOfTestDocuments()).add("EvaluationMetrics", evaluationMetrics())
                .add("EntityTypes", entityTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfTrainedDocuments":
            return Optional.ofNullable(clazz.cast(numberOfTrainedDocuments()));
        case "NumberOfTestDocuments":
            return Optional.ofNullable(clazz.cast(numberOfTestDocuments()));
        case "EvaluationMetrics":
            return Optional.ofNullable(clazz.cast(evaluationMetrics()));
        case "EntityTypes":
            return Optional.ofNullable(clazz.cast(entityTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerMetadata, T> g) {
        return obj -> g.apply((EntityRecognizerMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityRecognizerMetadata> {
        /**
         * <p>
         * The number of documents in the input data that were used to train the entity recognizer. Typically this is 80
         * to 90 percent of the input documents.
         * </p>
         * 
         * @param numberOfTrainedDocuments
         *        The number of documents in the input data that were used to train the entity recognizer. Typically
         *        this is 80 to 90 percent of the input documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTrainedDocuments(Integer numberOfTrainedDocuments);

        /**
         * <p>
         * The number of documents in the input data that were used to test the entity recognizer. Typically this is 10
         * to 20 percent of the input documents.
         * </p>
         * 
         * @param numberOfTestDocuments
         *        The number of documents in the input data that were used to test the entity recognizer. Typically this
         *        is 10 to 20 percent of the input documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTestDocuments(Integer numberOfTestDocuments);

        /**
         * <p>
         * Detailed information about the accuracy of an entity recognizer.
         * </p>
         * 
         * @param evaluationMetrics
         *        Detailed information about the accuracy of an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationMetrics(EntityRecognizerEvaluationMetrics evaluationMetrics);

        /**
         * <p>
         * Detailed information about the accuracy of an entity recognizer.
         * </p>
         * This is a convenience that creates an instance of the {@link EntityRecognizerEvaluationMetrics.Builder}
         * avoiding the need to create one manually via {@link EntityRecognizerEvaluationMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityRecognizerEvaluationMetrics.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluationMetrics(EntityRecognizerEvaluationMetrics)}.
         * 
         * @param evaluationMetrics
         *        a consumer that will call methods on {@link EntityRecognizerEvaluationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationMetrics(EntityRecognizerEvaluationMetrics)
         */
        default Builder evaluationMetrics(Consumer<EntityRecognizerEvaluationMetrics.Builder> evaluationMetrics) {
            return evaluationMetrics(EntityRecognizerEvaluationMetrics.builder().applyMutation(evaluationMetrics).build());
        }

        /**
         * <p>
         * Entity types from the metadata of an entity recognizer.
         * </p>
         * 
         * @param entityTypes
         *        Entity types from the metadata of an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(Collection<EntityRecognizerMetadataEntityTypesListItem> entityTypes);

        /**
         * <p>
         * Entity types from the metadata of an entity recognizer.
         * </p>
         * 
         * @param entityTypes
         *        Entity types from the metadata of an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(EntityRecognizerMetadataEntityTypesListItem... entityTypes);

        /**
         * <p>
         * Entity types from the metadata of an entity recognizer.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <EntityRecognizerMetadataEntityTypesListItem>.Builder} avoiding the need to create one manually via
         * {@link List<EntityRecognizerMetadataEntityTypesListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <EntityRecognizerMetadataEntityTypesListItem>.Builder#build()} is called immediately and its result is passed
         * to {@link #entityTypes(List<EntityRecognizerMetadataEntityTypesListItem>)}.
         * 
         * @param entityTypes
         *        a consumer that will call methods on {@link List<EntityRecognizerMetadataEntityTypesListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityTypes(List<EntityRecognizerMetadataEntityTypesListItem>)
         */
        Builder entityTypes(Consumer<EntityRecognizerMetadataEntityTypesListItem.Builder>... entityTypes);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfTrainedDocuments;

        private Integer numberOfTestDocuments;

        private EntityRecognizerEvaluationMetrics evaluationMetrics;

        private List<EntityRecognizerMetadataEntityTypesListItem> entityTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerMetadata model) {
            numberOfTrainedDocuments(model.numberOfTrainedDocuments);
            numberOfTestDocuments(model.numberOfTestDocuments);
            evaluationMetrics(model.evaluationMetrics);
            entityTypes(model.entityTypes);
        }

        public final Integer getNumberOfTrainedDocuments() {
            return numberOfTrainedDocuments;
        }

        @Override
        public final Builder numberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
            this.numberOfTrainedDocuments = numberOfTrainedDocuments;
            return this;
        }

        public final void setNumberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
            this.numberOfTrainedDocuments = numberOfTrainedDocuments;
        }

        public final Integer getNumberOfTestDocuments() {
            return numberOfTestDocuments;
        }

        @Override
        public final Builder numberOfTestDocuments(Integer numberOfTestDocuments) {
            this.numberOfTestDocuments = numberOfTestDocuments;
            return this;
        }

        public final void setNumberOfTestDocuments(Integer numberOfTestDocuments) {
            this.numberOfTestDocuments = numberOfTestDocuments;
        }

        public final EntityRecognizerEvaluationMetrics.Builder getEvaluationMetrics() {
            return evaluationMetrics != null ? evaluationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder evaluationMetrics(EntityRecognizerEvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public final void setEvaluationMetrics(EntityRecognizerEvaluationMetrics.BuilderImpl evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics != null ? evaluationMetrics.build() : null;
        }

        public final Collection<EntityRecognizerMetadataEntityTypesListItem.Builder> getEntityTypes() {
            return entityTypes != null ? entityTypes.stream().map(EntityRecognizerMetadataEntityTypesListItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entityTypes(Collection<EntityRecognizerMetadataEntityTypesListItem> entityTypes) {
            this.entityTypes = EntityRecognizerMetadataEntityTypesListCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityRecognizerMetadataEntityTypesListItem... entityTypes) {
            entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(Consumer<EntityRecognizerMetadataEntityTypesListItem.Builder>... entityTypes) {
            entityTypes(Stream.of(entityTypes)
                    .map(c -> EntityRecognizerMetadataEntityTypesListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntityTypes(Collection<EntityRecognizerMetadataEntityTypesListItem.BuilderImpl> entityTypes) {
            this.entityTypes = EntityRecognizerMetadataEntityTypesListCopier.copyFromBuilder(entityTypes);
        }

        @Override
        public EntityRecognizerMetadata build() {
            return new EntityRecognizerMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
