/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetectSentimentRequest extends ComprehendRequest implements
        ToCopyableBuilder<BatchDetectSentimentRequest.Builder, BatchDetectSentimentRequest> {
    private static final SdkField<List<String>> TEXT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchDetectSentimentRequest::textList))
            .setter(setter(Builder::textList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDetectSentimentRequest::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_LIST_FIELD,
            LANGUAGE_CODE_FIELD));

    private final List<String> textList;

    private final String languageCode;

    private BatchDetectSentimentRequest(BuilderImpl builder) {
        super(builder);
        this.textList = builder.textList;
        this.languageCode = builder.languageCode;
    }

    /**
     * Returns true if the TextList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTextList() {
        return textList != null && !(textList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document
     * must contain fewer that 5,000 bytes of UTF-8 encoded characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTextList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each
     *         document must contain fewer that 5,000 bytes of UTF-8 encoded characters.
     */
    public List<String> textList() {
        return textList;
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the primary languages supported by Amazon
     *         Comprehend. All documents must be in the same language.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the primary languages supported by Amazon
     *         Comprehend. All documents must be in the same language.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(textList());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSentimentRequest)) {
            return false;
        }
        BatchDetectSentimentRequest other = (BatchDetectSentimentRequest) obj;
        return Objects.equals(textList(), other.textList())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDetectSentimentRequest").add("TextList", textList())
                .add("LanguageCode", languageCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextList":
            return Optional.ofNullable(clazz.cast(textList()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectSentimentRequest, T> g) {
        return obj -> g.apply((BatchDetectSentimentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDetectSentimentRequest> {
        /**
         * <p>
         * A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each
         * document must contain fewer that 5,000 bytes of UTF-8 encoded characters.
         * </p>
         * 
         * @param textList
         *        A list containing the text of the input documents. The list can contain a maximum of 25 documents.
         *        Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textList(Collection<String> textList);

        /**
         * <p>
         * A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each
         * document must contain fewer that 5,000 bytes of UTF-8 encoded characters.
         * </p>
         * 
         * @param textList
         *        A list containing the text of the input documents. The list can contain a maximum of 25 documents.
         *        Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textList(String... textList);

        /**
         * <p>
         * The language of the input documents. You can specify any of the primary languages supported by Amazon
         * Comprehend. All documents must be in the same language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the primary languages supported by Amazon
         *        Comprehend. All documents must be in the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language of the input documents. You can specify any of the primary languages supported by Amazon
         * Comprehend. All documents must be in the same language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the primary languages supported by Amazon
         *        Comprehend. All documents must be in the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private List<String> textList = DefaultSdkAutoConstructList.getInstance();

        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSentimentRequest model) {
            super(model);
            textList(model.textList);
            languageCode(model.languageCode);
        }

        public final Collection<String> getTextList() {
            return textList;
        }

        @Override
        public final Builder textList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textList(String... textList) {
            textList(Arrays.asList(textList));
            return this;
        }

        public final void setTextList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
        }

        public final String getLanguageCodeAsString() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDetectSentimentRequest build() {
            return new BatchDetectSentimentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
