/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetectEntitiesResponse extends ComprehendResponse implements
        ToCopyableBuilder<BatchDetectEntitiesResponse.Builder, BatchDetectEntitiesResponse> {
    private static final SdkField<List<BatchDetectEntitiesItemResult>> RESULT_LIST_FIELD = SdkField
            .<List<BatchDetectEntitiesItemResult>> builder(MarshallingType.LIST)
            .getter(getter(BatchDetectEntitiesResponse::resultList))
            .setter(setter(Builder::resultList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDetectEntitiesItemResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDetectEntitiesItemResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchItemError>> ERROR_LIST_FIELD = SdkField
            .<List<BatchItemError>> builder(MarshallingType.LIST)
            .getter(getter(BatchDetectEntitiesResponse::errorList))
            .setter(setter(Builder::errorList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchItemError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchItemError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_LIST_FIELD,
            ERROR_LIST_FIELD));

    private final List<BatchDetectEntitiesItemResult> resultList;

    private final List<BatchItemError> errorList;

    private BatchDetectEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
        this.errorList = builder.errorList;
    }

    /**
     * Returns true if the ResultList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResultList() {
        return resultList != null && !(resultList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing the results of the operation. The results are sorted in ascending order by the
     * <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain
     * an error, the <code>ResultList</code> is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResultList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of objects containing the results of the operation. The results are sorted in ascending order by
     *         the <code>Index</code> field and match the order of the documents in the input list. If all of the
     *         documents contain an error, the <code>ResultList</code> is empty.
     */
    public List<BatchDetectEntitiesItemResult> resultList() {
        return resultList;
    }

    /**
     * Returns true if the ErrorList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasErrorList() {
        return errorList != null && !(errorList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing one object for each document that contained an error. The results are sorted in ascending order
     * by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in
     * the batch, the <code>ErrorList</code> is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrorList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list containing one object for each document that contained an error. The results are sorted in
     *         ascending order by the <code>Index</code> field and match the order of the documents in the input list.
     *         If there are no errors in the batch, the <code>ErrorList</code> is empty.
     */
    public List<BatchItemError> errorList() {
        return errorList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resultList());
        hashCode = 31 * hashCode + Objects.hashCode(errorList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectEntitiesResponse)) {
            return false;
        }
        BatchDetectEntitiesResponse other = (BatchDetectEntitiesResponse) obj;
        return Objects.equals(resultList(), other.resultList()) && Objects.equals(errorList(), other.errorList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDetectEntitiesResponse").add("ResultList", resultList()).add("ErrorList", errorList())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultList":
            return Optional.ofNullable(clazz.cast(resultList()));
        case "ErrorList":
            return Optional.ofNullable(clazz.cast(errorList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectEntitiesResponse, T> g) {
        return obj -> g.apply((BatchDetectEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDetectEntitiesResponse> {
        /**
         * <p>
         * A list of objects containing the results of the operation. The results are sorted in ascending order by the
         * <code>Index</code> field and match the order of the documents in the input list. If all of the documents
         * contain an error, the <code>ResultList</code> is empty.
         * </p>
         * 
         * @param resultList
         *        A list of objects containing the results of the operation. The results are sorted in ascending order
         *        by the <code>Index</code> field and match the order of the documents in the input list. If all of the
         *        documents contain an error, the <code>ResultList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultList(Collection<BatchDetectEntitiesItemResult> resultList);

        /**
         * <p>
         * A list of objects containing the results of the operation. The results are sorted in ascending order by the
         * <code>Index</code> field and match the order of the documents in the input list. If all of the documents
         * contain an error, the <code>ResultList</code> is empty.
         * </p>
         * 
         * @param resultList
         *        A list of objects containing the results of the operation. The results are sorted in ascending order
         *        by the <code>Index</code> field and match the order of the documents in the input list. If all of the
         *        documents contain an error, the <code>ResultList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultList(BatchDetectEntitiesItemResult... resultList);

        /**
         * <p>
         * A list of objects containing the results of the operation. The results are sorted in ascending order by the
         * <code>Index</code> field and match the order of the documents in the input list. If all of the documents
         * contain an error, the <code>ResultList</code> is empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchDetectEntitiesItemResult>.Builder}
         * avoiding the need to create one manually via {@link List<BatchDetectEntitiesItemResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchDetectEntitiesItemResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #resultList(List<BatchDetectEntitiesItemResult>)}.
         * 
         * @param resultList
         *        a consumer that will call methods on {@link List<BatchDetectEntitiesItemResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultList(List<BatchDetectEntitiesItemResult>)
         */
        Builder resultList(Consumer<BatchDetectEntitiesItemResult.Builder>... resultList);

        /**
         * <p>
         * A list containing one object for each document that contained an error. The results are sorted in ascending
         * order by the <code>Index</code> field and match the order of the documents in the input list. If there are no
         * errors in the batch, the <code>ErrorList</code> is empty.
         * </p>
         * 
         * @param errorList
         *        A list containing one object for each document that contained an error. The results are sorted in
         *        ascending order by the <code>Index</code> field and match the order of the documents in the input
         *        list. If there are no errors in the batch, the <code>ErrorList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorList(Collection<BatchItemError> errorList);

        /**
         * <p>
         * A list containing one object for each document that contained an error. The results are sorted in ascending
         * order by the <code>Index</code> field and match the order of the documents in the input list. If there are no
         * errors in the batch, the <code>ErrorList</code> is empty.
         * </p>
         * 
         * @param errorList
         *        A list containing one object for each document that contained an error. The results are sorted in
         *        ascending order by the <code>Index</code> field and match the order of the documents in the input
         *        list. If there are no errors in the batch, the <code>ErrorList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorList(BatchItemError... errorList);

        /**
         * <p>
         * A list containing one object for each document that contained an error. The results are sorted in ascending
         * order by the <code>Index</code> field and match the order of the documents in the input list. If there are no
         * errors in the batch, the <code>ErrorList</code> is empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchItemError>.Builder} avoiding the need
         * to create one manually via {@link List<BatchItemError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchItemError>.Builder#build()} is called immediately and
         * its result is passed to {@link #errorList(List<BatchItemError>)}.
         * 
         * @param errorList
         *        a consumer that will call methods on {@link List<BatchItemError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorList(List<BatchItemError>)
         */
        Builder errorList(Consumer<BatchItemError.Builder>... errorList);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<BatchDetectEntitiesItemResult> resultList = DefaultSdkAutoConstructList.getInstance();

        private List<BatchItemError> errorList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectEntitiesResponse model) {
            super(model);
            resultList(model.resultList);
            errorList(model.errorList);
        }

        public final Collection<BatchDetectEntitiesItemResult.Builder> getResultList() {
            return resultList != null ? resultList.stream().map(BatchDetectEntitiesItemResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultList(Collection<BatchDetectEntitiesItemResult> resultList) {
            this.resultList = ListOfDetectEntitiesResultCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(BatchDetectEntitiesItemResult... resultList) {
            resultList(Arrays.asList(resultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(Consumer<BatchDetectEntitiesItemResult.Builder>... resultList) {
            resultList(Stream.of(resultList).map(c -> BatchDetectEntitiesItemResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResultList(Collection<BatchDetectEntitiesItemResult.BuilderImpl> resultList) {
            this.resultList = ListOfDetectEntitiesResultCopier.copyFromBuilder(resultList);
        }

        public final Collection<BatchItemError.Builder> getErrorList() {
            return errorList != null ? errorList.stream().map(BatchItemError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorList(Collection<BatchItemError> errorList) {
            this.errorList = BatchItemErrorListCopier.copy(errorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(BatchItemError... errorList) {
            errorList(Arrays.asList(errorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(Consumer<BatchItemError.Builder>... errorList) {
            errorList(Stream.of(errorList).map(c -> BatchItemError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrorList(Collection<BatchItemError.BuilderImpl> errorList) {
            this.errorList = BatchItemErrorListCopier.copyFromBuilder(errorList);
        }

        @Override
        public BatchDetectEntitiesResponse build() {
            return new BatchDetectEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
