/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.SentimentScore;
import software.amazon.awssdk.services.comprehend.model.SentimentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectSentimentResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectSentimentResponse> {
    private final String sentiment;
    private final SentimentScore sentimentScore;

    private DetectSentimentResponse(BuilderImpl builder) {
        super(builder);
        this.sentiment = builder.sentiment;
        this.sentimentScore = builder.sentimentScore;
    }

    public SentimentType sentiment() {
        return SentimentType.fromValue(this.sentiment);
    }

    public String sentimentString() {
        return this.sentiment;
    }

    public SentimentScore sentimentScore() {
        return this.sentimentScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentScore());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectSentimentResponse)) {
            return false;
        }
        DetectSentimentResponse other = (DetectSentimentResponse)((Object)obj);
        return Objects.equals(this.sentimentString(), other.sentimentString()) && Objects.equals(this.sentimentScore(), other.sentimentScore());
    }

    public String toString() {
        return ToString.builder((String)"DetectSentimentResponse").add("Sentiment", (Object)this.sentimentString()).add("SentimentScore", (Object)this.sentimentScore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sentiment": {
                return Optional.of(clazz.cast(this.sentimentString()));
            }
            case "SentimentScore": {
                return Optional.of(clazz.cast(this.sentimentScore()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private String sentiment;
        private SentimentScore sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectSentimentResponse model) {
            this.sentiment(model.sentiment);
            this.sentimentScore(model.sentimentScore);
        }

        public final String getSentiment() {
            return this.sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentType sentiment) {
            this.sentiment(sentiment.toString());
            return this;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        public final SentimentScore.Builder getSentimentScore() {
            return this.sentimentScore != null ? this.sentimentScore.toBuilder() : null;
        }

        @Override
        public final Builder sentimentScore(SentimentScore sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        public final void setSentimentScore(SentimentScore.BuilderImpl sentimentScore) {
            this.sentimentScore = sentimentScore != null ? sentimentScore.build() : null;
        }

        @Override
        public DetectSentimentResponse build() {
            return new DetectSentimentResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, DetectSentimentResponse> {
        public Builder sentiment(String var1);

        public Builder sentiment(SentimentType var1);

        public Builder sentimentScore(SentimentScore var1);

        default public Builder sentimentScore(Consumer<SentimentScore.Builder> sentimentScore) {
            return this.sentimentScore((SentimentScore)((SentimentScore.Builder)SentimentScore.builder().apply(sentimentScore)).build());
        }
    }
}

