/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobResponseUnmarshaller;

@SdkInternalApi
final class DefaultComprehendClient
implements ComprehendClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultComprehendClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "comprehend";
    }

    @Override
    public BatchDetectDominantLanguageResponse batchDetectDominantLanguage(BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) throws InvalidRequestException, TextSizeLimitExceededException, BatchSizeLimitExceededException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectDominantLanguageResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (BatchDetectDominantLanguageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectDominantLanguageRequest).withMarshaller((Marshaller)new BatchDetectDominantLanguageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public BatchDetectEntitiesResponse batchDetectEntities(BatchDetectEntitiesRequest batchDetectEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectEntitiesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (BatchDetectEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectEntitiesRequest).withMarshaller((Marshaller)new BatchDetectEntitiesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public BatchDetectKeyPhrasesResponse batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectKeyPhrasesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (BatchDetectKeyPhrasesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectKeyPhrasesRequest).withMarshaller((Marshaller)new BatchDetectKeyPhrasesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public BatchDetectSentimentResponse batchDetectSentiment(BatchDetectSentimentRequest batchDetectSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectSentimentResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (BatchDetectSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectSentimentRequest).withMarshaller((Marshaller)new BatchDetectSentimentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTopicsDetectionJobResponse describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTopicsDetectionJobResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeTopicsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTopicsDetectionJobRequest).withMarshaller((Marshaller)new DescribeTopicsDetectionJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectDominantLanguageResponse detectDominantLanguage(DetectDominantLanguageRequest detectDominantLanguageRequest) throws InvalidRequestException, TextSizeLimitExceededException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectDominantLanguageResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DetectDominantLanguageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectDominantLanguageRequest).withMarshaller((Marshaller)new DetectDominantLanguageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectEntitiesResponse detectEntities(DetectEntitiesRequest detectEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectEntitiesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DetectEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectEntitiesRequest).withMarshaller((Marshaller)new DetectEntitiesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectKeyPhrasesResponse detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectKeyPhrasesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DetectKeyPhrasesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectKeyPhrasesRequest).withMarshaller((Marshaller)new DetectKeyPhrasesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectSentimentResponse detectSentiment(DetectSentimentRequest detectSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectSentimentResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DetectSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectSentimentRequest).withMarshaller((Marshaller)new DetectSentimentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTopicsDetectionJobsResponse listTopicsDetectionJobs(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTopicsDetectionJobsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTopicsDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTopicsDetectionJobsRequest).withMarshaller((Marshaller)new ListTopicsDetectionJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTopicsDetectionJobsIterable listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        return new ListTopicsDetectionJobsIterable(this, listTopicsDetectionJobsRequest);
    }

    @Override
    public StartTopicsDetectionJobResponse startTopicsDetectionJob(StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, InternalServerException, SdkServiceException, SdkClientException, ComprehendException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTopicsDetectionJobResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (StartTopicsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startTopicsDetectionJobRequest).withMarshaller((Marshaller)new StartTopicsDetectionJobRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(ComprehendException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidFilterException").withModeledClass(InvalidFilterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BatchSizeLimitExceededException").withModeledClass(BatchSizeLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("JobNotFoundException").withModeledClass(JobNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextSizeLimitExceededException").withModeledClass(TextSizeLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedLanguageException").withModeledClass(UnsupportedLanguageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

