/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;

@SdkInternalApi
public class BatchDetectEntitiesRequestModelMarshaller {
    private static final MarshallingInfo<List> TEXTLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextList").build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").build();
    private static final BatchDetectEntitiesRequestModelMarshaller INSTANCE = new BatchDetectEntitiesRequestModelMarshaller();

    public static BatchDetectEntitiesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchDetectEntitiesRequest batchDetectEntitiesRequest, ProtocolMarshaller protocolMarshaller) {
        if (batchDetectEntitiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(batchDetectEntitiesRequest.textList(), TEXTLIST_BINDING);
            protocolMarshaller.marshall((Object)batchDetectEntitiesRequest.languageCode(), LANGUAGECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

