/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.SyntaxToken;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SyntaxTokenMarshaller {
    private static final MarshallingInfo<Integer> TOKENID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenId").isBinary(false).build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").isBinary(false).build();
    private static final MarshallingInfo<Integer> BEGINOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BeginOffset").isBinary(false).build();
    private static final MarshallingInfo<Integer> ENDOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndOffset").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PARTOFSPEECH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartOfSpeech").isBinary(false).build();
    private static final SyntaxTokenMarshaller INSTANCE = new SyntaxTokenMarshaller();

    private SyntaxTokenMarshaller() {
    }

    public static SyntaxTokenMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SyntaxToken syntaxToken, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)syntaxToken, (String)"syntaxToken");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)syntaxToken.tokenId(), TOKENID_BINDING);
            protocolMarshaller.marshall((Object)syntaxToken.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)syntaxToken.beginOffset(), BEGINOFFSET_BINDING);
            protocolMarshaller.marshall((Object)syntaxToken.endOffset(), ENDOFFSET_BINDING);
            protocolMarshaller.marshall((Object)syntaxToken.partOfSpeech(), PARTOFSPEECH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

