/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.ListOfSyntaxTokensCopier;
import software.amazon.awssdk.services.comprehend.model.SyntaxToken;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectSyntaxResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectSyntaxResponse> {
    private final List<SyntaxToken> syntaxTokens;

    private DetectSyntaxResponse(BuilderImpl builder) {
        super(builder);
        this.syntaxTokens = builder.syntaxTokens;
    }

    public List<SyntaxToken> syntaxTokens() {
        return this.syntaxTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.syntaxTokens());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectSyntaxResponse)) {
            return false;
        }
        DetectSyntaxResponse other = (DetectSyntaxResponse)((Object)obj);
        return Objects.equals(this.syntaxTokens(), other.syntaxTokens());
    }

    public String toString() {
        return ToString.builder((String)"DetectSyntaxResponse").add("SyntaxTokens", this.syntaxTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SyntaxTokens": {
                return Optional.ofNullable(clazz.cast(this.syntaxTokens()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<SyntaxToken> syntaxTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectSyntaxResponse model) {
            super(model);
            this.syntaxTokens(model.syntaxTokens);
        }

        public final Collection<SyntaxToken.Builder> getSyntaxTokens() {
            return this.syntaxTokens != null ? (Collection)this.syntaxTokens.stream().map(SyntaxToken::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder syntaxTokens(Collection<SyntaxToken> syntaxTokens) {
            this.syntaxTokens = ListOfSyntaxTokensCopier.copy(syntaxTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syntaxTokens(SyntaxToken ... syntaxTokens) {
            this.syntaxTokens(Arrays.asList(syntaxTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syntaxTokens(Consumer<SyntaxToken.Builder> ... syntaxTokens) {
            this.syntaxTokens(Stream.of(syntaxTokens).map(c -> (SyntaxToken)((SyntaxToken.Builder)SyntaxToken.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSyntaxTokens(Collection<SyntaxToken.BuilderImpl> syntaxTokens) {
            this.syntaxTokens = ListOfSyntaxTokensCopier.copyFromBuilder(syntaxTokens);
        }

        @Override
        public DetectSyntaxResponse build() {
            return new DetectSyntaxResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, DetectSyntaxResponse> {
        public Builder syntaxTokens(Collection<SyntaxToken> var1);

        public Builder syntaxTokens(SyntaxToken ... var1);

        public Builder syntaxTokens(Consumer<SyntaxToken.Builder> ... var1);
    }
}

