/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsResponseUnmarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultComprehendAsyncClient
implements ComprehendAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultComprehendAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "comprehend";
    }

    @Override
    public CompletableFuture<BatchDetectDominantLanguageResponse> batchDetectDominantLanguage(BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectDominantLanguageResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new BatchDetectDominantLanguageRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectDominantLanguageRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDetectEntitiesResponse> batchDetectEntities(BatchDetectEntitiesRequest batchDetectEntitiesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectEntitiesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new BatchDetectEntitiesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectEntitiesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDetectKeyPhrasesResponse> batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectKeyPhrasesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new BatchDetectKeyPhrasesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectKeyPhrasesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDetectSentimentResponse> batchDetectSentiment(BatchDetectSentimentRequest batchDetectSentimentRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDetectSentimentResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new BatchDetectSentimentRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectSentimentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTopicsDetectionJobResponse> describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTopicsDetectionJobResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeTopicsDetectionJobRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTopicsDetectionJobRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectDominantLanguageResponse> detectDominantLanguage(DetectDominantLanguageRequest detectDominantLanguageRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectDominantLanguageResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DetectDominantLanguageRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectDominantLanguageRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectEntitiesResponse> detectEntities(DetectEntitiesRequest detectEntitiesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectEntitiesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DetectEntitiesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectEntitiesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectKeyPhrasesResponse> detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectKeyPhrasesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DetectKeyPhrasesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectKeyPhrasesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectSentimentResponse> detectSentiment(DetectSentimentRequest detectSentimentRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectSentimentResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DetectSentimentRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectSentimentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTopicsDetectionJobsResponse> listTopicsDetectionJobs(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTopicsDetectionJobsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListTopicsDetectionJobsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTopicsDetectionJobsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTopicsDetectionJobsPublisher listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) {
        return new ListTopicsDetectionJobsPublisher(this, this.applyPaginatorUserAgent(listTopicsDetectionJobsRequest));
    }

    @Override
    public CompletableFuture<StartTopicsDetectionJobResponse> startTopicsDetectionJob(StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTopicsDetectionJobResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StartTopicsDetectionJobRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startTopicsDetectionJobRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(ComprehendException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidFilterException").withModeledClass(InvalidFilterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BatchSizeLimitExceededException").withModeledClass(BatchSizeLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("JobNotFoundException").withModeledClass(JobNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextSizeLimitExceededException").withModeledClass(TextSizeLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedLanguageException").withModeledClass(UnsupportedLanguageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private <T extends ComprehendRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-11").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ComprehendRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

