/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.Entity;
import software.amazon.awssdk.services.comprehend.model.ListOfEntitiesCopier;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesItemResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDetectEntitiesItemResult
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchDetectEntitiesItemResult> {
    private final Integer index;
    private final List<Entity> entities;

    private BatchDetectEntitiesItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.entities = builder.entities;
    }

    public Integer index() {
        return this.index;
    }

    public List<Entity> entities() {
        return this.entities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.entities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectEntitiesItemResult)) {
            return false;
        }
        BatchDetectEntitiesItemResult other = (BatchDetectEntitiesItemResult)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.entities(), other.entities());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectEntitiesItemResult").add("Index", (Object)this.index()).add("Entities", this.entities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.of(clazz.cast(this.index()));
            }
            case "Entities": {
                return Optional.of(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchDetectEntitiesItemResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private List<Entity> entities;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectEntitiesItemResult model) {
            this.index(model.index);
            this.entities(model.entities);
        }

        public final Integer getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public final Collection<Entity.Builder> getEntities() {
            return this.entities != null ? (Collection)this.entities.stream().map(Entity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = ListOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (Entity)((Entity.Builder)Entity.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = ListOfEntitiesCopier.copyFromBuilder(entities);
        }

        public BatchDetectEntitiesItemResult build() {
            return new BatchDetectEntitiesItemResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchDetectEntitiesItemResult> {
        public Builder index(Integer var1);

        public Builder entities(Collection<Entity> var1);

        public Builder entities(Entity ... var1);

        public Builder entities(Consumer<Entity.Builder> ... var1);
    }
}

