/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cognitosync.CognitoSyncClient;
import software.amazon.awssdk.services.cognitosync.CognitoSyncServiceClientConfiguration;
import software.amazon.awssdk.services.cognitosync.internal.CognitoSyncServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cognitosync.model.AlreadyStreamedException;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncException;
import software.amazon.awssdk.services.cognitosync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.DuplicateRequestException;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.InternalErrorException;
import software.amazon.awssdk.services.cognitosync.model.InvalidConfigurationException;
import software.amazon.awssdk.services.cognitosync.model.InvalidLambdaFunctionOutputException;
import software.amazon.awssdk.services.cognitosync.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitosync.model.LambdaThrottledException;
import software.amazon.awssdk.services.cognitosync.model.LimitExceededException;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse;
import software.amazon.awssdk.services.cognitosync.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse;
import software.amazon.awssdk.services.cognitosync.model.ResourceConflictException;
import software.amazon.awssdk.services.cognitosync.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse;
import software.amazon.awssdk.services.cognitosync.transform.BulkPublishRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetBulkPublishDetailsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetCognitoEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetIdentityPoolConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListIdentityPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListRecordsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.RegisterDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetCognitoEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetIdentityPoolConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SubscribeToDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UnsubscribeFromDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UpdateRecordsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCognitoSyncClient
implements CognitoSyncClient {
    private static final Logger log = Logger.loggerFor(DefaultCognitoSyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoSyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkPublishResponse bulkPublish(BulkPublishRequest bulkPublishRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, DuplicateRequestException, AlreadyStreamedException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BulkPublishResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)bulkPublishRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, bulkPublishRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BulkPublish");
            BulkPublishResponse bulkPublishResponse = (BulkPublishResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BulkPublish").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)bulkPublishRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BulkPublishRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return bulkPublishResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$bulkPublish$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, ResourceConflictException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, deleteDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataset");
            DeleteDatasetResponse deleteDatasetResponse = (DeleteDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$deleteDataset$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, describeDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataset");
            DescribeDatasetResponse describeDatasetResponse = (DescribeDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$describeDataset$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityPoolUsageResponse describeIdentityPoolUsage(DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityPoolUsageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIdentityPoolUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, describeIdentityPoolUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentityPoolUsage");
            DescribeIdentityPoolUsageResponse describeIdentityPoolUsageResponse = (DescribeIdentityPoolUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityPoolUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeIdentityPoolUsageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIdentityPoolUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIdentityPoolUsageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$describeIdentityPoolUsage$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityUsageResponse describeIdentityUsage(DescribeIdentityUsageRequest describeIdentityUsageRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityUsageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIdentityUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, describeIdentityUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentityUsage");
            DescribeIdentityUsageResponse describeIdentityUsageResponse = (DescribeIdentityUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeIdentityUsageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIdentityUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIdentityUsageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$describeIdentityUsage$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBulkPublishDetailsResponse getBulkPublishDetails(GetBulkPublishDetailsRequest getBulkPublishDetailsRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBulkPublishDetailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBulkPublishDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, getBulkPublishDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBulkPublishDetails");
            GetBulkPublishDetailsResponse getBulkPublishDetailsResponse = (GetBulkPublishDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBulkPublishDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBulkPublishDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBulkPublishDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBulkPublishDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$getBulkPublishDetails$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCognitoEventsResponse getCognitoEvents(GetCognitoEventsRequest getCognitoEventsRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCognitoEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCognitoEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, getCognitoEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCognitoEvents");
            GetCognitoEventsResponse getCognitoEventsResponse = (GetCognitoEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCognitoEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCognitoEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCognitoEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCognitoEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$getCognitoEvents$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityPoolConfigurationResponse getIdentityPoolConfiguration(GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdentityPoolConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIdentityPoolConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, getIdentityPoolConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityPoolConfiguration");
            GetIdentityPoolConfigurationResponse getIdentityPoolConfigurationResponse = (GetIdentityPoolConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityPoolConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getIdentityPoolConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentityPoolConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIdentityPoolConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$getIdentityPoolConfiguration$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws NotAuthorizedException, InvalidParameterException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatasetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, listDatasetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasets");
            ListDatasetsResponse listDatasetsResponse = (ListDatasetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDatasetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$listDatasets$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityPoolUsageResponse listIdentityPoolUsage(ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) throws NotAuthorizedException, InvalidParameterException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentityPoolUsageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIdentityPoolUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, listIdentityPoolUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityPoolUsage");
            ListIdentityPoolUsageResponse listIdentityPoolUsageResponse = (ListIdentityPoolUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityPoolUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listIdentityPoolUsageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentityPoolUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIdentityPoolUsageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$listIdentityPoolUsage$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecordsResponse listRecords(ListRecordsRequest listRecordsRequest) throws InvalidParameterException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecordsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, listRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecords");
            ListRecordsResponse listRecordsResponse = (ListRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$listRecords$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterDeviceResponse registerDevice(RegisterDeviceRequest registerDeviceRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, InvalidConfigurationException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, registerDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterDevice");
            RegisterDeviceResponse registerDeviceResponse = (RegisterDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$registerDevice$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetCognitoEventsResponse setCognitoEvents(SetCognitoEventsRequest setCognitoEventsRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetCognitoEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setCognitoEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, setCognitoEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetCognitoEvents");
            SetCognitoEventsResponse setCognitoEventsResponse = (SetCognitoEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetCognitoEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setCognitoEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetCognitoEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setCognitoEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$setCognitoEvents$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityPoolConfigurationResponse setIdentityPoolConfiguration(SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetIdentityPoolConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setIdentityPoolConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, setIdentityPoolConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityPoolConfiguration");
            SetIdentityPoolConfigurationResponse setIdentityPoolConfigurationResponse = (SetIdentityPoolConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityPoolConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setIdentityPoolConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIdentityPoolConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setIdentityPoolConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$setIdentityPoolConfiguration$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscribeToDatasetResponse subscribeToDataset(SubscribeToDatasetRequest subscribeToDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, InvalidConfigurationException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubscribeToDatasetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)subscribeToDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, subscribeToDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubscribeToDataset");
            SubscribeToDatasetResponse subscribeToDatasetResponse = (SubscribeToDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubscribeToDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)subscribeToDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SubscribeToDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return subscribeToDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$subscribeToDataset$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnsubscribeFromDatasetResponse unsubscribeFromDataset(UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, InvalidConfigurationException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnsubscribeFromDatasetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unsubscribeFromDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, unsubscribeFromDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnsubscribeFromDataset");
            UnsubscribeFromDatasetResponse unsubscribeFromDatasetResponse = (UnsubscribeFromDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnsubscribeFromDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)unsubscribeFromDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnsubscribeFromDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unsubscribeFromDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$unsubscribeFromDataset$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRecordsResponse updateRecords(UpdateRecordsRequest updateRecordsRequest) throws InvalidParameterException, LimitExceededException, NotAuthorizedException, ResourceNotFoundException, ResourceConflictException, InvalidLambdaFunctionOutputException, LambdaThrottledException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRecordsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DuplicateRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "LambdaThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "InvalidLambdaFunctionOutputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AlreadyStreamedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncClient.resolveMetricPublishers(clientConfiguration, updateRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRecords");
            UpdateRecordsResponse updateRecordsResponse = (UpdateRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncClient.lambda$updateRecords$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "cognito-sync";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CognitoSyncServiceClientConfigurationBuilder serviceConfigBuilder = new CognitoSyncServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CognitoSyncException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final CognitoSyncServiceClientConfiguration serviceClientConfiguration() {
        return new CognitoSyncServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateRecords$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unsubscribeFromDataset$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$subscribeToDataset$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityPoolConfiguration$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setCognitoEvents$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerDevice$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecords$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityPoolUsage$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasets$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityPoolConfiguration$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCognitoEvents$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBulkPublishDetails$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentityUsage$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentityPoolUsage$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataset$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataset$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$bulkPublish$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

