/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage;
import software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentityPoolUsageResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, ListIdentityPoolUsageResponse> {
    private static final SdkField<List<IdentityPoolUsage>> IDENTITY_POOL_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityPoolUsages").getter(ListIdentityPoolUsageResponse.getter(ListIdentityPoolUsageResponse::identityPoolUsages)).setter(ListIdentityPoolUsageResponse.setter(Builder::identityPoolUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityPoolUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListIdentityPoolUsageResponse.getter(ListIdentityPoolUsageResponse::maxResults)).setter(ListIdentityPoolUsageResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(ListIdentityPoolUsageResponse.getter(ListIdentityPoolUsageResponse::count)).setter(ListIdentityPoolUsageResponse.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIdentityPoolUsageResponse.getter(ListIdentityPoolUsageResponse::nextToken)).setter(ListIdentityPoolUsageResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_USAGES_FIELD, MAX_RESULTS_FIELD, COUNT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIdentityPoolUsageResponse.memberNameToFieldInitializer();
    private final List<IdentityPoolUsage> identityPoolUsages;
    private final Integer maxResults;
    private final Integer count;
    private final String nextToken;

    private ListIdentityPoolUsageResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolUsages = builder.identityPoolUsages;
        this.maxResults = builder.maxResults;
        this.count = builder.count;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIdentityPoolUsages() {
        return this.identityPoolUsages != null && !(this.identityPoolUsages instanceof SdkAutoConstructList);
    }

    public final List<IdentityPoolUsage> identityPoolUsages() {
        return this.identityPoolUsages;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Integer count() {
        return this.count;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityPoolUsages() ? this.identityPoolUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolUsageResponse)) {
            return false;
        }
        ListIdentityPoolUsageResponse other = (ListIdentityPoolUsageResponse)((Object)obj);
        return this.hasIdentityPoolUsages() == other.hasIdentityPoolUsages() && Objects.equals(this.identityPoolUsages(), other.identityPoolUsages()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIdentityPoolUsageResponse").add("IdentityPoolUsages", this.hasIdentityPoolUsages() ? this.identityPoolUsages() : null).add("MaxResults", (Object)this.maxResults()).add("Count", (Object)this.count()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolUsages": {
                return Optional.ofNullable(clazz.cast(this.identityPoolUsages()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentityPoolUsages", IDENTITY_POOL_USAGES_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityPoolUsageResponse, T> g) {
        return obj -> g.apply((ListIdentityPoolUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private List<IdentityPoolUsage> identityPoolUsages = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private Integer count;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolUsageResponse model) {
            super(model);
            this.identityPoolUsages(model.identityPoolUsages);
            this.maxResults(model.maxResults);
            this.count(model.count);
            this.nextToken(model.nextToken);
        }

        public final List<IdentityPoolUsage.Builder> getIdentityPoolUsages() {
            List<IdentityPoolUsage.Builder> result = IdentityPoolUsageListCopier.copyToBuilder(this.identityPoolUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityPoolUsages(Collection<IdentityPoolUsage.BuilderImpl> identityPoolUsages) {
            this.identityPoolUsages = IdentityPoolUsageListCopier.copyFromBuilder(identityPoolUsages);
        }

        @Override
        public final Builder identityPoolUsages(Collection<IdentityPoolUsage> identityPoolUsages) {
            this.identityPoolUsages = IdentityPoolUsageListCopier.copy(identityPoolUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPoolUsages(IdentityPoolUsage ... identityPoolUsages) {
            this.identityPoolUsages(Arrays.asList(identityPoolUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPoolUsages(Consumer<IdentityPoolUsage.Builder> ... identityPoolUsages) {
            this.identityPoolUsages(Stream.of(identityPoolUsages).map(c -> (IdentityPoolUsage)((IdentityPoolUsage.Builder)IdentityPoolUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityPoolUsageResponse build() {
            return new ListIdentityPoolUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIdentityPoolUsageResponse> {
        public Builder identityPoolUsages(Collection<IdentityPoolUsage> var1);

        public Builder identityPoolUsages(IdentityPoolUsage ... var1);

        public Builder identityPoolUsages(Consumer<IdentityPoolUsage.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder count(Integer var1);

        public Builder nextToken(String var1);
    }
}

