/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncRequest;
import software.amazon.awssdk.services.cognitosync.model.EventsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetCognitoEventsRequest
extends CognitoSyncRequest
implements ToCopyableBuilder<Builder, SetCognitoEventsRequest> {
    private final String identityPoolId;
    private final Map<String, String> events;

    private SetCognitoEventsRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.events = builder.events;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Map<String, String> events() {
        return this.events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetCognitoEventsRequest)) {
            return false;
        }
        SetCognitoEventsRequest other = (SetCognitoEventsRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.events(), other.events());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "Events": {
                return Optional.of(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoSyncRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Map<String, String> events;

        private BuilderImpl() {
        }

        private BuilderImpl(SetCognitoEventsRequest model) {
            this.identityPoolId(model.identityPoolId);
            this.events(model.events);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
            return this;
        }

        public final void setEvents(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetCognitoEventsRequest build() {
            return new SetCognitoEventsRequest(this);
        }
    }

    public static interface Builder
    extends CognitoSyncRequest.Builder,
    CopyableBuilder<Builder, SetCognitoEventsRequest> {
        public Builder identityPoolId(String var1);

        public Builder events(Map<String, String> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

