/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage;
import software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsageListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIdentityPoolUsageResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, ListIdentityPoolUsageResponse> {
    private final List<IdentityPoolUsage> identityPoolUsages;
    private final Integer maxResults;
    private final Integer count;
    private final String nextToken;

    private ListIdentityPoolUsageResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolUsages = builder.identityPoolUsages;
        this.maxResults = builder.maxResults;
        this.count = builder.count;
        this.nextToken = builder.nextToken;
    }

    public List<IdentityPoolUsage> identityPoolUsages() {
        return this.identityPoolUsages;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Integer count() {
        return this.count;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolUsages());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolUsageResponse)) {
            return false;
        }
        ListIdentityPoolUsageResponse other = (ListIdentityPoolUsageResponse)((Object)obj);
        return Objects.equals(this.identityPoolUsages(), other.identityPoolUsages()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolUsages() != null) {
            sb.append("IdentityPoolUsages: ").append(this.identityPoolUsages()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolUsages": {
                return Optional.of(clazz.cast(this.identityPoolUsages()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "Count": {
                return Optional.of(clazz.cast(this.count()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private List<IdentityPoolUsage> identityPoolUsages;
        private Integer maxResults;
        private Integer count;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolUsageResponse model) {
            this.identityPoolUsages(model.identityPoolUsages);
            this.maxResults(model.maxResults);
            this.count(model.count);
            this.nextToken(model.nextToken);
        }

        public final Collection<IdentityPoolUsage.Builder> getIdentityPoolUsages() {
            return this.identityPoolUsages != null ? (Collection)this.identityPoolUsages.stream().map(IdentityPoolUsage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identityPoolUsages(Collection<IdentityPoolUsage> identityPoolUsages) {
            this.identityPoolUsages = IdentityPoolUsageListCopier.copy(identityPoolUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPoolUsages(IdentityPoolUsage ... identityPoolUsages) {
            this.identityPoolUsages(Arrays.asList(identityPoolUsages));
            return this;
        }

        public final void setIdentityPoolUsages(Collection<IdentityPoolUsage.BuilderImpl> identityPoolUsages) {
            this.identityPoolUsages = IdentityPoolUsageListCopier.copyFromBuilder(identityPoolUsages);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentityPoolUsageResponse build() {
            return new ListIdentityPoolUsageResponse(this);
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    CopyableBuilder<Builder, ListIdentityPoolUsageResponse> {
        public Builder identityPoolUsages(Collection<IdentityPoolUsage> var1);

        public Builder identityPoolUsages(IdentityPoolUsage ... var1);

        public Builder maxResults(Integer var1);

        public Builder count(Integer var1);

        public Builder nextToken(String var1);
    }
}

