/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cognitosync.model.CognitoStreams;
import software.amazon.awssdk.services.cognitosync.model.PushSync;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetIdentityPoolConfigurationResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, SetIdentityPoolConfigurationResponse> {
    private final String identityPoolId;
    private final PushSync pushSync;
    private final CognitoStreams cognitoStreams;

    private SetIdentityPoolConfigurationResponse(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.pushSync = builder.pushSync;
        this.cognitoStreams = builder.cognitoStreams;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public PushSync pushSync() {
        return this.pushSync;
    }

    public CognitoStreams cognitoStreams() {
        return this.cognitoStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pushSync());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoStreams());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityPoolConfigurationResponse)) {
            return false;
        }
        SetIdentityPoolConfigurationResponse other = (SetIdentityPoolConfigurationResponse)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.pushSync(), other.pushSync()) && Objects.equals(this.cognitoStreams(), other.cognitoStreams());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.pushSync() != null) {
            sb.append("PushSync: ").append(this.pushSync()).append(",");
        }
        if (this.cognitoStreams() != null) {
            sb.append("CognitoStreams: ").append(this.cognitoStreams()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "PushSync": {
                return Optional.of(clazz.cast(this.pushSync()));
            }
            case "CognitoStreams": {
                return Optional.of(clazz.cast(this.cognitoStreams()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private PushSync pushSync;
        private CognitoStreams cognitoStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityPoolConfigurationResponse model) {
            this.identityPoolId(model.identityPoolId);
            this.pushSync(model.pushSync);
            this.cognitoStreams(model.cognitoStreams);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final PushSync.Builder getPushSync() {
            return this.pushSync != null ? this.pushSync.toBuilder() : null;
        }

        @Override
        public final Builder pushSync(PushSync pushSync) {
            this.pushSync = pushSync;
            return this;
        }

        public final void setPushSync(PushSync.BuilderImpl pushSync) {
            this.pushSync = pushSync != null ? pushSync.build() : null;
        }

        public final CognitoStreams.Builder getCognitoStreams() {
            return this.cognitoStreams != null ? this.cognitoStreams.toBuilder() : null;
        }

        @Override
        public final Builder cognitoStreams(CognitoStreams cognitoStreams) {
            this.cognitoStreams = cognitoStreams;
            return this;
        }

        public final void setCognitoStreams(CognitoStreams.BuilderImpl cognitoStreams) {
            this.cognitoStreams = cognitoStreams != null ? cognitoStreams.build() : null;
        }

        public SetIdentityPoolConfigurationResponse build() {
            return new SetIdentityPoolConfigurationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetIdentityPoolConfigurationResponse> {
        public Builder identityPoolId(String var1);

        public Builder pushSync(PushSync var1);

        default public Builder pushSync(Consumer<PushSync.Builder> pushSync) {
            return this.pushSync((PushSync)((PushSync.Builder)PushSync.builder().apply(pushSync)).build());
        }

        public Builder cognitoStreams(CognitoStreams var1);

        default public Builder cognitoStreams(Consumer<CognitoStreams.Builder> cognitoStreams) {
            return this.cognitoStreams((CognitoStreams)((CognitoStreams.Builder)CognitoStreams.builder().apply(cognitoStreams)).build());
        }
    }
}

