/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cognitosync.model.Record;
import software.amazon.awssdk.services.cognitosync.model.RecordListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateRecordsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UpdateRecordsResponse> {
    private final List<Record> records;

    private UpdateRecordsResponse(BuilderImpl builder) {
        this.records = builder.records;
    }

    public List<Record> records() {
        return this.records;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.records() == null ? 0 : this.records().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecordsResponse)) {
            return false;
        }
        UpdateRecordsResponse other = (UpdateRecordsResponse)((Object)obj);
        if (other.records() == null ^ this.records() == null) {
            return false;
        }
        return other.records() == null || other.records().equals(this.records());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.records() != null) {
            sb.append("Records: ").append(this.records()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.of(clazz.cast(this.records()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Record> records;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecordsResponse model) {
            this.records(model.records);
        }

        public final Collection<Record.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        public UpdateRecordsResponse build() {
            return new UpdateRecordsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateRecordsResponse> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);
    }
}

