/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.transform.RecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Record
implements StructuredPojo,
ToCopyableBuilder<Builder, Record> {
    private final String key;
    private final String value;
    private final Long syncCount;
    private final Instant lastModifiedDate;
    private final String lastModifiedBy;
    private final Instant deviceLastModifiedDate;

    private Record(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.syncCount = builder.syncCount;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Long syncCount() {
        return this.syncCount;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Instant deviceLastModifiedDate() {
        return this.deviceLastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.syncCount() == null ? 0 : this.syncCount().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedBy() == null ? 0 : this.lastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.deviceLastModifiedDate() == null ? 0 : this.deviceLastModifiedDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.syncCount() == null ^ this.syncCount() == null) {
            return false;
        }
        if (other.syncCount() != null && !other.syncCount().equals(this.syncCount())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.lastModifiedBy() == null ^ this.lastModifiedBy() == null) {
            return false;
        }
        if (other.lastModifiedBy() != null && !other.lastModifiedBy().equals(this.lastModifiedBy())) {
            return false;
        }
        if (other.deviceLastModifiedDate() == null ^ this.deviceLastModifiedDate() == null) {
            return false;
        }
        return other.deviceLastModifiedDate() == null || other.deviceLastModifiedDate().equals(this.deviceLastModifiedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.syncCount() != null) {
            sb.append("SyncCount: ").append(this.syncCount()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.lastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.lastModifiedBy()).append(",");
        }
        if (this.deviceLastModifiedDate() != null) {
            sb.append("DeviceLastModifiedDate: ").append(this.deviceLastModifiedDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "SyncCount": {
                return Optional.of(clazz.cast(this.syncCount()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
            case "LastModifiedBy": {
                return Optional.of(clazz.cast(this.lastModifiedBy()));
            }
            case "DeviceLastModifiedDate": {
                return Optional.of(clazz.cast(this.deviceLastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private Long syncCount;
        private Instant lastModifiedDate;
        private String lastModifiedBy;
        private Instant deviceLastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.key(model.key);
            this.value(model.value);
            this.syncCount(model.syncCount);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastModifiedBy(model.lastModifiedBy);
            this.deviceLastModifiedDate(model.deviceLastModifiedDate);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Long getSyncCount() {
            return this.syncCount;
        }

        @Override
        public final Builder syncCount(Long syncCount) {
            this.syncCount = syncCount;
            return this;
        }

        public final void setSyncCount(Long syncCount) {
            this.syncCount = syncCount;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Instant getDeviceLastModifiedDate() {
            return this.deviceLastModifiedDate;
        }

        @Override
        public final Builder deviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public final void setDeviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
        }

        public Record build() {
            return new Record(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Record> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder syncCount(Long var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder deviceLastModifiedDate(Instant var1);
    }
}

