/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBulkPublishDetailsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBulkPublishDetailsResponse> {
    private final String identityPoolId;
    private final Instant bulkPublishStartTime;
    private final Instant bulkPublishCompleteTime;
    private final String bulkPublishStatus;
    private final String failureMessage;

    private GetBulkPublishDetailsResponse(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.bulkPublishStartTime = builder.bulkPublishStartTime;
        this.bulkPublishCompleteTime = builder.bulkPublishCompleteTime;
        this.bulkPublishStatus = builder.bulkPublishStatus;
        this.failureMessage = builder.failureMessage;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Instant bulkPublishStartTime() {
        return this.bulkPublishStartTime;
    }

    public Instant bulkPublishCompleteTime() {
        return this.bulkPublishCompleteTime;
    }

    public BulkPublishStatus bulkPublishStatus() {
        return BulkPublishStatus.fromValue(this.bulkPublishStatus);
    }

    public String bulkPublishStatusString() {
        return this.bulkPublishStatus;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.bulkPublishStartTime() == null ? 0 : this.bulkPublishStartTime().hashCode());
        hashCode = 31 * hashCode + (this.bulkPublishCompleteTime() == null ? 0 : this.bulkPublishCompleteTime().hashCode());
        hashCode = 31 * hashCode + (this.bulkPublishStatusString() == null ? 0 : this.bulkPublishStatusString().hashCode());
        hashCode = 31 * hashCode + (this.failureMessage() == null ? 0 : this.failureMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBulkPublishDetailsResponse)) {
            return false;
        }
        GetBulkPublishDetailsResponse other = (GetBulkPublishDetailsResponse)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.bulkPublishStartTime() == null ^ this.bulkPublishStartTime() == null) {
            return false;
        }
        if (other.bulkPublishStartTime() != null && !other.bulkPublishStartTime().equals(this.bulkPublishStartTime())) {
            return false;
        }
        if (other.bulkPublishCompleteTime() == null ^ this.bulkPublishCompleteTime() == null) {
            return false;
        }
        if (other.bulkPublishCompleteTime() != null && !other.bulkPublishCompleteTime().equals(this.bulkPublishCompleteTime())) {
            return false;
        }
        if (other.bulkPublishStatusString() == null ^ this.bulkPublishStatusString() == null) {
            return false;
        }
        if (other.bulkPublishStatusString() != null && !other.bulkPublishStatusString().equals(this.bulkPublishStatusString())) {
            return false;
        }
        if (other.failureMessage() == null ^ this.failureMessage() == null) {
            return false;
        }
        return other.failureMessage() == null || other.failureMessage().equals(this.failureMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.bulkPublishStartTime() != null) {
            sb.append("BulkPublishStartTime: ").append(this.bulkPublishStartTime()).append(",");
        }
        if (this.bulkPublishCompleteTime() != null) {
            sb.append("BulkPublishCompleteTime: ").append(this.bulkPublishCompleteTime()).append(",");
        }
        if (this.bulkPublishStatusString() != null) {
            sb.append("BulkPublishStatus: ").append(this.bulkPublishStatusString()).append(",");
        }
        if (this.failureMessage() != null) {
            sb.append("FailureMessage: ").append(this.failureMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "BulkPublishStartTime": {
                return Optional.of(clazz.cast(this.bulkPublishStartTime()));
            }
            case "BulkPublishCompleteTime": {
                return Optional.of(clazz.cast(this.bulkPublishCompleteTime()));
            }
            case "BulkPublishStatus": {
                return Optional.of(clazz.cast(this.bulkPublishStatusString()));
            }
            case "FailureMessage": {
                return Optional.of(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Instant bulkPublishStartTime;
        private Instant bulkPublishCompleteTime;
        private String bulkPublishStatus;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBulkPublishDetailsResponse model) {
            this.identityPoolId(model.identityPoolId);
            this.bulkPublishStartTime(model.bulkPublishStartTime);
            this.bulkPublishCompleteTime(model.bulkPublishCompleteTime);
            this.bulkPublishStatus(model.bulkPublishStatus);
            this.failureMessage(model.failureMessage);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Instant getBulkPublishStartTime() {
            return this.bulkPublishStartTime;
        }

        @Override
        public final Builder bulkPublishStartTime(Instant bulkPublishStartTime) {
            this.bulkPublishStartTime = bulkPublishStartTime;
            return this;
        }

        public final void setBulkPublishStartTime(Instant bulkPublishStartTime) {
            this.bulkPublishStartTime = bulkPublishStartTime;
        }

        public final Instant getBulkPublishCompleteTime() {
            return this.bulkPublishCompleteTime;
        }

        @Override
        public final Builder bulkPublishCompleteTime(Instant bulkPublishCompleteTime) {
            this.bulkPublishCompleteTime = bulkPublishCompleteTime;
            return this;
        }

        public final void setBulkPublishCompleteTime(Instant bulkPublishCompleteTime) {
            this.bulkPublishCompleteTime = bulkPublishCompleteTime;
        }

        public final String getBulkPublishStatus() {
            return this.bulkPublishStatus;
        }

        @Override
        public final Builder bulkPublishStatus(String bulkPublishStatus) {
            this.bulkPublishStatus = bulkPublishStatus;
            return this;
        }

        @Override
        public final Builder bulkPublishStatus(BulkPublishStatus bulkPublishStatus) {
            this.bulkPublishStatus(bulkPublishStatus.toString());
            return this;
        }

        public final void setBulkPublishStatus(String bulkPublishStatus) {
            this.bulkPublishStatus = bulkPublishStatus;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public GetBulkPublishDetailsResponse build() {
            return new GetBulkPublishDetailsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBulkPublishDetailsResponse> {
        public Builder identityPoolId(String var1);

        public Builder bulkPublishStartTime(Instant var1);

        public Builder bulkPublishCompleteTime(Instant var1);

        public Builder bulkPublishStatus(String var1);

        public Builder bulkPublishStatus(BulkPublishStatus var1);

        public Builder failureMessage(String var1);
    }
}

