/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeIdentityUsageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeIdentityUsageRequest> {
    private final String identityPoolId;
    private final String identityId;

    private DescribeIdentityUsageRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityId() {
        return this.identityId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityUsageRequest)) {
            return false;
        }
        DescribeIdentityUsageRequest other = (DescribeIdentityUsageRequest)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        return other.identityId() == null || other.identityId().equals(this.identityId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityUsageRequest model) {
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public DescribeIdentityUsageRequest build() {
            return new DescribeIdentityUsageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeIdentityUsageRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);
    }
}

