/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cognitosync.model.Dataset;
import software.amazon.awssdk.services.cognitosync.model.DatasetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDatasetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDatasetsResponse> {
    private final List<Dataset> datasets;
    private final Integer count;
    private final String nextToken;

    private ListDatasetsResponse(BuilderImpl builder) {
        this.datasets = builder.datasets;
        this.count = builder.count;
        this.nextToken = builder.nextToken;
    }

    public List<Dataset> datasets() {
        return this.datasets;
    }

    public Integer count() {
        return this.count;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.datasets() == null ? 0 : this.datasets().hashCode());
        hashCode = 31 * hashCode + (this.count() == null ? 0 : this.count().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetsResponse)) {
            return false;
        }
        ListDatasetsResponse other = (ListDatasetsResponse)((Object)obj);
        if (other.datasets() == null ^ this.datasets() == null) {
            return false;
        }
        if (other.datasets() != null && !other.datasets().equals(this.datasets())) {
            return false;
        }
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.datasets() != null) {
            sb.append("Datasets: ").append(this.datasets()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Dataset> datasets;
        private Integer count;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetsResponse model) {
            this.setDatasets(model.datasets);
            this.setCount(model.count);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Dataset> getDatasets() {
            return this.datasets;
        }

        @Override
        public final Builder datasets(Collection<Dataset> datasets) {
            this.datasets = DatasetListCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Dataset ... datasets) {
            this.datasets(Arrays.asList(datasets));
            return this;
        }

        public final void setDatasets(Collection<Dataset> datasets) {
            this.datasets = DatasetListCopier.copy(datasets);
        }

        @SafeVarargs
        public final void setDatasets(Dataset ... datasets) {
            this.datasets(Arrays.asList(datasets));
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDatasetsResponse build() {
            return new ListDatasetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDatasetsResponse> {
        public Builder datasets(Collection<Dataset> var1);

        public Builder datasets(Dataset ... var1);

        public Builder count(Integer var1);

        public Builder nextToken(String var1);
    }
}

