/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncRequest;
import software.amazon.awssdk.services.cognitosync.model.Platform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterDeviceRequest
extends CognitoSyncRequest
implements ToCopyableBuilder<Builder, RegisterDeviceRequest> {
    private final String identityPoolId;
    private final String identityId;
    private final String platform;
    private final String token;

    private RegisterDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.platform = builder.platform;
        this.token = builder.token;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityId() {
        return this.identityId;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public String token() {
        return this.token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDeviceRequest)) {
            return false;
        }
        RegisterDeviceRequest other = (RegisterDeviceRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.token(), other.token());
    }

    public String toString() {
        return ToString.builder((String)"RegisterDeviceRequest").add("IdentityPoolId", (Object)this.identityPoolId()).add("IdentityId", (Object)this.identityId()).add("Platform", (Object)this.platformAsString()).add("Token", (Object)this.token()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platformAsString()));
            }
            case "Token": {
                return Optional.of(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoSyncRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private String platform;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDeviceRequest model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
            this.platform(model.platform);
            this.token(model.token);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterDeviceRequest build() {
            return new RegisterDeviceRequest(this);
        }
    }

    public static interface Builder
    extends CognitoSyncRequest.Builder,
    CopyableBuilder<Builder, RegisterDeviceRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder token(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

