/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.model.Operation;
import software.amazon.awssdk.services.cognitosync.transform.RecordPatchMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecordPatch
implements StructuredPojo,
ToCopyableBuilder<Builder, RecordPatch> {
    private final String op;
    private final String key;
    private final String value;
    private final Long syncCount;
    private final Instant deviceLastModifiedDate;

    private RecordPatch(BuilderImpl builder) {
        this.op = builder.op;
        this.key = builder.key;
        this.value = builder.value;
        this.syncCount = builder.syncCount;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate;
    }

    public Operation op() {
        return Operation.fromValue(this.op);
    }

    public String opAsString() {
        return this.op;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Long syncCount() {
        return this.syncCount;
    }

    public Instant deviceLastModifiedDate() {
        return this.deviceLastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.opAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceLastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordPatch)) {
            return false;
        }
        RecordPatch other = (RecordPatch)obj;
        return Objects.equals(this.opAsString(), other.opAsString()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.syncCount(), other.syncCount()) && Objects.equals(this.deviceLastModifiedDate(), other.deviceLastModifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"RecordPatch").add("Op", (Object)this.opAsString()).add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("SyncCount", (Object)this.syncCount()).add("DeviceLastModifiedDate", (Object)this.deviceLastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Op": {
                return Optional.of(clazz.cast(this.opAsString()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "SyncCount": {
                return Optional.of(clazz.cast(this.syncCount()));
            }
            case "DeviceLastModifiedDate": {
                return Optional.of(clazz.cast(this.deviceLastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordPatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String op;
        private String key;
        private String value;
        private Long syncCount;
        private Instant deviceLastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordPatch model) {
            this.op(model.op);
            this.key(model.key);
            this.value(model.value);
            this.syncCount(model.syncCount);
            this.deviceLastModifiedDate(model.deviceLastModifiedDate);
        }

        public final String getOp() {
            return this.op;
        }

        @Override
        public final Builder op(String op) {
            this.op = op;
            return this;
        }

        @Override
        public final Builder op(Operation op) {
            this.op(op.toString());
            return this;
        }

        public final void setOp(String op) {
            this.op = op;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Long getSyncCount() {
            return this.syncCount;
        }

        @Override
        public final Builder syncCount(Long syncCount) {
            this.syncCount = syncCount;
            return this;
        }

        public final void setSyncCount(Long syncCount) {
            this.syncCount = syncCount;
        }

        public final Instant getDeviceLastModifiedDate() {
            return this.deviceLastModifiedDate;
        }

        @Override
        public final Builder deviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public final void setDeviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
        }

        public RecordPatch build() {
            return new RecordPatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecordPatch> {
        public Builder op(String var1);

        public Builder op(Operation var1);

        public Builder key(String var1);

        public Builder value(String var1);

        public Builder syncCount(Long var1);

        public Builder deviceLastModifiedDate(Instant var1);
    }
}

