/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.model.StreamingStatus;
import software.amazon.awssdk.services.cognitosync.transform.CognitoStreamsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CognitoStreams
implements StructuredPojo,
ToCopyableBuilder<Builder, CognitoStreams> {
    private final String streamName;
    private final String roleArn;
    private final String streamingStatus;

    private CognitoStreams(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.roleArn = builder.roleArn;
        this.streamingStatus = builder.streamingStatus;
    }

    public String streamName() {
        return this.streamName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public StreamingStatus streamingStatus() {
        return StreamingStatus.fromValue(this.streamingStatus);
    }

    public String streamingStatusAsString() {
        return this.streamingStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoStreams)) {
            return false;
        }
        CognitoStreams other = (CognitoStreams)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.streamingStatusAsString(), other.streamingStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"CognitoStreams").add("StreamName", (Object)this.streamName()).add("RoleArn", (Object)this.roleArn()).add("StreamingStatus", (Object)this.streamingStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "StreamingStatus": {
                return Optional.of(clazz.cast(this.streamingStatusAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CognitoStreamsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String roleArn;
        private String streamingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoStreams model) {
            this.streamName(model.streamName);
            this.roleArn(model.roleArn);
            this.streamingStatus(model.streamingStatus);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamingStatus() {
            return this.streamingStatus;
        }

        @Override
        public final Builder streamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
            return this;
        }

        @Override
        public final Builder streamingStatus(StreamingStatus streamingStatus) {
            this.streamingStatus(streamingStatus.toString());
            return this;
        }

        public final void setStreamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
        }

        public CognitoStreams build() {
            return new CognitoStreams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CognitoStreams> {
        public Builder streamName(String var1);

        public Builder roleArn(String var1);

        public Builder streamingStatus(String var1);

        public Builder streamingStatus(StreamingStatus var1);
    }
}

