/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitosync.model.Record;

@SdkInternalApi
public class RecordMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Long> SYNCCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncCount").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").build();
    private static final MarshallingInfo<String> LASTMODIFIEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedBy").build();
    private static final MarshallingInfo<Date> DEVICELASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceLastModifiedDate").build();
    private static final RecordMarshaller instance = new RecordMarshaller();

    public static RecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(Record record, ProtocolMarshaller protocolMarshaller) {
        if (record == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)record.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)record.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)record.syncCount(), SYNCCOUNT_BINDING);
            protocolMarshaller.marshall((Object)record.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)record.lastModifiedBy(), LASTMODIFIEDBY_BINDING);
            protocolMarshaller.marshall((Object)record.deviceLastModifiedDate(), DEVICELASTMODIFIEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

