/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.model.StreamingStatus;
import software.amazon.awssdk.services.cognitosync.transform.CognitoStreamsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CognitoStreams
implements StructuredPojo,
ToCopyableBuilder<Builder, CognitoStreams> {
    private final String streamName;
    private final String roleArn;
    private final String streamingStatus;

    private CognitoStreams(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.roleArn = builder.roleArn;
        this.streamingStatus = builder.streamingStatus;
    }

    public String streamName() {
        return this.streamName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String streamingStatus() {
        return this.streamingStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.streamingStatus() == null ? 0 : this.streamingStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoStreams)) {
            return false;
        }
        CognitoStreams other = (CognitoStreams)obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.streamingStatus() == null ^ this.streamingStatus() == null) {
            return false;
        }
        return other.streamingStatus() == null || other.streamingStatus().equals(this.streamingStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.streamingStatus() != null) {
            sb.append("StreamingStatus: ").append(this.streamingStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CognitoStreamsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String roleArn;
        private String streamingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoStreams model) {
            this.setStreamName(model.streamName);
            this.setRoleArn(model.roleArn);
            this.setStreamingStatus(model.streamingStatus);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamingStatus() {
            return this.streamingStatus;
        }

        @Override
        public final Builder streamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
            return this;
        }

        @Override
        public final Builder streamingStatus(StreamingStatus streamingStatus) {
            this.streamingStatus(streamingStatus.toString());
            return this;
        }

        public final void setStreamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
        }

        public final void setStreamingStatus(StreamingStatus streamingStatus) {
            this.streamingStatus(streamingStatus.toString());
        }

        public CognitoStreams build() {
            return new CognitoStreams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CognitoStreams> {
        public Builder streamName(String var1);

        public Builder roleArn(String var1);

        public Builder streamingStatus(String var1);

        public Builder streamingStatus(StreamingStatus var1);
    }
}

