/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AuthFlowType {
    USER_SRP_AUTH("USER_SRP_AUTH"),
    REFRESH_TOKEN_AUTH("REFRESH_TOKEN_AUTH"),
    REFRESH_TOKEN("REFRESH_TOKEN"),
    CUSTOM_AUTH("CUSTOM_AUTH"),
    ADMIN_NO_SRP_AUTH("ADMIN_NO_SRP_AUTH"),
    USER_PASSWORD_AUTH("USER_PASSWORD_AUTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AuthFlowType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthFlowType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AuthFlowType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthFlowType> knownValues() {
        return Stream.of(AuthFlowType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

