/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a passkey, or webauthN, biometric or security-key authentication factor for a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebAuthnCredentialDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<WebAuthnCredentialDescription.Builder, WebAuthnCredentialDescription> {
    private static final SdkField<String> CREDENTIAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialId").getter(getter(WebAuthnCredentialDescription::credentialId))
            .setter(setter(Builder::credentialId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialId").build()).build();

    private static final SdkField<String> FRIENDLY_CREDENTIAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FriendlyCredentialName").getter(getter(WebAuthnCredentialDescription::friendlyCredentialName))
            .setter(setter(Builder::friendlyCredentialName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FriendlyCredentialName").build())
            .build();

    private static final SdkField<String> RELYING_PARTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelyingPartyId").getter(getter(WebAuthnCredentialDescription::relyingPartyId))
            .setter(setter(Builder::relyingPartyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelyingPartyId").build()).build();

    private static final SdkField<String> AUTHENTICATOR_ATTACHMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticatorAttachment").getter(getter(WebAuthnCredentialDescription::authenticatorAttachment))
            .setter(setter(Builder::authenticatorAttachment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticatorAttachment").build())
            .build();

    private static final SdkField<List<String>> AUTHENTICATOR_TRANSPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthenticatorTransports")
            .getter(getter(WebAuthnCredentialDescription::authenticatorTransports))
            .setter(setter(Builder::authenticatorTransports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticatorTransports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(WebAuthnCredentialDescription::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_ID_FIELD,
            FRIENDLY_CREDENTIAL_NAME_FIELD, RELYING_PARTY_ID_FIELD, AUTHENTICATOR_ATTACHMENT_FIELD,
            AUTHENTICATOR_TRANSPORTS_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String credentialId;

    private final String friendlyCredentialName;

    private final String relyingPartyId;

    private final String authenticatorAttachment;

    private final List<String> authenticatorTransports;

    private final Instant createdAt;

    private WebAuthnCredentialDescription(BuilderImpl builder) {
        this.credentialId = builder.credentialId;
        this.friendlyCredentialName = builder.friendlyCredentialName;
        this.relyingPartyId = builder.relyingPartyId;
        this.authenticatorAttachment = builder.authenticatorAttachment;
        this.authenticatorTransports = builder.authenticatorTransports;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The unique identifier of the passkey credential.
     * </p>
     * 
     * @return The unique identifier of the passkey credential.
     */
    public final String credentialId() {
        return credentialId;
    }

    /**
     * <p>
     * An automatically-generated friendly name for the passkey credential.
     * </p>
     * 
     * @return An automatically-generated friendly name for the passkey credential.
     */
    public final String friendlyCredentialName() {
        return friendlyCredentialName;
    }

    /**
     * <p>
     * The relying-party ID of the provider for the passkey credential.
     * </p>
     * 
     * @return The relying-party ID of the provider for the passkey credential.
     */
    public final String relyingPartyId() {
        return relyingPartyId;
    }

    /**
     * <p>
     * The general category of the passkey authenticator. Can be a platform, or on-device authenticator like a built-in
     * fingerprint scanner, or a cross-platform device that's not attached to the device like a Bluetooth security key.
     * </p>
     * 
     * @return The general category of the passkey authenticator. Can be a platform, or on-device authenticator like a
     *         built-in fingerprint scanner, or a cross-platform device that's not attached to the device like a
     *         Bluetooth security key.
     */
    public final String authenticatorAttachment() {
        return authenticatorAttachment;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthenticatorTransports property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthenticatorTransports() {
        return authenticatorTransports != null && !(authenticatorTransports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the transport methods of the passkey credential, for example USB or Bluetooth Low Energy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticatorTransports} method.
     * </p>
     * 
     * @return Information about the transport methods of the passkey credential, for example USB or Bluetooth Low
     *         Energy.
     */
    public final List<String> authenticatorTransports() {
        return authenticatorTransports;
    }

    /**
     * <p>
     * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format.
     * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
     * </p>
     * 
     * @return The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time
     *         format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
     *         <code>Date</code> object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentialId());
        hashCode = 31 * hashCode + Objects.hashCode(friendlyCredentialName());
        hashCode = 31 * hashCode + Objects.hashCode(relyingPartyId());
        hashCode = 31 * hashCode + Objects.hashCode(authenticatorAttachment());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthenticatorTransports() ? authenticatorTransports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebAuthnCredentialDescription)) {
            return false;
        }
        WebAuthnCredentialDescription other = (WebAuthnCredentialDescription) obj;
        return Objects.equals(credentialId(), other.credentialId())
                && Objects.equals(friendlyCredentialName(), other.friendlyCredentialName())
                && Objects.equals(relyingPartyId(), other.relyingPartyId())
                && Objects.equals(authenticatorAttachment(), other.authenticatorAttachment())
                && hasAuthenticatorTransports() == other.hasAuthenticatorTransports()
                && Objects.equals(authenticatorTransports(), other.authenticatorTransports())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebAuthnCredentialDescription").add("CredentialId", credentialId())
                .add("FriendlyCredentialName", friendlyCredentialName()).add("RelyingPartyId", relyingPartyId())
                .add("AuthenticatorAttachment", authenticatorAttachment())
                .add("AuthenticatorTransports", hasAuthenticatorTransports() ? authenticatorTransports() : null)
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CredentialId":
            return Optional.ofNullable(clazz.cast(credentialId()));
        case "FriendlyCredentialName":
            return Optional.ofNullable(clazz.cast(friendlyCredentialName()));
        case "RelyingPartyId":
            return Optional.ofNullable(clazz.cast(relyingPartyId()));
        case "AuthenticatorAttachment":
            return Optional.ofNullable(clazz.cast(authenticatorAttachment()));
        case "AuthenticatorTransports":
            return Optional.ofNullable(clazz.cast(authenticatorTransports()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CredentialId", CREDENTIAL_ID_FIELD);
        map.put("FriendlyCredentialName", FRIENDLY_CREDENTIAL_NAME_FIELD);
        map.put("RelyingPartyId", RELYING_PARTY_ID_FIELD);
        map.put("AuthenticatorAttachment", AUTHENTICATOR_ATTACHMENT_FIELD);
        map.put("AuthenticatorTransports", AUTHENTICATOR_TRANSPORTS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebAuthnCredentialDescription, T> g) {
        return obj -> g.apply((WebAuthnCredentialDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebAuthnCredentialDescription> {
        /**
         * <p>
         * The unique identifier of the passkey credential.
         * </p>
         * 
         * @param credentialId
         *        The unique identifier of the passkey credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialId(String credentialId);

        /**
         * <p>
         * An automatically-generated friendly name for the passkey credential.
         * </p>
         * 
         * @param friendlyCredentialName
         *        An automatically-generated friendly name for the passkey credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friendlyCredentialName(String friendlyCredentialName);

        /**
         * <p>
         * The relying-party ID of the provider for the passkey credential.
         * </p>
         * 
         * @param relyingPartyId
         *        The relying-party ID of the provider for the passkey credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relyingPartyId(String relyingPartyId);

        /**
         * <p>
         * The general category of the passkey authenticator. Can be a platform, or on-device authenticator like a
         * built-in fingerprint scanner, or a cross-platform device that's not attached to the device like a Bluetooth
         * security key.
         * </p>
         * 
         * @param authenticatorAttachment
         *        The general category of the passkey authenticator. Can be a platform, or on-device authenticator like
         *        a built-in fingerprint scanner, or a cross-platform device that's not attached to the device like a
         *        Bluetooth security key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticatorAttachment(String authenticatorAttachment);

        /**
         * <p>
         * Information about the transport methods of the passkey credential, for example USB or Bluetooth Low Energy.
         * </p>
         * 
         * @param authenticatorTransports
         *        Information about the transport methods of the passkey credential, for example USB or Bluetooth Low
         *        Energy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticatorTransports(Collection<String> authenticatorTransports);

        /**
         * <p>
         * Information about the transport methods of the passkey credential, for example USB or Bluetooth Low Energy.
         * </p>
         * 
         * @param authenticatorTransports
         *        Information about the transport methods of the passkey credential, for example USB or Bluetooth Low
         *        Energy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticatorTransports(String... authenticatorTransports);

        /**
         * <p>
         * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format.
         * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time
         *        format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
         *        <code>Date</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String credentialId;

        private String friendlyCredentialName;

        private String relyingPartyId;

        private String authenticatorAttachment;

        private List<String> authenticatorTransports = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(WebAuthnCredentialDescription model) {
            credentialId(model.credentialId);
            friendlyCredentialName(model.friendlyCredentialName);
            relyingPartyId(model.relyingPartyId);
            authenticatorAttachment(model.authenticatorAttachment);
            authenticatorTransports(model.authenticatorTransports);
            createdAt(model.createdAt);
        }

        public final String getCredentialId() {
            return credentialId;
        }

        public final void setCredentialId(String credentialId) {
            this.credentialId = credentialId;
        }

        @Override
        public final Builder credentialId(String credentialId) {
            this.credentialId = credentialId;
            return this;
        }

        public final String getFriendlyCredentialName() {
            return friendlyCredentialName;
        }

        public final void setFriendlyCredentialName(String friendlyCredentialName) {
            this.friendlyCredentialName = friendlyCredentialName;
        }

        @Override
        public final Builder friendlyCredentialName(String friendlyCredentialName) {
            this.friendlyCredentialName = friendlyCredentialName;
            return this;
        }

        public final String getRelyingPartyId() {
            return relyingPartyId;
        }

        public final void setRelyingPartyId(String relyingPartyId) {
            this.relyingPartyId = relyingPartyId;
        }

        @Override
        public final Builder relyingPartyId(String relyingPartyId) {
            this.relyingPartyId = relyingPartyId;
            return this;
        }

        public final String getAuthenticatorAttachment() {
            return authenticatorAttachment;
        }

        public final void setAuthenticatorAttachment(String authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
        }

        @Override
        public final Builder authenticatorAttachment(String authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
            return this;
        }

        public final Collection<String> getAuthenticatorTransports() {
            if (authenticatorTransports instanceof SdkAutoConstructList) {
                return null;
            }
            return authenticatorTransports;
        }

        public final void setAuthenticatorTransports(Collection<String> authenticatorTransports) {
            this.authenticatorTransports = WebAuthnAuthenticatorTransportsListCopier.copy(authenticatorTransports);
        }

        @Override
        public final Builder authenticatorTransports(Collection<String> authenticatorTransports) {
            this.authenticatorTransports = WebAuthnAuthenticatorTransportsListCopier.copy(authenticatorTransports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticatorTransports(String... authenticatorTransports) {
            authenticatorTransports(Arrays.asList(authenticatorTransports));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public WebAuthnCredentialDescription build() {
            return new WebAuthnCredentialDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
