/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Secure Remote Password (SRP) value that your application generates when you register a user's device. For more
 * information, see <a href=
 * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html#user-pools-remembered-devices-getting-a-device-key"
 * >Getting a device key</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceSecretVerifierConfigType implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceSecretVerifierConfigType.Builder, DeviceSecretVerifierConfigType> {
    private static final SdkField<String> PASSWORD_VERIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PasswordVerifier").getter(getter(DeviceSecretVerifierConfigType::passwordVerifier))
            .setter(setter(Builder::passwordVerifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordVerifier").build()).build();

    private static final SdkField<String> SALT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Salt")
            .getter(getter(DeviceSecretVerifierConfigType::salt)).setter(setter(Builder::salt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSWORD_VERIFIER_FIELD,
            SALT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String passwordVerifier;

    private final String salt;

    private DeviceSecretVerifierConfigType(BuilderImpl builder) {
        this.passwordVerifier = builder.passwordVerifier;
        this.salt = builder.salt;
    }

    /**
     * <p>
     * A password verifier for a user's device. Used in SRP authentication.
     * </p>
     * 
     * @return A password verifier for a user's device. Used in SRP authentication.
     */
    public final String passwordVerifier() {
        return passwordVerifier;
    }

    /**
     * <p>
     * The salt that you want to use in SRP authentication with the user's device.
     * </p>
     * 
     * @return The salt that you want to use in SRP authentication with the user's device.
     */
    public final String salt() {
        return salt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(passwordVerifier());
        hashCode = 31 * hashCode + Objects.hashCode(salt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSecretVerifierConfigType)) {
            return false;
        }
        DeviceSecretVerifierConfigType other = (DeviceSecretVerifierConfigType) obj;
        return Objects.equals(passwordVerifier(), other.passwordVerifier()) && Objects.equals(salt(), other.salt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceSecretVerifierConfigType").add("PasswordVerifier", passwordVerifier()).add("Salt", salt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PasswordVerifier":
            return Optional.ofNullable(clazz.cast(passwordVerifier()));
        case "Salt":
            return Optional.ofNullable(clazz.cast(salt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PasswordVerifier", PASSWORD_VERIFIER_FIELD);
        map.put("Salt", SALT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceSecretVerifierConfigType, T> g) {
        return obj -> g.apply((DeviceSecretVerifierConfigType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceSecretVerifierConfigType> {
        /**
         * <p>
         * A password verifier for a user's device. Used in SRP authentication.
         * </p>
         * 
         * @param passwordVerifier
         *        A password verifier for a user's device. Used in SRP authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordVerifier(String passwordVerifier);

        /**
         * <p>
         * The salt that you want to use in SRP authentication with the user's device.
         * </p>
         * 
         * @param salt
         *        The salt that you want to use in SRP authentication with the user's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salt(String salt);
    }

    static final class BuilderImpl implements Builder {
        private String passwordVerifier;

        private String salt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSecretVerifierConfigType model) {
            passwordVerifier(model.passwordVerifier);
            salt(model.salt);
        }

        public final String getPasswordVerifier() {
            return passwordVerifier;
        }

        public final void setPasswordVerifier(String passwordVerifier) {
            this.passwordVerifier = passwordVerifier;
        }

        @Override
        public final Builder passwordVerifier(String passwordVerifier) {
            this.passwordVerifier = passwordVerifier;
            return this;
        }

        public final String getSalt() {
            return salt;
        }

        public final void setSalt(String salt) {
            this.salt = salt;
        }

        @Override
        public final Builder salt(String salt) {
            this.salt = salt;
            return this;
        }

        @Override
        public DeviceSecretVerifierConfigType build() {
            return new DeviceSecretVerifierConfigType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
