/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthFactorType {
    PASSWORD("PASSWORD"),
    EMAIL_OTP("EMAIL_OTP"),
    SMS_OTP("SMS_OTP"),
    WEB_AUTHN("WEB_AUTHN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthFactorType> VALUE_MAP;
    private final String value;

    private AuthFactorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthFactorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthFactorType> knownValues() {
        EnumSet<AuthFactorType> knownValues = EnumSet.allOf(AuthFactorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthFactorType.class, AuthFactorType::toString);
    }
}

