/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateManagedLoginBrandingRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<UpdateManagedLoginBrandingRequest.Builder, UpdateManagedLoginBrandingRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(UpdateManagedLoginBrandingRequest::userPoolId))
            .setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> MANAGED_LOGIN_BRANDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedLoginBrandingId").getter(getter(UpdateManagedLoginBrandingRequest::managedLoginBrandingId))
            .setter(setter(Builder::managedLoginBrandingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoginBrandingId").build())
            .build();

    private static final SdkField<Boolean> USE_COGNITO_PROVIDED_VALUES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("UseCognitoProvidedValues")
            .getter(getter(UpdateManagedLoginBrandingRequest::useCognitoProvidedValues))
            .setter(setter(Builder::useCognitoProvidedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCognitoProvidedValues").build())
            .build();

    private static final SdkField<Document> SETTINGS_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("Settings").getter(getter(UpdateManagedLoginBrandingRequest::settings)).setter(setter(Builder::settings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<List<AssetType>> ASSETS_FIELD = SdkField
            .<List<AssetType>> builder(MarshallingType.LIST)
            .memberName("Assets")
            .getter(getter(UpdateManagedLoginBrandingRequest::assets))
            .setter(setter(Builder::assets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetType> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            MANAGED_LOGIN_BRANDING_ID_FIELD, USE_COGNITO_PROVIDED_VALUES_FIELD, SETTINGS_FIELD, ASSETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userPoolId;

    private final String managedLoginBrandingId;

    private final Boolean useCognitoProvidedValues;

    private final Document settings;

    private final List<AssetType> assets;

    private UpdateManagedLoginBrandingRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.managedLoginBrandingId = builder.managedLoginBrandingId;
        this.useCognitoProvidedValues = builder.useCognitoProvidedValues;
        this.settings = builder.settings;
        this.assets = builder.assets;
    }

    /**
     * <p>
     * The ID of the user pool that contains the managed login branding style that you want to update.
     * </p>
     * 
     * @return The ID of the user pool that contains the managed login branding style that you want to update.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The ID of the managed login branding style that you want to update.
     * </p>
     * 
     * @return The ID of the managed login branding style that you want to update.
     */
    public final String managedLoginBrandingId() {
        return managedLoginBrandingId;
    }

    /**
     * <p>
     * When <code>true</code>, applies the default branding style options. This option reverts to default style options
     * that are managed by Amazon Cognito. You can modify them later in the branding designer.
     * </p>
     * <p>
     * When you specify <code>true</code> for this option, you must also omit values for <code>Settings</code> and
     * <code>Assets</code> in the request.
     * </p>
     * 
     * @return When <code>true</code>, applies the default branding style options. This option reverts to default style
     *         options that are managed by Amazon Cognito. You can modify them later in the branding designer.</p>
     *         <p>
     *         When you specify <code>true</code> for this option, you must also omit values for <code>Settings</code>
     *         and <code>Assets</code> in the request.
     */
    public final Boolean useCognitoProvidedValues() {
        return useCognitoProvidedValues;
    }

    /**
     * <p>
     * A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to your style.
     * </p>
     * 
     * @return A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to
     *         your style.
     */
    public final Document settings() {
        return settings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Assets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAssets() {
        return assets != null && !(assets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of image files that you want to apply to roles like backgrounds, logos, and icons. Each object must also
     * indicate whether it is for dark mode, light mode, or browser-adaptive mode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssets} method.
     * </p>
     * 
     * @return An array of image files that you want to apply to roles like backgrounds, logos, and icons. Each object
     *         must also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
     */
    public final List<AssetType> assets() {
        return assets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(managedLoginBrandingId());
        hashCode = 31 * hashCode + Objects.hashCode(useCognitoProvidedValues());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssets() ? assets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateManagedLoginBrandingRequest)) {
            return false;
        }
        UpdateManagedLoginBrandingRequest other = (UpdateManagedLoginBrandingRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(managedLoginBrandingId(), other.managedLoginBrandingId())
                && Objects.equals(useCognitoProvidedValues(), other.useCognitoProvidedValues())
                && Objects.equals(settings(), other.settings()) && hasAssets() == other.hasAssets()
                && Objects.equals(assets(), other.assets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateManagedLoginBrandingRequest").add("UserPoolId", userPoolId())
                .add("ManagedLoginBrandingId", managedLoginBrandingId())
                .add("UseCognitoProvidedValues", useCognitoProvidedValues()).add("Settings", settings())
                .add("Assets", hasAssets() ? assets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ManagedLoginBrandingId":
            return Optional.ofNullable(clazz.cast(managedLoginBrandingId()));
        case "UseCognitoProvidedValues":
            return Optional.ofNullable(clazz.cast(useCognitoProvidedValues()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "Assets":
            return Optional.ofNullable(clazz.cast(assets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ManagedLoginBrandingId", MANAGED_LOGIN_BRANDING_ID_FIELD);
        map.put("UseCognitoProvidedValues", USE_COGNITO_PROVIDED_VALUES_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("Assets", ASSETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateManagedLoginBrandingRequest, T> g) {
        return obj -> g.apply((UpdateManagedLoginBrandingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateManagedLoginBrandingRequest> {
        /**
         * <p>
         * The ID of the user pool that contains the managed login branding style that you want to update.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool that contains the managed login branding style that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The ID of the managed login branding style that you want to update.
         * </p>
         * 
         * @param managedLoginBrandingId
         *        The ID of the managed login branding style that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedLoginBrandingId(String managedLoginBrandingId);

        /**
         * <p>
         * When <code>true</code>, applies the default branding style options. This option reverts to default style
         * options that are managed by Amazon Cognito. You can modify them later in the branding designer.
         * </p>
         * <p>
         * When you specify <code>true</code> for this option, you must also omit values for <code>Settings</code> and
         * <code>Assets</code> in the request.
         * </p>
         * 
         * @param useCognitoProvidedValues
         *        When <code>true</code>, applies the default branding style options. This option reverts to default
         *        style options that are managed by Amazon Cognito. You can modify them later in the branding
         *        designer.</p>
         *        <p>
         *        When you specify <code>true</code> for this option, you must also omit values for
         *        <code>Settings</code> and <code>Assets</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCognitoProvidedValues(Boolean useCognitoProvidedValues);

        /**
         * <p>
         * A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to your
         * style.
         * </p>
         * 
         * @param settings
         *        A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to
         *        your style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Document settings);

        /**
         * <p>
         * An array of image files that you want to apply to roles like backgrounds, logos, and icons. Each object must
         * also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
         * </p>
         * 
         * @param assets
         *        An array of image files that you want to apply to roles like backgrounds, logos, and icons. Each
         *        object must also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(Collection<AssetType> assets);

        /**
         * <p>
         * An array of image files that you want to apply to roles like backgrounds, logos, and icons. Each object must
         * also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
         * </p>
         * 
         * @param assets
         *        An array of image files that you want to apply to roles like backgrounds, logos, and icons. Each
         *        object must also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(AssetType... assets);

        /**
         * <p>
         * An array of image files that you want to apply to roles like backgrounds, logos, and icons. Each object must
         * also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AssetType.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AssetType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AssetType.Builder#build()} is called
         * immediately and its result is passed to {@link #assets(List<AssetType>)}.
         * 
         * @param assets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AssetType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assets(java.util.Collection<AssetType>)
         */
        Builder assets(Consumer<AssetType.Builder>... assets);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String managedLoginBrandingId;

        private Boolean useCognitoProvidedValues;

        private Document settings;

        private List<AssetType> assets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateManagedLoginBrandingRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            managedLoginBrandingId(model.managedLoginBrandingId);
            useCognitoProvidedValues(model.useCognitoProvidedValues);
            settings(model.settings);
            assets(model.assets);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getManagedLoginBrandingId() {
            return managedLoginBrandingId;
        }

        public final void setManagedLoginBrandingId(String managedLoginBrandingId) {
            this.managedLoginBrandingId = managedLoginBrandingId;
        }

        @Override
        public final Builder managedLoginBrandingId(String managedLoginBrandingId) {
            this.managedLoginBrandingId = managedLoginBrandingId;
            return this;
        }

        public final Boolean getUseCognitoProvidedValues() {
            return useCognitoProvidedValues;
        }

        public final void setUseCognitoProvidedValues(Boolean useCognitoProvidedValues) {
            this.useCognitoProvidedValues = useCognitoProvidedValues;
        }

        @Override
        public final Builder useCognitoProvidedValues(Boolean useCognitoProvidedValues) {
            this.useCognitoProvidedValues = useCognitoProvidedValues;
            return this;
        }

        public final Document getSettings() {
            return settings;
        }

        public final void setSettings(Document settings) {
            this.settings = settings;
        }

        @Override
        @Transient
        public final Builder settings(Document settings) {
            this.settings = settings;
            return this;
        }

        public final List<AssetType.Builder> getAssets() {
            List<AssetType.Builder> result = AssetListTypeCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssets(Collection<AssetType.BuilderImpl> assets) {
            this.assets = AssetListTypeCopier.copyFromBuilder(assets);
        }

        @Override
        public final Builder assets(Collection<AssetType> assets) {
            this.assets = AssetListTypeCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(AssetType... assets) {
            assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<AssetType.Builder>... assets) {
            assets(Stream.of(assets).map(c -> AssetType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateManagedLoginBrandingRequest build() {
            return new UpdateManagedLoginBrandingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
