/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssetListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedLoginBrandingType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedLoginBrandingType> {
    private static final SdkField<String> MANAGED_LOGIN_BRANDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedLoginBrandingId").getter(ManagedLoginBrandingType.getter(ManagedLoginBrandingType::managedLoginBrandingId)).setter(ManagedLoginBrandingType.setter(Builder::managedLoginBrandingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoginBrandingId").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(ManagedLoginBrandingType.getter(ManagedLoginBrandingType::userPoolId)).setter(ManagedLoginBrandingType.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<Boolean> USE_COGNITO_PROVIDED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseCognitoProvidedValues").getter(ManagedLoginBrandingType.getter(ManagedLoginBrandingType::useCognitoProvidedValues)).setter(ManagedLoginBrandingType.setter(Builder::useCognitoProvidedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCognitoProvidedValues").build()}).build();
    private static final SdkField<Document> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("Settings").getter(ManagedLoginBrandingType.getter(ManagedLoginBrandingType::settings)).setter(ManagedLoginBrandingType.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<List<AssetType>> ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Assets").getter(ManagedLoginBrandingType.getter(ManagedLoginBrandingType::assets)).setter(ManagedLoginBrandingType.setter(Builder::assets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(ManagedLoginBrandingType.getter(ManagedLoginBrandingType::creationDate)).setter(ManagedLoginBrandingType.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(ManagedLoginBrandingType.getter(ManagedLoginBrandingType::lastModifiedDate)).setter(ManagedLoginBrandingType.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_LOGIN_BRANDING_ID_FIELD, USER_POOL_ID_FIELD, USE_COGNITO_PROVIDED_VALUES_FIELD, SETTINGS_FIELD, ASSETS_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedLoginBrandingType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String managedLoginBrandingId;
    private final String userPoolId;
    private final Boolean useCognitoProvidedValues;
    private final Document settings;
    private final List<AssetType> assets;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private ManagedLoginBrandingType(BuilderImpl builder) {
        this.managedLoginBrandingId = builder.managedLoginBrandingId;
        this.userPoolId = builder.userPoolId;
        this.useCognitoProvidedValues = builder.useCognitoProvidedValues;
        this.settings = builder.settings;
        this.assets = builder.assets;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String managedLoginBrandingId() {
        return this.managedLoginBrandingId;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final Boolean useCognitoProvidedValues() {
        return this.useCognitoProvidedValues;
    }

    public final Document settings() {
        return this.settings;
    }

    public final boolean hasAssets() {
        return this.assets != null && !(this.assets instanceof SdkAutoConstructList);
    }

    public final List<AssetType> assets() {
        return this.assets;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.managedLoginBrandingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCognitoProvidedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssets() ? this.assets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedLoginBrandingType)) {
            return false;
        }
        ManagedLoginBrandingType other = (ManagedLoginBrandingType)obj;
        return Objects.equals(this.managedLoginBrandingId(), other.managedLoginBrandingId()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.useCognitoProvidedValues(), other.useCognitoProvidedValues()) && Objects.equals(this.settings(), other.settings()) && this.hasAssets() == other.hasAssets() && Objects.equals(this.assets(), other.assets()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedLoginBrandingType").add("ManagedLoginBrandingId", (Object)this.managedLoginBrandingId()).add("UserPoolId", (Object)this.userPoolId()).add("UseCognitoProvidedValues", (Object)this.useCognitoProvidedValues()).add("Settings", (Object)this.settings()).add("Assets", this.hasAssets() ? this.assets() : null).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedLoginBrandingId": {
                return Optional.ofNullable(clazz.cast(this.managedLoginBrandingId()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "UseCognitoProvidedValues": {
                return Optional.ofNullable(clazz.cast(this.useCognitoProvidedValues()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "Assets": {
                return Optional.ofNullable(clazz.cast(this.assets()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManagedLoginBrandingId", MANAGED_LOGIN_BRANDING_ID_FIELD);
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("UseCognitoProvidedValues", USE_COGNITO_PROVIDED_VALUES_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("Assets", ASSETS_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedLoginBrandingType, T> g) {
        return obj -> g.apply((ManagedLoginBrandingType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String managedLoginBrandingId;
        private String userPoolId;
        private Boolean useCognitoProvidedValues;
        private Document settings;
        private List<AssetType> assets = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedLoginBrandingType model) {
            this.managedLoginBrandingId(model.managedLoginBrandingId);
            this.userPoolId(model.userPoolId);
            this.useCognitoProvidedValues(model.useCognitoProvidedValues);
            this.settings(model.settings);
            this.assets(model.assets);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getManagedLoginBrandingId() {
            return this.managedLoginBrandingId;
        }

        public final void setManagedLoginBrandingId(String managedLoginBrandingId) {
            this.managedLoginBrandingId = managedLoginBrandingId;
        }

        @Override
        public final Builder managedLoginBrandingId(String managedLoginBrandingId) {
            this.managedLoginBrandingId = managedLoginBrandingId;
            return this;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final Boolean getUseCognitoProvidedValues() {
            return this.useCognitoProvidedValues;
        }

        public final void setUseCognitoProvidedValues(Boolean useCognitoProvidedValues) {
            this.useCognitoProvidedValues = useCognitoProvidedValues;
        }

        @Override
        public final Builder useCognitoProvidedValues(Boolean useCognitoProvidedValues) {
            this.useCognitoProvidedValues = useCognitoProvidedValues;
            return this;
        }

        public final Document getSettings() {
            return this.settings;
        }

        public final void setSettings(Document settings) {
            this.settings = settings;
        }

        @Override
        @Transient
        public final Builder settings(Document settings) {
            this.settings = settings;
            return this;
        }

        public final List<AssetType.Builder> getAssets() {
            List<AssetType.Builder> result = AssetListTypeCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssets(Collection<AssetType.BuilderImpl> assets) {
            this.assets = AssetListTypeCopier.copyFromBuilder(assets);
        }

        @Override
        public final Builder assets(Collection<AssetType> assets) {
            this.assets = AssetListTypeCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(AssetType ... assets) {
            this.assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<AssetType.Builder> ... assets) {
            this.assets(Stream.of(assets).map(c -> (AssetType)((AssetType.Builder)AssetType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public ManagedLoginBrandingType build() {
            return new ManagedLoginBrandingType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedLoginBrandingType> {
        public Builder managedLoginBrandingId(String var1);

        public Builder userPoolId(String var1);

        public Builder useCognitoProvidedValues(Boolean var1);

        public Builder settings(Document var1);

        public Builder assets(Collection<AssetType> var1);

        public Builder assets(AssetType ... var1);

        public Builder assets(Consumer<AssetType.Builder> ... var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

