/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the request to list users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsersResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ListUsersResponse.Builder, ListUsersResponse> {
    private static final SdkField<List<UserType>> USERS_FIELD = SdkField
            .<List<UserType>> builder(MarshallingType.LIST)
            .memberName("Users")
            .getter(getter(ListUsersResponse::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserType> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaginationToken").getter(getter(ListUsersResponse::paginationToken))
            .setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERS_FIELD,
            PAGINATION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UserType> users;

    private final String paginationToken;

    private ListUsersResponse(BuilderImpl builder) {
        super(builder);
        this.users = builder.users;
        this.paginationToken = builder.paginationToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the user pool users, and their attributes, that match your query.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each unique user
     * ID from your third-party identity providers (IdPs). When you link users with the <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
     * >AdminLinkProviderForUser</a> API operation, the output of <code>ListUsers</code> displays both the IdP user and
     * the native user that you linked. You can identify IdP users in the <code>Users</code> object of this API response
     * by the IdP prefix that Amazon Cognito appends to <code>Username</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return A list of the user pool users, and their attributes, that match your query.</p> <note>
     *         <p>
     *         Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each
     *         unique user ID from your third-party identity providers (IdPs). When you link users with the <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
     *         >AdminLinkProviderForUser</a> API operation, the output of <code>ListUsers</code> displays both the IdP
     *         user and the native user that you linked. You can identify IdP users in the <code>Users</code> object of
     *         this API response by the IdP prefix that Amazon Cognito appends to <code>Username</code>.
     *         </p>
     */
    public final List<UserType> users() {
        return users;
    }

    /**
     * <p>
     * The identifier that Amazon Cognito returned with the previous request to this operation. When you include a
     * pagination token in your request, Amazon Cognito returns the next set of items in the list. By use of this token,
     * you can paginate through the full list of items.
     * </p>
     * 
     * @return The identifier that Amazon Cognito returned with the previous request to this operation. When you include
     *         a pagination token in your request, Amazon Cognito returns the next set of items in the list. By use of
     *         this token, you can paginate through the full list of items.
     */
    public final String paginationToken() {
        return paginationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResponse)) {
            return false;
        }
        ListUsersResponse other = (ListUsersResponse) obj;
        return hasUsers() == other.hasUsers() && Objects.equals(users(), other.users())
                && Objects.equals(paginationToken(), other.paginationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUsersResponse").add("Users", hasUsers() ? users() : null)
                .add("PaginationToken", paginationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Users", USERS_FIELD);
        map.put("PaginationToken", PAGINATION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsersResponse, T> g) {
        return obj -> g.apply((ListUsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUsersResponse> {
        /**
         * <p>
         * A list of the user pool users, and their attributes, that match your query.
         * </p>
         * <note>
         * <p>
         * Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each unique
         * user ID from your third-party identity providers (IdPs). When you link users with the <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
         * >AdminLinkProviderForUser</a> API operation, the output of <code>ListUsers</code> displays both the IdP user
         * and the native user that you linked. You can identify IdP users in the <code>Users</code> object of this API
         * response by the IdP prefix that Amazon Cognito appends to <code>Username</code>.
         * </p>
         * </note>
         * 
         * @param users
         *        A list of the user pool users, and their attributes, that match your query.</p> <note>
         *        <p>
         *        Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each
         *        unique user ID from your third-party identity providers (IdPs). When you link users with the <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
         *        >AdminLinkProviderForUser</a> API operation, the output of <code>ListUsers</code> displays both the
         *        IdP user and the native user that you linked. You can identify IdP users in the <code>Users</code>
         *        object of this API response by the IdP prefix that Amazon Cognito appends to <code>Username</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<UserType> users);

        /**
         * <p>
         * A list of the user pool users, and their attributes, that match your query.
         * </p>
         * <note>
         * <p>
         * Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each unique
         * user ID from your third-party identity providers (IdPs). When you link users with the <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
         * >AdminLinkProviderForUser</a> API operation, the output of <code>ListUsers</code> displays both the IdP user
         * and the native user that you linked. You can identify IdP users in the <code>Users</code> object of this API
         * response by the IdP prefix that Amazon Cognito appends to <code>Username</code>.
         * </p>
         * </note>
         * 
         * @param users
         *        A list of the user pool users, and their attributes, that match your query.</p> <note>
         *        <p>
         *        Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each
         *        unique user ID from your third-party identity providers (IdPs). When you link users with the <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
         *        >AdminLinkProviderForUser</a> API operation, the output of <code>ListUsers</code> displays both the
         *        IdP user and the native user that you linked. You can identify IdP users in the <code>Users</code>
         *        object of this API response by the IdP prefix that Amazon Cognito appends to <code>Username</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(UserType... users);

        /**
         * <p>
         * A list of the user pool users, and their attributes, that match your query.
         * </p>
         * <note>
         * <p>
         * Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each unique
         * user ID from your third-party identity providers (IdPs). When you link users with the <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
         * >AdminLinkProviderForUser</a> API operation, the output of <code>ListUsers</code> displays both the IdP user
         * and the native user that you linked. You can identify IdP users in the <code>Users</code> object of this API
         * response by the IdP prefix that Amazon Cognito appends to <code>Username</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UserType.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UserType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UserType.Builder#build()} is called
         * immediately and its result is passed to {@link #users(List<UserType>)}.
         * 
         * @param users
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UserType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<UserType>)
         */
        Builder users(Consumer<UserType.Builder>... users);

        /**
         * <p>
         * The identifier that Amazon Cognito returned with the previous request to this operation. When you include a
         * pagination token in your request, Amazon Cognito returns the next set of items in the list. By use of this
         * token, you can paginate through the full list of items.
         * </p>
         * 
         * @param paginationToken
         *        The identifier that Amazon Cognito returned with the previous request to this operation. When you
         *        include a pagination token in your request, Amazon Cognito returns the next set of items in the list.
         *        By use of this token, you can paginate through the full list of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<UserType> users = DefaultSdkAutoConstructList.getInstance();

        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersResponse model) {
            super(model);
            users(model.users);
            paginationToken(model.paginationToken);
        }

        public final List<UserType.Builder> getUsers() {
            List<UserType.Builder> result = UsersListTypeCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<UserType.BuilderImpl> users) {
            this.users = UsersListTypeCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<UserType> users) {
            this.users = UsersListTypeCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserType... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserType.Builder>... users) {
            users(Stream.of(users).map(c -> UserType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        @Override
        public ListUsersResponse build() {
            return new ListUsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
