/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to create a user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserPoolRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<CreateUserPoolRequest.Builder, CreateUserPoolRequest> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolName").getter(getter(CreateUserPoolRequest::poolName)).setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final SdkField<UserPoolPolicyType> POLICIES_FIELD = SdkField
            .<UserPoolPolicyType> builder(MarshallingType.SDK_POJO).memberName("Policies")
            .getter(getter(CreateUserPoolRequest::policies)).setter(setter(Builder::policies))
            .constructor(UserPoolPolicyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()).build();

    private static final SdkField<String> DELETION_PROTECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionProtection").getter(getter(CreateUserPoolRequest::deletionProtectionAsString))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<LambdaConfigType> LAMBDA_CONFIG_FIELD = SdkField
            .<LambdaConfigType> builder(MarshallingType.SDK_POJO).memberName("LambdaConfig")
            .getter(getter(CreateUserPoolRequest::lambdaConfig)).setter(setter(Builder::lambdaConfig))
            .constructor(LambdaConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaConfig").build()).build();

    private static final SdkField<List<String>> AUTO_VERIFIED_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AutoVerifiedAttributes")
            .getter(getter(CreateUserPoolRequest::autoVerifiedAttributesAsStrings))
            .setter(setter(Builder::autoVerifiedAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoVerifiedAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALIAS_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AliasAttributes")
            .getter(getter(CreateUserPoolRequest::aliasAttributesAsStrings))
            .setter(setter(Builder::aliasAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USERNAME_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UsernameAttributes")
            .getter(getter(CreateUserPoolRequest::usernameAttributesAsStrings))
            .setter(setter(Builder::usernameAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SMS_VERIFICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SmsVerificationMessage").getter(getter(CreateUserPoolRequest::smsVerificationMessage))
            .setter(setter(Builder::smsVerificationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsVerificationMessage").build())
            .build();

    private static final SdkField<String> EMAIL_VERIFICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailVerificationMessage").getter(getter(CreateUserPoolRequest::emailVerificationMessage))
            .setter(setter(Builder::emailVerificationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationMessage").build())
            .build();

    private static final SdkField<String> EMAIL_VERIFICATION_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailVerificationSubject").getter(getter(CreateUserPoolRequest::emailVerificationSubject))
            .setter(setter(Builder::emailVerificationSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationSubject").build())
            .build();

    private static final SdkField<VerificationMessageTemplateType> VERIFICATION_MESSAGE_TEMPLATE_FIELD = SdkField
            .<VerificationMessageTemplateType> builder(MarshallingType.SDK_POJO)
            .memberName("VerificationMessageTemplate")
            .getter(getter(CreateUserPoolRequest::verificationMessageTemplate))
            .setter(setter(Builder::verificationMessageTemplate))
            .constructor(VerificationMessageTemplateType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationMessageTemplate")
                    .build()).build();

    private static final SdkField<String> SMS_AUTHENTICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SmsAuthenticationMessage").getter(getter(CreateUserPoolRequest::smsAuthenticationMessage))
            .setter(setter(Builder::smsAuthenticationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsAuthenticationMessage").build())
            .build();

    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MfaConfiguration").getter(getter(CreateUserPoolRequest::mfaConfigurationAsString))
            .setter(setter(Builder::mfaConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()).build();

    private static final SdkField<UserAttributeUpdateSettingsType> USER_ATTRIBUTE_UPDATE_SETTINGS_FIELD = SdkField
            .<UserAttributeUpdateSettingsType> builder(MarshallingType.SDK_POJO)
            .memberName("UserAttributeUpdateSettings")
            .getter(getter(CreateUserPoolRequest::userAttributeUpdateSettings))
            .setter(setter(Builder::userAttributeUpdateSettings))
            .constructor(UserAttributeUpdateSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributeUpdateSettings")
                    .build()).build();

    private static final SdkField<DeviceConfigurationType> DEVICE_CONFIGURATION_FIELD = SdkField
            .<DeviceConfigurationType> builder(MarshallingType.SDK_POJO).memberName("DeviceConfiguration")
            .getter(getter(CreateUserPoolRequest::deviceConfiguration)).setter(setter(Builder::deviceConfiguration))
            .constructor(DeviceConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConfiguration").build())
            .build();

    private static final SdkField<EmailConfigurationType> EMAIL_CONFIGURATION_FIELD = SdkField
            .<EmailConfigurationType> builder(MarshallingType.SDK_POJO).memberName("EmailConfiguration")
            .getter(getter(CreateUserPoolRequest::emailConfiguration)).setter(setter(Builder::emailConfiguration))
            .constructor(EmailConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailConfiguration").build())
            .build();

    private static final SdkField<SmsConfigurationType> SMS_CONFIGURATION_FIELD = SdkField
            .<SmsConfigurationType> builder(MarshallingType.SDK_POJO).memberName("SmsConfiguration")
            .getter(getter(CreateUserPoolRequest::smsConfiguration)).setter(setter(Builder::smsConfiguration))
            .constructor(SmsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfiguration").build()).build();

    private static final SdkField<Map<String, String>> USER_POOL_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("UserPoolTags")
            .getter(getter(CreateUserPoolRequest::userPoolTags))
            .setter(setter(Builder::userPoolTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AdminCreateUserConfigType> ADMIN_CREATE_USER_CONFIG_FIELD = SdkField
            .<AdminCreateUserConfigType> builder(MarshallingType.SDK_POJO).memberName("AdminCreateUserConfig")
            .getter(getter(CreateUserPoolRequest::adminCreateUserConfig)).setter(setter(Builder::adminCreateUserConfig))
            .constructor(AdminCreateUserConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminCreateUserConfig").build())
            .build();

    private static final SdkField<List<SchemaAttributeType>> SCHEMA_FIELD = SdkField
            .<List<SchemaAttributeType>> builder(MarshallingType.LIST)
            .memberName("Schema")
            .getter(getter(CreateUserPoolRequest::schema))
            .setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaAttributeType> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaAttributeType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<UserPoolAddOnsType> USER_POOL_ADD_ONS_FIELD = SdkField
            .<UserPoolAddOnsType> builder(MarshallingType.SDK_POJO).memberName("UserPoolAddOns")
            .getter(getter(CreateUserPoolRequest::userPoolAddOns)).setter(setter(Builder::userPoolAddOns))
            .constructor(UserPoolAddOnsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolAddOns").build()).build();

    private static final SdkField<UsernameConfigurationType> USERNAME_CONFIGURATION_FIELD = SdkField
            .<UsernameConfigurationType> builder(MarshallingType.SDK_POJO).memberName("UsernameConfiguration")
            .getter(getter(CreateUserPoolRequest::usernameConfiguration)).setter(setter(Builder::usernameConfiguration))
            .constructor(UsernameConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameConfiguration").build())
            .build();

    private static final SdkField<AccountRecoverySettingType> ACCOUNT_RECOVERY_SETTING_FIELD = SdkField
            .<AccountRecoverySettingType> builder(MarshallingType.SDK_POJO).memberName("AccountRecoverySetting")
            .getter(getter(CreateUserPoolRequest::accountRecoverySetting)).setter(setter(Builder::accountRecoverySetting))
            .constructor(AccountRecoverySettingType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountRecoverySetting").build())
            .build();

    private static final SdkField<String> USER_POOL_TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolTier").getter(getter(CreateUserPoolRequest::userPoolTierAsString))
            .setter(setter(Builder::userPoolTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolTier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD,
            POLICIES_FIELD, DELETION_PROTECTION_FIELD, LAMBDA_CONFIG_FIELD, AUTO_VERIFIED_ATTRIBUTES_FIELD,
            ALIAS_ATTRIBUTES_FIELD, USERNAME_ATTRIBUTES_FIELD, SMS_VERIFICATION_MESSAGE_FIELD, EMAIL_VERIFICATION_MESSAGE_FIELD,
            EMAIL_VERIFICATION_SUBJECT_FIELD, VERIFICATION_MESSAGE_TEMPLATE_FIELD, SMS_AUTHENTICATION_MESSAGE_FIELD,
            MFA_CONFIGURATION_FIELD, USER_ATTRIBUTE_UPDATE_SETTINGS_FIELD, DEVICE_CONFIGURATION_FIELD, EMAIL_CONFIGURATION_FIELD,
            SMS_CONFIGURATION_FIELD, USER_POOL_TAGS_FIELD, ADMIN_CREATE_USER_CONFIG_FIELD, SCHEMA_FIELD, USER_POOL_ADD_ONS_FIELD,
            USERNAME_CONFIGURATION_FIELD, ACCOUNT_RECOVERY_SETTING_FIELD, USER_POOL_TIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String poolName;

    private final UserPoolPolicyType policies;

    private final String deletionProtection;

    private final LambdaConfigType lambdaConfig;

    private final List<String> autoVerifiedAttributes;

    private final List<String> aliasAttributes;

    private final List<String> usernameAttributes;

    private final String smsVerificationMessage;

    private final String emailVerificationMessage;

    private final String emailVerificationSubject;

    private final VerificationMessageTemplateType verificationMessageTemplate;

    private final String smsAuthenticationMessage;

    private final String mfaConfiguration;

    private final UserAttributeUpdateSettingsType userAttributeUpdateSettings;

    private final DeviceConfigurationType deviceConfiguration;

    private final EmailConfigurationType emailConfiguration;

    private final SmsConfigurationType smsConfiguration;

    private final Map<String, String> userPoolTags;

    private final AdminCreateUserConfigType adminCreateUserConfig;

    private final List<SchemaAttributeType> schema;

    private final UserPoolAddOnsType userPoolAddOns;

    private final UsernameConfigurationType usernameConfiguration;

    private final AccountRecoverySettingType accountRecoverySetting;

    private final String userPoolTier;

    private CreateUserPoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolName = builder.poolName;
        this.policies = builder.policies;
        this.deletionProtection = builder.deletionProtection;
        this.lambdaConfig = builder.lambdaConfig;
        this.autoVerifiedAttributes = builder.autoVerifiedAttributes;
        this.aliasAttributes = builder.aliasAttributes;
        this.usernameAttributes = builder.usernameAttributes;
        this.smsVerificationMessage = builder.smsVerificationMessage;
        this.emailVerificationMessage = builder.emailVerificationMessage;
        this.emailVerificationSubject = builder.emailVerificationSubject;
        this.verificationMessageTemplate = builder.verificationMessageTemplate;
        this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
        this.mfaConfiguration = builder.mfaConfiguration;
        this.userAttributeUpdateSettings = builder.userAttributeUpdateSettings;
        this.deviceConfiguration = builder.deviceConfiguration;
        this.emailConfiguration = builder.emailConfiguration;
        this.smsConfiguration = builder.smsConfiguration;
        this.userPoolTags = builder.userPoolTags;
        this.adminCreateUserConfig = builder.adminCreateUserConfig;
        this.schema = builder.schema;
        this.userPoolAddOns = builder.userPoolAddOns;
        this.usernameConfiguration = builder.usernameConfiguration;
        this.accountRecoverySetting = builder.accountRecoverySetting;
        this.userPoolTier = builder.userPoolTier;
    }

    /**
     * <p>
     * A friendlhy name for your user pool.
     * </p>
     * 
     * @return A friendlhy name for your user pool.
     */
    public final String poolName() {
        return poolName;
    }

    /**
     * <p>
     * The password policy and sign-in policy in the user pool. The password policy sets options like password
     * complexity requirements and password history. The sign-in policy sets the options available to applications in <a
     * href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice"
     * >choice-based authentication</a>.
     * </p>
     * 
     * @return The password policy and sign-in policy in the user pool. The password policy sets options like password
     *         complexity requirements and password history. The sign-in policy sets the options available to
     *         applications in <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice"
     *         >choice-based authentication</a>.
     */
    public final UserPoolPolicyType policies() {
        return policies;
    }

    /**
     * <p>
     * When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before you can
     * delete a user pool that you have protected against deletion, you must deactivate this feature.
     * </p>
     * <p>
     * When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito returns
     * an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new
     * <code>DeleteUserPool</code> request after you deactivate deletion protection in an <code>UpdateUserPool</code>
     * API request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletionProtection} will return {@link DeletionProtectionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deletionProtectionAsString}.
     * </p>
     * 
     * @return When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before you
     *         can delete a user pool that you have protected against deletion, you must deactivate this feature.</p>
     *         <p>
     *         When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito
     *         returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new
     *         <code>DeleteUserPool</code> request after you deactivate deletion protection in an
     *         <code>UpdateUserPool</code> API request.
     * @see DeletionProtectionType
     */
    public final DeletionProtectionType deletionProtection() {
        return DeletionProtectionType.fromValue(deletionProtection);
    }

    /**
     * <p>
     * When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before you can
     * delete a user pool that you have protected against deletion, you must deactivate this feature.
     * </p>
     * <p>
     * When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito returns
     * an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new
     * <code>DeleteUserPool</code> request after you deactivate deletion protection in an <code>UpdateUserPool</code>
     * API request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletionProtection} will return {@link DeletionProtectionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deletionProtectionAsString}.
     * </p>
     * 
     * @return When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before you
     *         can delete a user pool that you have protected against deletion, you must deactivate this feature.</p>
     *         <p>
     *         When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito
     *         returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new
     *         <code>DeleteUserPool</code> request after you deactivate deletion protection in an
     *         <code>UpdateUserPool</code> API request.
     * @see DeletionProtectionType
     */
    public final String deletionProtectionAsString() {
        return deletionProtection;
    }

    /**
     * <p>
     * A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of
     * authentication operations. Triggers can modify the outcome of the operations that invoked them.
     * </p>
     * 
     * @return A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of
     *         authentication operations. Triggers can modify the outcome of the operations that invoked them.
     */
    public final LambdaConfigType lambdaConfig() {
        return lambdaConfig;
    }

    /**
     * <p>
     * The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
     * <b>phone_number</b>. For more information see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
     * >Verifying contact information at sign-up</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoVerifiedAttributes} method.
     * </p>
     * 
     * @return The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
     *         <b>phone_number</b>. For more information see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
     *         >Verifying contact information at sign-up</a>.
     */
    public final List<VerifiedAttributeType> autoVerifiedAttributes() {
        return VerifiedAttributesListTypeCopier.copyStringToEnum(autoVerifiedAttributes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoVerifiedAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoVerifiedAttributes() {
        return autoVerifiedAttributes != null && !(autoVerifiedAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
     * <b>phone_number</b>. For more information see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
     * >Verifying contact information at sign-up</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoVerifiedAttributes} method.
     * </p>
     * 
     * @return The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
     *         <b>phone_number</b>. For more information see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
     *         >Verifying contact information at sign-up</a>.
     */
    public final List<String> autoVerifiedAttributesAsStrings() {
        return autoVerifiedAttributes;
    }

    /**
     * <p>
     * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
     * <b>preferred_username</b>. For more information about alias attributes, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
     * >Customizing sign-in attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAliasAttributes} method.
     * </p>
     * 
     * @return Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>,
     *         or <b>preferred_username</b>. For more information about alias attributes, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
     *         >Customizing sign-in attributes</a>.
     */
    public final List<AliasAttributeType> aliasAttributes() {
        return AliasAttributesListTypeCopier.copyStringToEnum(aliasAttributes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AliasAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAliasAttributes() {
        return aliasAttributes != null && !(aliasAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
     * <b>preferred_username</b>. For more information about alias attributes, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
     * >Customizing sign-in attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAliasAttributes} method.
     * </p>
     * 
     * @return Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>,
     *         or <b>preferred_username</b>. For more information about alias attributes, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
     *         >Customizing sign-in attributes</a>.
     */
    public final List<String> aliasAttributesAsStrings() {
        return aliasAttributes;
    }

    /**
     * <p>
     * Specifies whether a user can use an email address or phone number as a username when they sign up. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
     * >Customizing sign-in attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsernameAttributes} method.
     * </p>
     * 
     * @return Specifies whether a user can use an email address or phone number as a username when they sign up. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
     *         >Customizing sign-in attributes</a>.
     */
    public final List<UsernameAttributeType> usernameAttributes() {
        return UsernameAttributesListTypeCopier.copyStringToEnum(usernameAttributes);
    }

    /**
     * For responses, this returns true if the service returned a value for the UsernameAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUsernameAttributes() {
        return usernameAttributes != null && !(usernameAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether a user can use an email address or phone number as a username when they sign up. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
     * >Customizing sign-in attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsernameAttributes} method.
     * </p>
     * 
     * @return Specifies whether a user can use an email address or phone number as a username when they sign up. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
     *         >Customizing sign-in attributes</a>.
     */
    public final List<String> usernameAttributesAsStrings() {
        return usernameAttributes;
    }

    /**
     * <p>
     * This parameter is no longer used. See <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
     * >VerificationMessageTemplateType</a>.
     * </p>
     * 
     * @return This parameter is no longer used. See <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
     *         >VerificationMessageTemplateType</a>.
     */
    public final String smsVerificationMessage() {
        return smsVerificationMessage;
    }

    /**
     * <p>
     * This parameter is no longer used. See <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
     * >VerificationMessageTemplateType</a>.
     * </p>
     * 
     * @return This parameter is no longer used. See <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
     *         >VerificationMessageTemplateType</a>.
     */
    public final String emailVerificationMessage() {
        return emailVerificationMessage;
    }

    /**
     * <p>
     * This parameter is no longer used. See <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
     * >VerificationMessageTemplateType</a>.
     * </p>
     * 
     * @return This parameter is no longer used. See <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
     *         >VerificationMessageTemplateType</a>.
     */
    public final String emailVerificationSubject() {
        return emailVerificationSubject;
    }

    /**
     * <p>
     * The template for the verification message that your user pool delivers to users who set an email address or phone
     * number attribute.
     * </p>
     * <p>
     * Set the email message type that corresponds to your <code>DefaultEmailOption</code> selection. For
     * <code>CONFIRM_WITH_LINK</code>, specify an <code>EmailMessageByLink</code> and leave <code>EmailMessage</code>
     * blank. For <code>CONFIRM_WITH_CODE</code>, specify an <code>EmailMessage</code> and leave
     * <code>EmailMessageByLink</code> blank. When you supply both parameters with either choice, Amazon Cognito returns
     * an error.
     * </p>
     * 
     * @return The template for the verification message that your user pool delivers to users who set an email address
     *         or phone number attribute.</p>
     *         <p>
     *         Set the email message type that corresponds to your <code>DefaultEmailOption</code> selection. For
     *         <code>CONFIRM_WITH_LINK</code>, specify an <code>EmailMessageByLink</code> and leave
     *         <code>EmailMessage</code> blank. For <code>CONFIRM_WITH_CODE</code>, specify an <code>EmailMessage</code>
     *         and leave <code>EmailMessageByLink</code> blank. When you supply both parameters with either choice,
     *         Amazon Cognito returns an error.
     */
    public final VerificationMessageTemplateType verificationMessageTemplate() {
        return verificationMessageTemplate;
    }

    /**
     * <p>
     * A string representing the SMS authentication message.
     * </p>
     * 
     * @return A string representing the SMS authentication message.
     */
    public final String smsAuthenticationMessage() {
        return smsAuthenticationMessage;
    }

    /**
     * <p>
     * Sets multi-factor authentication (MFA) to be on, off, or optional. When <code>ON</code>, all users must set up
     * MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side determination
     * of whether a user wants to register an MFA device. For user pools with adaptive authentication with threat
     * protection, choose <code>OPTIONAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Sets multi-factor authentication (MFA) to be on, off, or optional. When <code>ON</code>, all users must
     *         set up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side
     *         determination of whether a user wants to register an MFA device. For user pools with adaptive
     *         authentication with threat protection, choose <code>OPTIONAL</code>.
     * @see UserPoolMfaType
     */
    public final UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(mfaConfiguration);
    }

    /**
     * <p>
     * Sets multi-factor authentication (MFA) to be on, off, or optional. When <code>ON</code>, all users must set up
     * MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side determination
     * of whether a user wants to register an MFA device. For user pools with adaptive authentication with threat
     * protection, choose <code>OPTIONAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Sets multi-factor authentication (MFA) to be on, off, or optional. When <code>ON</code>, all users must
     *         set up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side
     *         determination of whether a user wants to register an MFA device. For user pools with adaptive
     *         authentication with threat protection, choose <code>OPTIONAL</code>.
     * @see UserPoolMfaType
     */
    public final String mfaConfigurationAsString() {
        return mfaConfiguration;
    }

    /**
     * <p>
     * The settings for updates to user attributes. These settings include the property
     * <code>AttributesRequireVerificationBeforeUpdate</code>, a user-pool setting that tells Amazon Cognito how to
     * handle changes to the value of your users' email address and phone number attributes. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates"
     * > Verifying updates to email addresses and phone numbers</a>.
     * </p>
     * 
     * @return The settings for updates to user attributes. These settings include the property
     *         <code>AttributesRequireVerificationBeforeUpdate</code>, a user-pool setting that tells Amazon Cognito how
     *         to handle changes to the value of your users' email address and phone number attributes. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates"
     *         > Verifying updates to email addresses and phone numbers</a>.
     */
    public final UserAttributeUpdateSettingsType userAttributeUpdateSettings() {
        return userAttributeUpdateSettings;
    }

    /**
     * <p>
     * The device-remembering configuration for a user pool. Device remembering or device tracking is a
     * "Remember me on this device" option for user pools that perform authentication with the device key of a trusted
     * device in the back end, instead of a user-provided MFA code. For more information about device authentication,
     * see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>. A null value indicates that you have deactivated device
     * remembering in your user pool.
     * </p>
     * <note>
     * <p>
     * When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito
     * device-remembering feature. For more infor
     * </p>
     * </note>
     * 
     * @return The device-remembering configuration for a user pool. Device remembering or device tracking is a
     *         "Remember me on this device" option for user pools that perform authentication with the device key of a
     *         trusted device in the back end, instead of a user-provided MFA code. For more information about device
     *         authentication, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     *         >Working with user devices in your user pool</a>. A null value indicates that you have deactivated device
     *         remembering in your user pool.</p> <note>
     *         <p>
     *         When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito
     *         device-remembering feature. For more infor
     *         </p>
     */
    public final DeviceConfigurationType deviceConfiguration() {
        return deviceConfiguration;
    }

    /**
     * <p>
     * The email configuration of your user pool. The email configuration type sets your preferred sending method,
     * Amazon Web Services Region, and sender for messages from your user pool.
     * </p>
     * 
     * @return The email configuration of your user pool. The email configuration type sets your preferred sending
     *         method, Amazon Web Services Region, and sender for messages from your user pool.
     */
    public final EmailConfigurationType emailConfiguration() {
        return emailConfiguration;
    }

    /**
     * <p>
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from
     * your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS
     * in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access
     * Management (IAM) role in your Amazon Web Services account. For more information see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message
     * settings</a>.
     * </p>
     * 
     * @return The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS
     *         message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS
     *         messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool
     *         uses an Identity and Access Management (IAM) role in your Amazon Web Services account. For more
     *         information see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message
     *         settings</a>.
     */
    public final SmsConfigurationType smsConfiguration() {
        return smsConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserPoolTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserPoolTags() {
        return userPoolTags != null && !(userPoolTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserPoolTags} method.
     * </p>
     * 
     * @return The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and
     *         manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     */
    public final Map<String, String> userPoolTags() {
        return userPoolTags;
    }

    /**
     * <p>
     * The configuration for <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html"
     * >AdminCreateUser</a> requests. Includes the template for the invitation message for new users, the duration of
     * temporary passwords, and permitting self-service sign-up.
     * </p>
     * 
     * @return The configuration for <a
     *         href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html"
     *         >AdminCreateUser</a> requests. Includes the template for the invitation message for new users, the
     *         duration of temporary passwords, and permitting self-service sign-up.
     */
    public final AdminCreateUserConfigType adminCreateUserConfig() {
        return adminCreateUserConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Schema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchema() {
        return schema != null && !(schema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of attributes for the new user pool. You can add custom attributes and modify the properties of default
     * attributes. The specifications in this parameter set the required attributes in your user pool. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html">Working with
     * user attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchema} method.
     * </p>
     * 
     * @return An array of attributes for the new user pool. You can add custom attributes and modify the properties of
     *         default attributes. The specifications in this parameter set the required attributes in your user pool.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html"
     *         >Working with user attributes</a>.
     */
    public final List<SchemaAttributeType> schema() {
        return schema;
    }

    /**
     * <p>
     * User pool add-ons. Contains settings for activation of advanced security features. To log user security
     * information but take no action, set to <code>AUDIT</code>. To configure automatic security responses to risky
     * traffic to your user pool, set to <code>ENFORCED</code>.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
     * >Adding advanced security to a user pool</a>.
     * </p>
     * 
     * @return User pool add-ons. Contains settings for activation of advanced security features. To log user security
     *         information but take no action, set to <code>AUDIT</code>. To configure automatic security responses to
     *         risky traffic to your user pool, set to <code>ENFORCED</code>.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
     *         >Adding advanced security to a user pool</a>.
     */
    public final UserPoolAddOnsType userPoolAddOns() {
        return userPoolAddOns;
    }

    /**
     * <p>
     * Sets the case sensitivity option for sign-in usernames. When <code>CaseSensitive</code> is <code>false</code>
     * (case insensitive), users can sign in with any combination of capital and lowercase letters. For example,
     * <code>username</code>, <code>USERNAME</code>, or <code>UserName</code>, or for email,
     * <code>email@example.com</code> or <code>EMaiL@eXamplE.Com</code>. For most use cases, set case sensitivity to
     * <code>false</code> as a best practice. When usernames and email addresses are case insensitive, Amazon Cognito
     * treats any variation in case as the same user, and prevents a case variation from being assigned to the same
     * attribute for a different user.
     * </p>
     * <p>
     * When <code>CaseSensitive</code> is <code>true</code> (case sensitive), Amazon Cognito interprets
     * <code>USERNAME</code> and <code>UserName</code> as distinct users.
     * </p>
     * <p>
     * This configuration is immutable after you set it.
     * </p>
     * 
     * @return Sets the case sensitivity option for sign-in usernames. When <code>CaseSensitive</code> is
     *         <code>false</code> (case insensitive), users can sign in with any combination of capital and lowercase
     *         letters. For example, <code>username</code>, <code>USERNAME</code>, or <code>UserName</code>, or for
     *         email, <code>email@example.com</code> or <code>EMaiL@eXamplE.Com</code>. For most use cases, set case
     *         sensitivity to <code>false</code> as a best practice. When usernames and email addresses are case
     *         insensitive, Amazon Cognito treats any variation in case as the same user, and prevents a case variation
     *         from being assigned to the same attribute for a different user.</p>
     *         <p>
     *         When <code>CaseSensitive</code> is <code>true</code> (case sensitive), Amazon Cognito interprets
     *         <code>USERNAME</code> and <code>UserName</code> as distinct users.
     *         </p>
     *         <p>
     *         This configuration is immutable after you set it.
     */
    public final UsernameConfigurationType usernameConfiguration() {
        return usernameConfiguration;
    }

    /**
     * <p>
     * The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>
     * . You can use this setting to define a preferred method when a user has more than one method available. With this
     * setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor
     * authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to
     * determine the recovery method where SMS is preferred through email.
     * </p>
     * 
     * @return The available verified method a user can use to recover their password when they call
     *         <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more
     *         than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism
     *         if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting,
     *         Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through
     *         email.
     */
    public final AccountRecoverySettingType accountRecoverySetting() {
        return accountRecoverySetting;
    }

    /**
     * <p>
     * The user pool <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">feature
     * plan</a>, or tier. This parameter determines the eligibility of the user pool for features like managed login,
     * access-token customization, and threat protection. Defaults to <code>ESSENTIALS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userPoolTier} will
     * return {@link UserPoolTierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userPoolTierAsString}.
     * </p>
     * 
     * @return The user pool <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html"
     *         >feature plan</a>, or tier. This parameter determines the eligibility of the user pool for features like
     *         managed login, access-token customization, and threat protection. Defaults to <code>ESSENTIALS</code>.
     * @see UserPoolTierType
     */
    public final UserPoolTierType userPoolTier() {
        return UserPoolTierType.fromValue(userPoolTier);
    }

    /**
     * <p>
     * The user pool <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">feature
     * plan</a>, or tier. This parameter determines the eligibility of the user pool for features like managed login,
     * access-token customization, and threat protection. Defaults to <code>ESSENTIALS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userPoolTier} will
     * return {@link UserPoolTierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userPoolTierAsString}.
     * </p>
     * 
     * @return The user pool <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html"
     *         >feature plan</a>, or tier. This parameter determines the eligibility of the user pool for features like
     *         managed login, access-token customization, and threat protection. Defaults to <code>ESSENTIALS</code>.
     * @see UserPoolTierType
     */
    public final String userPoolTierAsString() {
        return userPoolTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoVerifiedAttributes() ? autoVerifiedAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAliasAttributes() ? aliasAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUsernameAttributes() ? usernameAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(smsVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailVerificationSubject());
        hashCode = 31 * hashCode + Objects.hashCode(verificationMessageTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(smsAuthenticationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(mfaConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userAttributeUpdateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(emailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(smsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserPoolTags() ? userPoolTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(adminCreateUserConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSchema() ? schema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userPoolAddOns());
        hashCode = 31 * hashCode + Objects.hashCode(usernameConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(accountRecoverySetting());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolTierAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserPoolRequest)) {
            return false;
        }
        CreateUserPoolRequest other = (CreateUserPoolRequest) obj;
        return Objects.equals(poolName(), other.poolName()) && Objects.equals(policies(), other.policies())
                && Objects.equals(deletionProtectionAsString(), other.deletionProtectionAsString())
                && Objects.equals(lambdaConfig(), other.lambdaConfig())
                && hasAutoVerifiedAttributes() == other.hasAutoVerifiedAttributes()
                && Objects.equals(autoVerifiedAttributesAsStrings(), other.autoVerifiedAttributesAsStrings())
                && hasAliasAttributes() == other.hasAliasAttributes()
                && Objects.equals(aliasAttributesAsStrings(), other.aliasAttributesAsStrings())
                && hasUsernameAttributes() == other.hasUsernameAttributes()
                && Objects.equals(usernameAttributesAsStrings(), other.usernameAttributesAsStrings())
                && Objects.equals(smsVerificationMessage(), other.smsVerificationMessage())
                && Objects.equals(emailVerificationMessage(), other.emailVerificationMessage())
                && Objects.equals(emailVerificationSubject(), other.emailVerificationSubject())
                && Objects.equals(verificationMessageTemplate(), other.verificationMessageTemplate())
                && Objects.equals(smsAuthenticationMessage(), other.smsAuthenticationMessage())
                && Objects.equals(mfaConfigurationAsString(), other.mfaConfigurationAsString())
                && Objects.equals(userAttributeUpdateSettings(), other.userAttributeUpdateSettings())
                && Objects.equals(deviceConfiguration(), other.deviceConfiguration())
                && Objects.equals(emailConfiguration(), other.emailConfiguration())
                && Objects.equals(smsConfiguration(), other.smsConfiguration()) && hasUserPoolTags() == other.hasUserPoolTags()
                && Objects.equals(userPoolTags(), other.userPoolTags())
                && Objects.equals(adminCreateUserConfig(), other.adminCreateUserConfig()) && hasSchema() == other.hasSchema()
                && Objects.equals(schema(), other.schema()) && Objects.equals(userPoolAddOns(), other.userPoolAddOns())
                && Objects.equals(usernameConfiguration(), other.usernameConfiguration())
                && Objects.equals(accountRecoverySetting(), other.accountRecoverySetting())
                && Objects.equals(userPoolTierAsString(), other.userPoolTierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserPoolRequest").add("PoolName", poolName()).add("Policies", policies())
                .add("DeletionProtection", deletionProtectionAsString()).add("LambdaConfig", lambdaConfig())
                .add("AutoVerifiedAttributes", hasAutoVerifiedAttributes() ? autoVerifiedAttributesAsStrings() : null)
                .add("AliasAttributes", hasAliasAttributes() ? aliasAttributesAsStrings() : null)
                .add("UsernameAttributes", hasUsernameAttributes() ? usernameAttributesAsStrings() : null)
                .add("SmsVerificationMessage", smsVerificationMessage())
                .add("EmailVerificationMessage", emailVerificationMessage())
                .add("EmailVerificationSubject", emailVerificationSubject())
                .add("VerificationMessageTemplate", verificationMessageTemplate())
                .add("SmsAuthenticationMessage", smsAuthenticationMessage()).add("MfaConfiguration", mfaConfigurationAsString())
                .add("UserAttributeUpdateSettings", userAttributeUpdateSettings())
                .add("DeviceConfiguration", deviceConfiguration()).add("EmailConfiguration", emailConfiguration())
                .add("SmsConfiguration", smsConfiguration()).add("UserPoolTags", hasUserPoolTags() ? userPoolTags() : null)
                .add("AdminCreateUserConfig", adminCreateUserConfig()).add("Schema", hasSchema() ? schema() : null)
                .add("UserPoolAddOns", userPoolAddOns()).add("UsernameConfiguration", usernameConfiguration())
                .add("AccountRecoverySetting", accountRecoverySetting()).add("UserPoolTier", userPoolTierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtectionAsString()));
        case "LambdaConfig":
            return Optional.ofNullable(clazz.cast(lambdaConfig()));
        case "AutoVerifiedAttributes":
            return Optional.ofNullable(clazz.cast(autoVerifiedAttributesAsStrings()));
        case "AliasAttributes":
            return Optional.ofNullable(clazz.cast(aliasAttributesAsStrings()));
        case "UsernameAttributes":
            return Optional.ofNullable(clazz.cast(usernameAttributesAsStrings()));
        case "SmsVerificationMessage":
            return Optional.ofNullable(clazz.cast(smsVerificationMessage()));
        case "EmailVerificationMessage":
            return Optional.ofNullable(clazz.cast(emailVerificationMessage()));
        case "EmailVerificationSubject":
            return Optional.ofNullable(clazz.cast(emailVerificationSubject()));
        case "VerificationMessageTemplate":
            return Optional.ofNullable(clazz.cast(verificationMessageTemplate()));
        case "SmsAuthenticationMessage":
            return Optional.ofNullable(clazz.cast(smsAuthenticationMessage()));
        case "MfaConfiguration":
            return Optional.ofNullable(clazz.cast(mfaConfigurationAsString()));
        case "UserAttributeUpdateSettings":
            return Optional.ofNullable(clazz.cast(userAttributeUpdateSettings()));
        case "DeviceConfiguration":
            return Optional.ofNullable(clazz.cast(deviceConfiguration()));
        case "EmailConfiguration":
            return Optional.ofNullable(clazz.cast(emailConfiguration()));
        case "SmsConfiguration":
            return Optional.ofNullable(clazz.cast(smsConfiguration()));
        case "UserPoolTags":
            return Optional.ofNullable(clazz.cast(userPoolTags()));
        case "AdminCreateUserConfig":
            return Optional.ofNullable(clazz.cast(adminCreateUserConfig()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "UserPoolAddOns":
            return Optional.ofNullable(clazz.cast(userPoolAddOns()));
        case "UsernameConfiguration":
            return Optional.ofNullable(clazz.cast(usernameConfiguration()));
        case "AccountRecoverySetting":
            return Optional.ofNullable(clazz.cast(accountRecoverySetting()));
        case "UserPoolTier":
            return Optional.ofNullable(clazz.cast(userPoolTierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolName", POOL_NAME_FIELD);
        map.put("Policies", POLICIES_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("LambdaConfig", LAMBDA_CONFIG_FIELD);
        map.put("AutoVerifiedAttributes", AUTO_VERIFIED_ATTRIBUTES_FIELD);
        map.put("AliasAttributes", ALIAS_ATTRIBUTES_FIELD);
        map.put("UsernameAttributes", USERNAME_ATTRIBUTES_FIELD);
        map.put("SmsVerificationMessage", SMS_VERIFICATION_MESSAGE_FIELD);
        map.put("EmailVerificationMessage", EMAIL_VERIFICATION_MESSAGE_FIELD);
        map.put("EmailVerificationSubject", EMAIL_VERIFICATION_SUBJECT_FIELD);
        map.put("VerificationMessageTemplate", VERIFICATION_MESSAGE_TEMPLATE_FIELD);
        map.put("SmsAuthenticationMessage", SMS_AUTHENTICATION_MESSAGE_FIELD);
        map.put("MfaConfiguration", MFA_CONFIGURATION_FIELD);
        map.put("UserAttributeUpdateSettings", USER_ATTRIBUTE_UPDATE_SETTINGS_FIELD);
        map.put("DeviceConfiguration", DEVICE_CONFIGURATION_FIELD);
        map.put("EmailConfiguration", EMAIL_CONFIGURATION_FIELD);
        map.put("SmsConfiguration", SMS_CONFIGURATION_FIELD);
        map.put("UserPoolTags", USER_POOL_TAGS_FIELD);
        map.put("AdminCreateUserConfig", ADMIN_CREATE_USER_CONFIG_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("UserPoolAddOns", USER_POOL_ADD_ONS_FIELD);
        map.put("UsernameConfiguration", USERNAME_CONFIGURATION_FIELD);
        map.put("AccountRecoverySetting", ACCOUNT_RECOVERY_SETTING_FIELD);
        map.put("UserPoolTier", USER_POOL_TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUserPoolRequest, T> g) {
        return obj -> g.apply((CreateUserPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateUserPoolRequest> {
        /**
         * <p>
         * A friendlhy name for your user pool.
         * </p>
         * 
         * @param poolName
         *        A friendlhy name for your user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);

        /**
         * <p>
         * The password policy and sign-in policy in the user pool. The password policy sets options like password
         * complexity requirements and password history. The sign-in policy sets the options available to applications
         * in <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice"
         * >choice-based authentication</a>.
         * </p>
         * 
         * @param policies
         *        The password policy and sign-in policy in the user pool. The password policy sets options like
         *        password complexity requirements and password history. The sign-in policy sets the options available
         *        to applications in <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice"
         *        >choice-based authentication</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(UserPoolPolicyType policies);

        /**
         * <p>
         * The password policy and sign-in policy in the user pool. The password policy sets options like password
         * complexity requirements and password history. The sign-in policy sets the options available to applications
         * in <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice"
         * >choice-based authentication</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserPoolPolicyType.Builder} avoiding the
         * need to create one manually via {@link UserPoolPolicyType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserPoolPolicyType.Builder#build()} is called immediately and its
         * result is passed to {@link #policies(UserPoolPolicyType)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link UserPoolPolicyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(UserPoolPolicyType)
         */
        default Builder policies(Consumer<UserPoolPolicyType.Builder> policies) {
            return policies(UserPoolPolicyType.builder().applyMutation(policies).build());
        }

        /**
         * <p>
         * When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before you can
         * delete a user pool that you have protected against deletion, you must deactivate this feature.
         * </p>
         * <p>
         * When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito
         * returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new
         * <code>DeleteUserPool</code> request after you deactivate deletion protection in an
         * <code>UpdateUserPool</code> API request.
         * </p>
         * 
         * @param deletionProtection
         *        When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before
         *        you can delete a user pool that you have protected against deletion, you must deactivate this
         *        feature.</p>
         *        <p>
         *        When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon
         *        Cognito returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send
         *        a new <code>DeleteUserPool</code> request after you deactivate deletion protection in an
         *        <code>UpdateUserPool</code> API request.
         * @see DeletionProtectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionProtectionType
         */
        Builder deletionProtection(String deletionProtection);

        /**
         * <p>
         * When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before you can
         * delete a user pool that you have protected against deletion, you must deactivate this feature.
         * </p>
         * <p>
         * When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito
         * returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new
         * <code>DeleteUserPool</code> request after you deactivate deletion protection in an
         * <code>UpdateUserPool</code> API request.
         * </p>
         * 
         * @param deletionProtection
         *        When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool. Before
         *        you can delete a user pool that you have protected against deletion, you must deactivate this
         *        feature.</p>
         *        <p>
         *        When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon
         *        Cognito returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send
         *        a new <code>DeleteUserPool</code> request after you deactivate deletion protection in an
         *        <code>UpdateUserPool</code> API request.
         * @see DeletionProtectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionProtectionType
         */
        Builder deletionProtection(DeletionProtectionType deletionProtection);

        /**
         * <p>
         * A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of
         * authentication operations. Triggers can modify the outcome of the operations that invoked them.
         * </p>
         * 
         * @param lambdaConfig
         *        A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages
         *        of authentication operations. Triggers can modify the outcome of the operations that invoked them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConfig(LambdaConfigType lambdaConfig);

        /**
         * <p>
         * A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of
         * authentication operations. Triggers can modify the outcome of the operations that invoked them.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaConfigType.Builder} avoiding the
         * need to create one manually via {@link LambdaConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaConfigType.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaConfig(LambdaConfigType)}.
         * 
         * @param lambdaConfig
         *        a consumer that will call methods on {@link LambdaConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaConfig(LambdaConfigType)
         */
        default Builder lambdaConfig(Consumer<LambdaConfigType.Builder> lambdaConfig) {
            return lambdaConfig(LambdaConfigType.builder().applyMutation(lambdaConfig).build());
        }

        /**
         * <p>
         * The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
         * <b>phone_number</b>. For more information see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
         * >Verifying contact information at sign-up</a>.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
         *        <b>phone_number</b>. For more information see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
         *        >Verifying contact information at sign-up</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes);

        /**
         * <p>
         * The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
         * <b>phone_number</b>. For more information see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
         * >Verifying contact information at sign-up</a>.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
         *        <b>phone_number</b>. For more information see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
         *        >Verifying contact information at sign-up</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributesWithStrings(String... autoVerifiedAttributes);

        /**
         * <p>
         * The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
         * <b>phone_number</b>. For more information see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
         * >Verifying contact information at sign-up</a>.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
         *        <b>phone_number</b>. For more information see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
         *        >Verifying contact information at sign-up</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes);

        /**
         * <p>
         * The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
         * <b>phone_number</b>. For more information see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
         * >Verifying contact information at sign-up</a>.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes that you want your user pool to automatically verify. Possible values: <b>email</b>,
         *        <b>phone_number</b>. For more information see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves"
         *        >Verifying contact information at sign-up</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributes(VerifiedAttributeType... autoVerifiedAttributes);

        /**
         * <p>
         * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
         * <b>preferred_username</b>. For more information about alias attributes, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         * >Customizing sign-in attributes</a>.
         * </p>
         * 
         * @param aliasAttributes
         *        Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>,
         *        <b>email</b>, or <b>preferred_username</b>. For more information about alias attributes, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         *        >Customizing sign-in attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributesWithStrings(Collection<String> aliasAttributes);

        /**
         * <p>
         * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
         * <b>preferred_username</b>. For more information about alias attributes, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         * >Customizing sign-in attributes</a>.
         * </p>
         * 
         * @param aliasAttributes
         *        Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>,
         *        <b>email</b>, or <b>preferred_username</b>. For more information about alias attributes, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         *        >Customizing sign-in attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributesWithStrings(String... aliasAttributes);

        /**
         * <p>
         * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
         * <b>preferred_username</b>. For more information about alias attributes, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         * >Customizing sign-in attributes</a>.
         * </p>
         * 
         * @param aliasAttributes
         *        Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>,
         *        <b>email</b>, or <b>preferred_username</b>. For more information about alias attributes, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         *        >Customizing sign-in attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributes(Collection<AliasAttributeType> aliasAttributes);

        /**
         * <p>
         * Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or
         * <b>preferred_username</b>. For more information about alias attributes, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         * >Customizing sign-in attributes</a>.
         * </p>
         * 
         * @param aliasAttributes
         *        Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>,
         *        <b>email</b>, or <b>preferred_username</b>. For more information about alias attributes, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         *        >Customizing sign-in attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasAttributes(AliasAttributeType... aliasAttributes);

        /**
         * <p>
         * Specifies whether a user can use an email address or phone number as a username when they sign up. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         * >Customizing sign-in attributes</a>.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether a user can use an email address or phone number as a username when they sign up. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         *        >Customizing sign-in attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributesWithStrings(Collection<String> usernameAttributes);

        /**
         * <p>
         * Specifies whether a user can use an email address or phone number as a username when they sign up. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         * >Customizing sign-in attributes</a>.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether a user can use an email address or phone number as a username when they sign up. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         *        >Customizing sign-in attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributesWithStrings(String... usernameAttributes);

        /**
         * <p>
         * Specifies whether a user can use an email address or phone number as a username when they sign up. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         * >Customizing sign-in attributes</a>.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether a user can use an email address or phone number as a username when they sign up. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         *        >Customizing sign-in attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributes(Collection<UsernameAttributeType> usernameAttributes);

        /**
         * <p>
         * Specifies whether a user can use an email address or phone number as a username when they sign up. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         * >Customizing sign-in attributes</a>.
         * </p>
         * 
         * @param usernameAttributes
         *        Specifies whether a user can use an email address or phone number as a username when they sign up. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases"
         *        >Customizing sign-in attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameAttributes(UsernameAttributeType... usernameAttributes);

        /**
         * <p>
         * This parameter is no longer used. See <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
         * >VerificationMessageTemplateType</a>.
         * </p>
         * 
         * @param smsVerificationMessage
         *        This parameter is no longer used. See <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
         *        >VerificationMessageTemplateType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsVerificationMessage(String smsVerificationMessage);

        /**
         * <p>
         * This parameter is no longer used. See <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
         * >VerificationMessageTemplateType</a>.
         * </p>
         * 
         * @param emailVerificationMessage
         *        This parameter is no longer used. See <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
         *        >VerificationMessageTemplateType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailVerificationMessage(String emailVerificationMessage);

        /**
         * <p>
         * This parameter is no longer used. See <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
         * >VerificationMessageTemplateType</a>.
         * </p>
         * 
         * @param emailVerificationSubject
         *        This parameter is no longer used. See <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html"
         *        >VerificationMessageTemplateType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailVerificationSubject(String emailVerificationSubject);

        /**
         * <p>
         * The template for the verification message that your user pool delivers to users who set an email address or
         * phone number attribute.
         * </p>
         * <p>
         * Set the email message type that corresponds to your <code>DefaultEmailOption</code> selection. For
         * <code>CONFIRM_WITH_LINK</code>, specify an <code>EmailMessageByLink</code> and leave
         * <code>EmailMessage</code> blank. For <code>CONFIRM_WITH_CODE</code>, specify an <code>EmailMessage</code> and
         * leave <code>EmailMessageByLink</code> blank. When you supply both parameters with either choice, Amazon
         * Cognito returns an error.
         * </p>
         * 
         * @param verificationMessageTemplate
         *        The template for the verification message that your user pool delivers to users who set an email
         *        address or phone number attribute.</p>
         *        <p>
         *        Set the email message type that corresponds to your <code>DefaultEmailOption</code> selection. For
         *        <code>CONFIRM_WITH_LINK</code>, specify an <code>EmailMessageByLink</code> and leave
         *        <code>EmailMessage</code> blank. For <code>CONFIRM_WITH_CODE</code>, specify an
         *        <code>EmailMessage</code> and leave <code>EmailMessageByLink</code> blank. When you supply both
         *        parameters with either choice, Amazon Cognito returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate);

        /**
         * <p>
         * The template for the verification message that your user pool delivers to users who set an email address or
         * phone number attribute.
         * </p>
         * <p>
         * Set the email message type that corresponds to your <code>DefaultEmailOption</code> selection. For
         * <code>CONFIRM_WITH_LINK</code>, specify an <code>EmailMessageByLink</code> and leave
         * <code>EmailMessage</code> blank. For <code>CONFIRM_WITH_CODE</code>, specify an <code>EmailMessage</code> and
         * leave <code>EmailMessageByLink</code> blank. When you supply both parameters with either choice, Amazon
         * Cognito returns an error.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerificationMessageTemplateType.Builder}
         * avoiding the need to create one manually via {@link VerificationMessageTemplateType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerificationMessageTemplateType.Builder#build()} is called
         * immediately and its result is passed to {@link #verificationMessageTemplate(VerificationMessageTemplateType)}.
         * 
         * @param verificationMessageTemplate
         *        a consumer that will call methods on {@link VerificationMessageTemplateType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationMessageTemplate(VerificationMessageTemplateType)
         */
        default Builder verificationMessageTemplate(Consumer<VerificationMessageTemplateType.Builder> verificationMessageTemplate) {
            return verificationMessageTemplate(VerificationMessageTemplateType.builder()
                    .applyMutation(verificationMessageTemplate).build());
        }

        /**
         * <p>
         * A string representing the SMS authentication message.
         * </p>
         * 
         * @param smsAuthenticationMessage
         *        A string representing the SMS authentication message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsAuthenticationMessage(String smsAuthenticationMessage);

        /**
         * <p>
         * Sets multi-factor authentication (MFA) to be on, off, or optional. When <code>ON</code>, all users must set
         * up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side
         * determination of whether a user wants to register an MFA device. For user pools with adaptive authentication
         * with threat protection, choose <code>OPTIONAL</code>.
         * </p>
         * 
         * @param mfaConfiguration
         *        Sets multi-factor authentication (MFA) to be on, off, or optional. When <code>ON</code>, all users
         *        must set up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a
         *        client-side determination of whether a user wants to register an MFA device. For user pools with
         *        adaptive authentication with threat protection, choose <code>OPTIONAL</code>.
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(String mfaConfiguration);

        /**
         * <p>
         * Sets multi-factor authentication (MFA) to be on, off, or optional. When <code>ON</code>, all users must set
         * up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side
         * determination of whether a user wants to register an MFA device. For user pools with adaptive authentication
         * with threat protection, choose <code>OPTIONAL</code>.
         * </p>
         * 
         * @param mfaConfiguration
         *        Sets multi-factor authentication (MFA) to be on, off, or optional. When <code>ON</code>, all users
         *        must set up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a
         *        client-side determination of whether a user wants to register an MFA device. For user pools with
         *        adaptive authentication with threat protection, choose <code>OPTIONAL</code>.
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(UserPoolMfaType mfaConfiguration);

        /**
         * <p>
         * The settings for updates to user attributes. These settings include the property
         * <code>AttributesRequireVerificationBeforeUpdate</code>, a user-pool setting that tells Amazon Cognito how to
         * handle changes to the value of your users' email address and phone number attributes. For more information,
         * see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates"
         * > Verifying updates to email addresses and phone numbers</a>.
         * </p>
         * 
         * @param userAttributeUpdateSettings
         *        The settings for updates to user attributes. These settings include the property
         *        <code>AttributesRequireVerificationBeforeUpdate</code>, a user-pool setting that tells Amazon Cognito
         *        how to handle changes to the value of your users' email address and phone number attributes. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates"
         *        > Verifying updates to email addresses and phone numbers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributeUpdateSettings(UserAttributeUpdateSettingsType userAttributeUpdateSettings);

        /**
         * <p>
         * The settings for updates to user attributes. These settings include the property
         * <code>AttributesRequireVerificationBeforeUpdate</code>, a user-pool setting that tells Amazon Cognito how to
         * handle changes to the value of your users' email address and phone number attributes. For more information,
         * see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates"
         * > Verifying updates to email addresses and phone numbers</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserAttributeUpdateSettingsType.Builder}
         * avoiding the need to create one manually via {@link UserAttributeUpdateSettingsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserAttributeUpdateSettingsType.Builder#build()} is called
         * immediately and its result is passed to {@link #userAttributeUpdateSettings(UserAttributeUpdateSettingsType)}.
         * 
         * @param userAttributeUpdateSettings
         *        a consumer that will call methods on {@link UserAttributeUpdateSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAttributeUpdateSettings(UserAttributeUpdateSettingsType)
         */
        default Builder userAttributeUpdateSettings(Consumer<UserAttributeUpdateSettingsType.Builder> userAttributeUpdateSettings) {
            return userAttributeUpdateSettings(UserAttributeUpdateSettingsType.builder()
                    .applyMutation(userAttributeUpdateSettings).build());
        }

        /**
         * <p>
         * The device-remembering configuration for a user pool. Device remembering or device tracking is a
         * "Remember me on this device" option for user pools that perform authentication with the device key of a
         * trusted device in the back end, instead of a user-provided MFA code. For more information about device
         * authentication, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
         * >Working with user devices in your user pool</a>. A null value indicates that you have deactivated device
         * remembering in your user pool.
         * </p>
         * <note>
         * <p>
         * When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito
         * device-remembering feature. For more infor
         * </p>
         * </note>
         * 
         * @param deviceConfiguration
         *        The device-remembering configuration for a user pool. Device remembering or device tracking is a
         *        "Remember me on this device" option for user pools that perform authentication with the device key of
         *        a trusted device in the back end, instead of a user-provided MFA code. For more information about
         *        device authentication, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
         *        >Working with user devices in your user pool</a>. A null value indicates that you have deactivated
         *        device remembering in your user pool.</p> <note>
         *        <p>
         *        When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon
         *        Cognito device-remembering feature. For more infor
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration);

        /**
         * <p>
         * The device-remembering configuration for a user pool. Device remembering or device tracking is a
         * "Remember me on this device" option for user pools that perform authentication with the device key of a
         * trusted device in the back end, instead of a user-provided MFA code. For more information about device
         * authentication, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
         * >Working with user devices in your user pool</a>. A null value indicates that you have deactivated device
         * remembering in your user pool.
         * </p>
         * <note>
         * <p>
         * When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito
         * device-remembering feature. For more infor
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link DeviceConfigurationType.Builder}
         * avoiding the need to create one manually via {@link DeviceConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceConfiguration(DeviceConfigurationType)}.
         * 
         * @param deviceConfiguration
         *        a consumer that will call methods on {@link DeviceConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceConfiguration(DeviceConfigurationType)
         */
        default Builder deviceConfiguration(Consumer<DeviceConfigurationType.Builder> deviceConfiguration) {
            return deviceConfiguration(DeviceConfigurationType.builder().applyMutation(deviceConfiguration).build());
        }

        /**
         * <p>
         * The email configuration of your user pool. The email configuration type sets your preferred sending method,
         * Amazon Web Services Region, and sender for messages from your user pool.
         * </p>
         * 
         * @param emailConfiguration
         *        The email configuration of your user pool. The email configuration type sets your preferred sending
         *        method, Amazon Web Services Region, and sender for messages from your user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailConfiguration(EmailConfigurationType emailConfiguration);

        /**
         * <p>
         * The email configuration of your user pool. The email configuration type sets your preferred sending method,
         * Amazon Web Services Region, and sender for messages from your user pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailConfigurationType.Builder} avoiding
         * the need to create one manually via {@link EmailConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #emailConfiguration(EmailConfigurationType)}.
         * 
         * @param emailConfiguration
         *        a consumer that will call methods on {@link EmailConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailConfiguration(EmailConfigurationType)
         */
        default Builder emailConfiguration(Consumer<EmailConfigurationType.Builder> emailConfiguration) {
            return emailConfiguration(EmailConfigurationType.builder().applyMutation(emailConfiguration).build());
        }

        /**
         * <p>
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message
         * from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with
         * Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and
         * Access Management (IAM) role in your Amazon Web Services account. For more information see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message
         * settings</a>.
         * </p>
         * 
         * @param smsConfiguration
         *        The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS
         *        message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS
         *        messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool
         *        uses an Identity and Access Management (IAM) role in your Amazon Web Services account. For more
         *        information see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS
         *        message settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsConfiguration(SmsConfigurationType smsConfiguration);

        /**
         * <p>
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message
         * from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with
         * Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and
         * Access Management (IAM) role in your Amazon Web Services account. For more information see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message
         * settings</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmsConfigurationType.Builder} avoiding
         * the need to create one manually via {@link SmsConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmsConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #smsConfiguration(SmsConfigurationType)}.
         * 
         * @param smsConfiguration
         *        a consumer that will call methods on {@link SmsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsConfiguration(SmsConfigurationType)
         */
        default Builder smsConfiguration(Consumer<SmsConfigurationType.Builder> smsConfiguration) {
            return smsConfiguration(SmsConfigurationType.builder().applyMutation(smsConfiguration).build());
        }

        /**
         * <p>
         * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and
         * manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         * </p>
         * 
         * @param userPoolTags
         *        The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize
         *        and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolTags(Map<String, String> userPoolTags);

        /**
         * <p>
         * The configuration for <a
         * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html"
         * >AdminCreateUser</a> requests. Includes the template for the invitation message for new users, the duration
         * of temporary passwords, and permitting self-service sign-up.
         * </p>
         * 
         * @param adminCreateUserConfig
         *        The configuration for <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html"
         *        >AdminCreateUser</a> requests. Includes the template for the invitation message for new users, the
         *        duration of temporary passwords, and permitting self-service sign-up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig);

        /**
         * <p>
         * The configuration for <a
         * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html"
         * >AdminCreateUser</a> requests. Includes the template for the invitation message for new users, the duration
         * of temporary passwords, and permitting self-service sign-up.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdminCreateUserConfigType.Builder}
         * avoiding the need to create one manually via {@link AdminCreateUserConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdminCreateUserConfigType.Builder#build()} is called immediately
         * and its result is passed to {@link #adminCreateUserConfig(AdminCreateUserConfigType)}.
         * 
         * @param adminCreateUserConfig
         *        a consumer that will call methods on {@link AdminCreateUserConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminCreateUserConfig(AdminCreateUserConfigType)
         */
        default Builder adminCreateUserConfig(Consumer<AdminCreateUserConfigType.Builder> adminCreateUserConfig) {
            return adminCreateUserConfig(AdminCreateUserConfigType.builder().applyMutation(adminCreateUserConfig).build());
        }

        /**
         * <p>
         * An array of attributes for the new user pool. You can add custom attributes and modify the properties of
         * default attributes. The specifications in this parameter set the required attributes in your user pool. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html">Working
         * with user attributes</a>.
         * </p>
         * 
         * @param schema
         *        An array of attributes for the new user pool. You can add custom attributes and modify the properties
         *        of default attributes. The specifications in this parameter set the required attributes in your user
         *        pool. For more information, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html"
         *        >Working with user attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Collection<SchemaAttributeType> schema);

        /**
         * <p>
         * An array of attributes for the new user pool. You can add custom attributes and modify the properties of
         * default attributes. The specifications in this parameter set the required attributes in your user pool. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html">Working
         * with user attributes</a>.
         * </p>
         * 
         * @param schema
         *        An array of attributes for the new user pool. You can add custom attributes and modify the properties
         *        of default attributes. The specifications in this parameter set the required attributes in your user
         *        pool. For more information, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html"
         *        >Working with user attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(SchemaAttributeType... schema);

        /**
         * <p>
         * An array of attributes for the new user pool. You can add custom attributes and modify the properties of
         * default attributes. The specifications in this parameter set the required attributes in your user pool. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html">Working
         * with user attributes</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType.Builder#build()} is
         * called immediately and its result is passed to {@link #schema(List<SchemaAttributeType>)}.
         * 
         * @param schema
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(java.util.Collection<SchemaAttributeType>)
         */
        Builder schema(Consumer<SchemaAttributeType.Builder>... schema);

        /**
         * <p>
         * User pool add-ons. Contains settings for activation of advanced security features. To log user security
         * information but take no action, set to <code>AUDIT</code>. To configure automatic security responses to risky
         * traffic to your user pool, set to <code>ENFORCED</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         * >Adding advanced security to a user pool</a>.
         * </p>
         * 
         * @param userPoolAddOns
         *        User pool add-ons. Contains settings for activation of advanced security features. To log user
         *        security information but take no action, set to <code>AUDIT</code>. To configure automatic security
         *        responses to risky traffic to your user pool, set to <code>ENFORCED</code>.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         *        >Adding advanced security to a user pool</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns);

        /**
         * <p>
         * User pool add-ons. Contains settings for activation of advanced security features. To log user security
         * information but take no action, set to <code>AUDIT</code>. To configure automatic security responses to risky
         * traffic to your user pool, set to <code>ENFORCED</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         * >Adding advanced security to a user pool</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserPoolAddOnsType.Builder} avoiding the
         * need to create one manually via {@link UserPoolAddOnsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserPoolAddOnsType.Builder#build()} is called immediately and its
         * result is passed to {@link #userPoolAddOns(UserPoolAddOnsType)}.
         * 
         * @param userPoolAddOns
         *        a consumer that will call methods on {@link UserPoolAddOnsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolAddOns(UserPoolAddOnsType)
         */
        default Builder userPoolAddOns(Consumer<UserPoolAddOnsType.Builder> userPoolAddOns) {
            return userPoolAddOns(UserPoolAddOnsType.builder().applyMutation(userPoolAddOns).build());
        }

        /**
         * <p>
         * Sets the case sensitivity option for sign-in usernames. When <code>CaseSensitive</code> is <code>false</code>
         * (case insensitive), users can sign in with any combination of capital and lowercase letters. For example,
         * <code>username</code>, <code>USERNAME</code>, or <code>UserName</code>, or for email,
         * <code>email@example.com</code> or <code>EMaiL@eXamplE.Com</code>. For most use cases, set case sensitivity to
         * <code>false</code> as a best practice. When usernames and email addresses are case insensitive, Amazon
         * Cognito treats any variation in case as the same user, and prevents a case variation from being assigned to
         * the same attribute for a different user.
         * </p>
         * <p>
         * When <code>CaseSensitive</code> is <code>true</code> (case sensitive), Amazon Cognito interprets
         * <code>USERNAME</code> and <code>UserName</code> as distinct users.
         * </p>
         * <p>
         * This configuration is immutable after you set it.
         * </p>
         * 
         * @param usernameConfiguration
         *        Sets the case sensitivity option for sign-in usernames. When <code>CaseSensitive</code> is
         *        <code>false</code> (case insensitive), users can sign in with any combination of capital and lowercase
         *        letters. For example, <code>username</code>, <code>USERNAME</code>, or <code>UserName</code>, or for
         *        email, <code>email@example.com</code> or <code>EMaiL@eXamplE.Com</code>. For most use cases, set case
         *        sensitivity to <code>false</code> as a best practice. When usernames and email addresses are case
         *        insensitive, Amazon Cognito treats any variation in case as the same user, and prevents a case
         *        variation from being assigned to the same attribute for a different user.</p>
         *        <p>
         *        When <code>CaseSensitive</code> is <code>true</code> (case sensitive), Amazon Cognito interprets
         *        <code>USERNAME</code> and <code>UserName</code> as distinct users.
         *        </p>
         *        <p>
         *        This configuration is immutable after you set it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameConfiguration(UsernameConfigurationType usernameConfiguration);

        /**
         * <p>
         * Sets the case sensitivity option for sign-in usernames. When <code>CaseSensitive</code> is <code>false</code>
         * (case insensitive), users can sign in with any combination of capital and lowercase letters. For example,
         * <code>username</code>, <code>USERNAME</code>, or <code>UserName</code>, or for email,
         * <code>email@example.com</code> or <code>EMaiL@eXamplE.Com</code>. For most use cases, set case sensitivity to
         * <code>false</code> as a best practice. When usernames and email addresses are case insensitive, Amazon
         * Cognito treats any variation in case as the same user, and prevents a case variation from being assigned to
         * the same attribute for a different user.
         * </p>
         * <p>
         * When <code>CaseSensitive</code> is <code>true</code> (case sensitive), Amazon Cognito interprets
         * <code>USERNAME</code> and <code>UserName</code> as distinct users.
         * </p>
         * <p>
         * This configuration is immutable after you set it.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsernameConfigurationType.Builder}
         * avoiding the need to create one manually via {@link UsernameConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsernameConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #usernameConfiguration(UsernameConfigurationType)}.
         * 
         * @param usernameConfiguration
         *        a consumer that will call methods on {@link UsernameConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usernameConfiguration(UsernameConfigurationType)
         */
        default Builder usernameConfiguration(Consumer<UsernameConfigurationType.Builder> usernameConfiguration) {
            return usernameConfiguration(UsernameConfigurationType.builder().applyMutation(usernameConfiguration).build());
        }

        /**
         * <p>
         * The available verified method a user can use to recover their password when they call
         * <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than
         * one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the
         * user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito
         * uses the legacy behavior to determine the recovery method where SMS is preferred through email.
         * </p>
         * 
         * @param accountRecoverySetting
         *        The available verified method a user can use to recover their password when they call
         *        <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has
         *        more than one method available. With this setting, SMS doesn't qualify for a valid password recovery
         *        mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this
         *        setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is
         *        preferred through email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountRecoverySetting(AccountRecoverySettingType accountRecoverySetting);

        /**
         * <p>
         * The available verified method a user can use to recover their password when they call
         * <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than
         * one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the
         * user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito
         * uses the legacy behavior to determine the recovery method where SMS is preferred through email.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountRecoverySettingType.Builder}
         * avoiding the need to create one manually via {@link AccountRecoverySettingType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountRecoverySettingType.Builder#build()} is called immediately
         * and its result is passed to {@link #accountRecoverySetting(AccountRecoverySettingType)}.
         * 
         * @param accountRecoverySetting
         *        a consumer that will call methods on {@link AccountRecoverySettingType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountRecoverySetting(AccountRecoverySettingType)
         */
        default Builder accountRecoverySetting(Consumer<AccountRecoverySettingType.Builder> accountRecoverySetting) {
            return accountRecoverySetting(AccountRecoverySettingType.builder().applyMutation(accountRecoverySetting).build());
        }

        /**
         * <p>
         * The user pool <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">feature
         * plan</a>, or tier. This parameter determines the eligibility of the user pool for features like managed
         * login, access-token customization, and threat protection. Defaults to <code>ESSENTIALS</code>.
         * </p>
         * 
         * @param userPoolTier
         *        The user pool <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html"
         *        >feature plan</a>, or tier. This parameter determines the eligibility of the user pool for features
         *        like managed login, access-token customization, and threat protection. Defaults to
         *        <code>ESSENTIALS</code>.
         * @see UserPoolTierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolTierType
         */
        Builder userPoolTier(String userPoolTier);

        /**
         * <p>
         * The user pool <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">feature
         * plan</a>, or tier. This parameter determines the eligibility of the user pool for features like managed
         * login, access-token customization, and threat protection. Defaults to <code>ESSENTIALS</code>.
         * </p>
         * 
         * @param userPoolTier
         *        The user pool <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html"
         *        >feature plan</a>, or tier. This parameter determines the eligibility of the user pool for features
         *        like managed login, access-token customization, and threat protection. Defaults to
         *        <code>ESSENTIALS</code>.
         * @see UserPoolTierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolTierType
         */
        Builder userPoolTier(UserPoolTierType userPoolTier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String poolName;

        private UserPoolPolicyType policies;

        private String deletionProtection;

        private LambdaConfigType lambdaConfig;

        private List<String> autoVerifiedAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> aliasAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> usernameAttributes = DefaultSdkAutoConstructList.getInstance();

        private String smsVerificationMessage;

        private String emailVerificationMessage;

        private String emailVerificationSubject;

        private VerificationMessageTemplateType verificationMessageTemplate;

        private String smsAuthenticationMessage;

        private String mfaConfiguration;

        private UserAttributeUpdateSettingsType userAttributeUpdateSettings;

        private DeviceConfigurationType deviceConfiguration;

        private EmailConfigurationType emailConfiguration;

        private SmsConfigurationType smsConfiguration;

        private Map<String, String> userPoolTags = DefaultSdkAutoConstructMap.getInstance();

        private AdminCreateUserConfigType adminCreateUserConfig;

        private List<SchemaAttributeType> schema = DefaultSdkAutoConstructList.getInstance();

        private UserPoolAddOnsType userPoolAddOns;

        private UsernameConfigurationType usernameConfiguration;

        private AccountRecoverySettingType accountRecoverySetting;

        private String userPoolTier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserPoolRequest model) {
            super(model);
            poolName(model.poolName);
            policies(model.policies);
            deletionProtection(model.deletionProtection);
            lambdaConfig(model.lambdaConfig);
            autoVerifiedAttributesWithStrings(model.autoVerifiedAttributes);
            aliasAttributesWithStrings(model.aliasAttributes);
            usernameAttributesWithStrings(model.usernameAttributes);
            smsVerificationMessage(model.smsVerificationMessage);
            emailVerificationMessage(model.emailVerificationMessage);
            emailVerificationSubject(model.emailVerificationSubject);
            verificationMessageTemplate(model.verificationMessageTemplate);
            smsAuthenticationMessage(model.smsAuthenticationMessage);
            mfaConfiguration(model.mfaConfiguration);
            userAttributeUpdateSettings(model.userAttributeUpdateSettings);
            deviceConfiguration(model.deviceConfiguration);
            emailConfiguration(model.emailConfiguration);
            smsConfiguration(model.smsConfiguration);
            userPoolTags(model.userPoolTags);
            adminCreateUserConfig(model.adminCreateUserConfig);
            schema(model.schema);
            userPoolAddOns(model.userPoolAddOns);
            usernameConfiguration(model.usernameConfiguration);
            accountRecoverySetting(model.accountRecoverySetting);
            userPoolTier(model.userPoolTier);
        }

        public final String getPoolName() {
            return poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final UserPoolPolicyType.Builder getPolicies() {
            return policies != null ? policies.toBuilder() : null;
        }

        public final void setPolicies(UserPoolPolicyType.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        @Override
        public final Builder policies(UserPoolPolicyType policies) {
            this.policies = policies;
            return this;
        }

        public final String getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(String deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(String deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        @Override
        public final Builder deletionProtection(DeletionProtectionType deletionProtection) {
            this.deletionProtection(deletionProtection == null ? null : deletionProtection.toString());
            return this;
        }

        public final LambdaConfigType.Builder getLambdaConfig() {
            return lambdaConfig != null ? lambdaConfig.toBuilder() : null;
        }

        public final void setLambdaConfig(LambdaConfigType.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaConfigType lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final Collection<String> getAutoVerifiedAttributes() {
            if (autoVerifiedAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return autoVerifiedAttributes;
        }

        public final void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
        }

        @Override
        public final Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributesWithStrings(String... autoVerifiedAttributes) {
            autoVerifiedAttributesWithStrings(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        @Override
        public final Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copyEnumToString(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributes(VerifiedAttributeType... autoVerifiedAttributes) {
            autoVerifiedAttributes(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        public final Collection<String> getAliasAttributes() {
            if (aliasAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return aliasAttributes;
        }

        public final void setAliasAttributes(Collection<String> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copy(aliasAttributes);
        }

        @Override
        public final Builder aliasAttributesWithStrings(Collection<String> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copy(aliasAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasAttributesWithStrings(String... aliasAttributes) {
            aliasAttributesWithStrings(Arrays.asList(aliasAttributes));
            return this;
        }

        @Override
        public final Builder aliasAttributes(Collection<AliasAttributeType> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copyEnumToString(aliasAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasAttributes(AliasAttributeType... aliasAttributes) {
            aliasAttributes(Arrays.asList(aliasAttributes));
            return this;
        }

        public final Collection<String> getUsernameAttributes() {
            if (usernameAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return usernameAttributes;
        }

        public final void setUsernameAttributes(Collection<String> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copy(usernameAttributes);
        }

        @Override
        public final Builder usernameAttributesWithStrings(Collection<String> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copy(usernameAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usernameAttributesWithStrings(String... usernameAttributes) {
            usernameAttributesWithStrings(Arrays.asList(usernameAttributes));
            return this;
        }

        @Override
        public final Builder usernameAttributes(Collection<UsernameAttributeType> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copyEnumToString(usernameAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usernameAttributes(UsernameAttributeType... usernameAttributes) {
            usernameAttributes(Arrays.asList(usernameAttributes));
            return this;
        }

        public final String getSmsVerificationMessage() {
            return smsVerificationMessage;
        }

        public final void setSmsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
        }

        @Override
        public final Builder smsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
            return this;
        }

        public final String getEmailVerificationMessage() {
            return emailVerificationMessage;
        }

        public final void setEmailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
        }

        @Override
        public final Builder emailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
            return this;
        }

        public final String getEmailVerificationSubject() {
            return emailVerificationSubject;
        }

        public final void setEmailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
        }

        @Override
        public final Builder emailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
            return this;
        }

        public final VerificationMessageTemplateType.Builder getVerificationMessageTemplate() {
            return verificationMessageTemplate != null ? verificationMessageTemplate.toBuilder() : null;
        }

        public final void setVerificationMessageTemplate(VerificationMessageTemplateType.BuilderImpl verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate != null ? verificationMessageTemplate.build() : null;
        }

        @Override
        public final Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        public final String getSmsAuthenticationMessage() {
            return smsAuthenticationMessage;
        }

        public final void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
        }

        @Override
        public final Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        public final String getMfaConfiguration() {
            return mfaConfiguration;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        @Override
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        public final UserAttributeUpdateSettingsType.Builder getUserAttributeUpdateSettings() {
            return userAttributeUpdateSettings != null ? userAttributeUpdateSettings.toBuilder() : null;
        }

        public final void setUserAttributeUpdateSettings(UserAttributeUpdateSettingsType.BuilderImpl userAttributeUpdateSettings) {
            this.userAttributeUpdateSettings = userAttributeUpdateSettings != null ? userAttributeUpdateSettings.build() : null;
        }

        @Override
        public final Builder userAttributeUpdateSettings(UserAttributeUpdateSettingsType userAttributeUpdateSettings) {
            this.userAttributeUpdateSettings = userAttributeUpdateSettings;
            return this;
        }

        public final DeviceConfigurationType.Builder getDeviceConfiguration() {
            return deviceConfiguration != null ? deviceConfiguration.toBuilder() : null;
        }

        public final void setDeviceConfiguration(DeviceConfigurationType.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        @Override
        public final Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final EmailConfigurationType.Builder getEmailConfiguration() {
            return emailConfiguration != null ? emailConfiguration.toBuilder() : null;
        }

        public final void setEmailConfiguration(EmailConfigurationType.BuilderImpl emailConfiguration) {
            this.emailConfiguration = emailConfiguration != null ? emailConfiguration.build() : null;
        }

        @Override
        public final Builder emailConfiguration(EmailConfigurationType emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        public final SmsConfigurationType.Builder getSmsConfiguration() {
            return smsConfiguration != null ? smsConfiguration.toBuilder() : null;
        }

        public final void setSmsConfiguration(SmsConfigurationType.BuilderImpl smsConfiguration) {
            this.smsConfiguration = smsConfiguration != null ? smsConfiguration.build() : null;
        }

        @Override
        public final Builder smsConfiguration(SmsConfigurationType smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public final Map<String, String> getUserPoolTags() {
            if (userPoolTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return userPoolTags;
        }

        public final void setUserPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
        }

        @Override
        public final Builder userPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
            return this;
        }

        public final AdminCreateUserConfigType.Builder getAdminCreateUserConfig() {
            return adminCreateUserConfig != null ? adminCreateUserConfig.toBuilder() : null;
        }

        public final void setAdminCreateUserConfig(AdminCreateUserConfigType.BuilderImpl adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig != null ? adminCreateUserConfig.build() : null;
        }

        @Override
        public final Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        public final List<SchemaAttributeType.Builder> getSchema() {
            List<SchemaAttributeType.Builder> result = SchemaAttributesListTypeCopier.copyToBuilder(this.schema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchema(Collection<SchemaAttributeType.BuilderImpl> schema) {
            this.schema = SchemaAttributesListTypeCopier.copyFromBuilder(schema);
        }

        @Override
        public final Builder schema(Collection<SchemaAttributeType> schema) {
            this.schema = SchemaAttributesListTypeCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(SchemaAttributeType... schema) {
            schema(Arrays.asList(schema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(Consumer<SchemaAttributeType.Builder>... schema) {
            schema(Stream.of(schema).map(c -> SchemaAttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final UserPoolAddOnsType.Builder getUserPoolAddOns() {
            return userPoolAddOns != null ? userPoolAddOns.toBuilder() : null;
        }

        public final void setUserPoolAddOns(UserPoolAddOnsType.BuilderImpl userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns != null ? userPoolAddOns.build() : null;
        }

        @Override
        public final Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        public final UsernameConfigurationType.Builder getUsernameConfiguration() {
            return usernameConfiguration != null ? usernameConfiguration.toBuilder() : null;
        }

        public final void setUsernameConfiguration(UsernameConfigurationType.BuilderImpl usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration != null ? usernameConfiguration.build() : null;
        }

        @Override
        public final Builder usernameConfiguration(UsernameConfigurationType usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration;
            return this;
        }

        public final AccountRecoverySettingType.Builder getAccountRecoverySetting() {
            return accountRecoverySetting != null ? accountRecoverySetting.toBuilder() : null;
        }

        public final void setAccountRecoverySetting(AccountRecoverySettingType.BuilderImpl accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting != null ? accountRecoverySetting.build() : null;
        }

        @Override
        public final Builder accountRecoverySetting(AccountRecoverySettingType accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting;
            return this;
        }

        public final String getUserPoolTier() {
            return userPoolTier;
        }

        public final void setUserPoolTier(String userPoolTier) {
            this.userPoolTier = userPoolTier;
        }

        @Override
        public final Builder userPoolTier(String userPoolTier) {
            this.userPoolTier = userPoolTier;
            return this;
        }

        @Override
        public final Builder userPoolTier(UserPoolTierType userPoolTier) {
            this.userPoolTier(userPoolTier == null ? null : userPoolTier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserPoolRequest build() {
            return new CreateUserPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
