/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for automated responses and notification templates for adaptive authentication with advanced security
 * features.
 * </p>
 * <p>
 * This data type is a request parameter of <a
 * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetRiskConfiguration.html"
 * >SetRiskConfiguration</a> and a response parameter of <a href=
 * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeRiskConfiguration.html"
 * >DescribeRiskConfiguration</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountTakeoverRiskConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountTakeoverRiskConfigurationType.Builder, AccountTakeoverRiskConfigurationType> {
    private static final SdkField<NotifyConfigurationType> NOTIFY_CONFIGURATION_FIELD = SdkField
            .<NotifyConfigurationType> builder(MarshallingType.SDK_POJO).memberName("NotifyConfiguration")
            .getter(getter(AccountTakeoverRiskConfigurationType::notifyConfiguration))
            .setter(setter(Builder::notifyConfiguration)).constructor(NotifyConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotifyConfiguration").build())
            .build();

    private static final SdkField<AccountTakeoverActionsType> ACTIONS_FIELD = SdkField
            .<AccountTakeoverActionsType> builder(MarshallingType.SDK_POJO).memberName("Actions")
            .getter(getter(AccountTakeoverRiskConfigurationType::actions)).setter(setter(Builder::actions))
            .constructor(AccountTakeoverActionsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFY_CONFIGURATION_FIELD,
            ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NotifyConfigurationType notifyConfiguration;

    private final AccountTakeoverActionsType actions;

    private AccountTakeoverRiskConfigurationType(BuilderImpl builder) {
        this.notifyConfiguration = builder.notifyConfiguration;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The settings for composing and sending an email message when advanced security features assesses a risk level
     * with adaptive authentication. When you choose to notify users in <code>AccountTakeoverRiskConfiguration</code>,
     * Amazon Cognito sends an email message using the method and template that you set with this data type.
     * </p>
     * 
     * @return The settings for composing and sending an email message when advanced security features assesses a risk
     *         level with adaptive authentication. When you choose to notify users in
     *         <code>AccountTakeoverRiskConfiguration</code>, Amazon Cognito sends an email message using the method and
     *         template that you set with this data type.
     */
    public final NotifyConfigurationType notifyConfiguration() {
        return notifyConfiguration;
    }

    /**
     * <p>
     * A list of account-takeover actions for each level of risk that Amazon Cognito might assess with advanced security
     * features.
     * </p>
     * 
     * @return A list of account-takeover actions for each level of risk that Amazon Cognito might assess with advanced
     *         security features.
     */
    public final AccountTakeoverActionsType actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notifyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountTakeoverRiskConfigurationType)) {
            return false;
        }
        AccountTakeoverRiskConfigurationType other = (AccountTakeoverRiskConfigurationType) obj;
        return Objects.equals(notifyConfiguration(), other.notifyConfiguration()) && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountTakeoverRiskConfigurationType").add("NotifyConfiguration", notifyConfiguration())
                .add("Actions", actions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotifyConfiguration":
            return Optional.ofNullable(clazz.cast(notifyConfiguration()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NotifyConfiguration", NOTIFY_CONFIGURATION_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountTakeoverRiskConfigurationType, T> g) {
        return obj -> g.apply((AccountTakeoverRiskConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountTakeoverRiskConfigurationType> {
        /**
         * <p>
         * The settings for composing and sending an email message when advanced security features assesses a risk level
         * with adaptive authentication. When you choose to notify users in
         * <code>AccountTakeoverRiskConfiguration</code>, Amazon Cognito sends an email message using the method and
         * template that you set with this data type.
         * </p>
         * 
         * @param notifyConfiguration
         *        The settings for composing and sending an email message when advanced security features assesses a
         *        risk level with adaptive authentication. When you choose to notify users in
         *        <code>AccountTakeoverRiskConfiguration</code>, Amazon Cognito sends an email message using the method
         *        and template that you set with this data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyConfiguration(NotifyConfigurationType notifyConfiguration);

        /**
         * <p>
         * The settings for composing and sending an email message when advanced security features assesses a risk level
         * with adaptive authentication. When you choose to notify users in
         * <code>AccountTakeoverRiskConfiguration</code>, Amazon Cognito sends an email message using the method and
         * template that you set with this data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotifyConfigurationType.Builder} avoiding
         * the need to create one manually via {@link NotifyConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotifyConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #notifyConfiguration(NotifyConfigurationType)}.
         * 
         * @param notifyConfiguration
         *        a consumer that will call methods on {@link NotifyConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifyConfiguration(NotifyConfigurationType)
         */
        default Builder notifyConfiguration(Consumer<NotifyConfigurationType.Builder> notifyConfiguration) {
            return notifyConfiguration(NotifyConfigurationType.builder().applyMutation(notifyConfiguration).build());
        }

        /**
         * <p>
         * A list of account-takeover actions for each level of risk that Amazon Cognito might assess with advanced
         * security features.
         * </p>
         * 
         * @param actions
         *        A list of account-takeover actions for each level of risk that Amazon Cognito might assess with
         *        advanced security features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(AccountTakeoverActionsType actions);

        /**
         * <p>
         * A list of account-takeover actions for each level of risk that Amazon Cognito might assess with advanced
         * security features.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountTakeoverActionsType.Builder}
         * avoiding the need to create one manually via {@link AccountTakeoverActionsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountTakeoverActionsType.Builder#build()} is called immediately
         * and its result is passed to {@link #actions(AccountTakeoverActionsType)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link AccountTakeoverActionsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(AccountTakeoverActionsType)
         */
        default Builder actions(Consumer<AccountTakeoverActionsType.Builder> actions) {
            return actions(AccountTakeoverActionsType.builder().applyMutation(actions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NotifyConfigurationType notifyConfiguration;

        private AccountTakeoverActionsType actions;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountTakeoverRiskConfigurationType model) {
            notifyConfiguration(model.notifyConfiguration);
            actions(model.actions);
        }

        public final NotifyConfigurationType.Builder getNotifyConfiguration() {
            return notifyConfiguration != null ? notifyConfiguration.toBuilder() : null;
        }

        public final void setNotifyConfiguration(NotifyConfigurationType.BuilderImpl notifyConfiguration) {
            this.notifyConfiguration = notifyConfiguration != null ? notifyConfiguration.build() : null;
        }

        @Override
        public final Builder notifyConfiguration(NotifyConfigurationType notifyConfiguration) {
            this.notifyConfiguration = notifyConfiguration;
            return this;
        }

        public final AccountTakeoverActionsType.Builder getActions() {
            return actions != null ? actions.toBuilder() : null;
        }

        public final void setActions(AccountTakeoverActionsType.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(AccountTakeoverActionsType actions) {
            this.actions = actions;
            return this;
        }

        @Override
        public AccountTakeoverRiskConfigurationType build() {
            return new AccountTakeoverRiskConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
