/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RiskExceptionConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RiskConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RiskConfigurationType> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RiskConfigurationType.getter(RiskConfigurationType::userPoolId)).setter(RiskConfigurationType.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RiskConfigurationType.getter(RiskConfigurationType::clientId)).setter(RiskConfigurationType.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<CompromisedCredentialsRiskConfigurationType> COMPROMISED_CREDENTIALS_RISK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RiskConfigurationType.getter(RiskConfigurationType::compromisedCredentialsRiskConfiguration)).setter(RiskConfigurationType.setter(Builder::compromisedCredentialsRiskConfiguration)).constructor(CompromisedCredentialsRiskConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompromisedCredentialsRiskConfiguration").build()}).build();
    private static final SdkField<AccountTakeoverRiskConfigurationType> ACCOUNT_TAKEOVER_RISK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RiskConfigurationType.getter(RiskConfigurationType::accountTakeoverRiskConfiguration)).setter(RiskConfigurationType.setter(Builder::accountTakeoverRiskConfiguration)).constructor(AccountTakeoverRiskConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountTakeoverRiskConfiguration").build()}).build();
    private static final SdkField<RiskExceptionConfigurationType> RISK_EXCEPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RiskConfigurationType.getter(RiskConfigurationType::riskExceptionConfiguration)).setter(RiskConfigurationType.setter(Builder::riskExceptionConfiguration)).constructor(RiskExceptionConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskExceptionConfiguration").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RiskConfigurationType.getter(RiskConfigurationType::lastModifiedDate)).setter(RiskConfigurationType.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, CLIENT_ID_FIELD, COMPROMISED_CREDENTIALS_RISK_CONFIGURATION_FIELD, ACCOUNT_TAKEOVER_RISK_CONFIGURATION_FIELD, RISK_EXCEPTION_CONFIGURATION_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userPoolId;
    private final String clientId;
    private final CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration;
    private final AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration;
    private final RiskExceptionConfigurationType riskExceptionConfiguration;
    private final Instant lastModifiedDate;

    private RiskConfigurationType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.compromisedCredentialsRiskConfiguration = builder.compromisedCredentialsRiskConfiguration;
        this.accountTakeoverRiskConfiguration = builder.accountTakeoverRiskConfiguration;
        this.riskExceptionConfiguration = builder.riskExceptionConfiguration;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String clientId() {
        return this.clientId;
    }

    public CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration() {
        return this.compromisedCredentialsRiskConfiguration;
    }

    public AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration() {
        return this.accountTakeoverRiskConfiguration;
    }

    public RiskExceptionConfigurationType riskExceptionConfiguration() {
        return this.riskExceptionConfiguration;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.compromisedCredentialsRiskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountTakeoverRiskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskExceptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RiskConfigurationType)) {
            return false;
        }
        RiskConfigurationType other = (RiskConfigurationType)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.compromisedCredentialsRiskConfiguration(), other.compromisedCredentialsRiskConfiguration()) && Objects.equals(this.accountTakeoverRiskConfiguration(), other.accountTakeoverRiskConfiguration()) && Objects.equals(this.riskExceptionConfiguration(), other.riskExceptionConfiguration()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"RiskConfigurationType").add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)this.clientId()).add("CompromisedCredentialsRiskConfiguration", (Object)this.compromisedCredentialsRiskConfiguration()).add("AccountTakeoverRiskConfiguration", (Object)this.accountTakeoverRiskConfiguration()).add("RiskExceptionConfiguration", (Object)this.riskExceptionConfiguration()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "CompromisedCredentialsRiskConfiguration": {
                return Optional.ofNullable(clazz.cast(this.compromisedCredentialsRiskConfiguration()));
            }
            case "AccountTakeoverRiskConfiguration": {
                return Optional.ofNullable(clazz.cast(this.accountTakeoverRiskConfiguration()));
            }
            case "RiskExceptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.riskExceptionConfiguration()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RiskConfigurationType, T> g) {
        return obj -> g.apply((RiskConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientId;
        private CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration;
        private AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration;
        private RiskExceptionConfigurationType riskExceptionConfiguration;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RiskConfigurationType model) {
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.compromisedCredentialsRiskConfiguration(model.compromisedCredentialsRiskConfiguration);
            this.accountTakeoverRiskConfiguration(model.accountTakeoverRiskConfiguration);
            this.riskExceptionConfiguration(model.riskExceptionConfiguration);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final CompromisedCredentialsRiskConfigurationType.Builder getCompromisedCredentialsRiskConfiguration() {
            return this.compromisedCredentialsRiskConfiguration != null ? this.compromisedCredentialsRiskConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration;
            return this;
        }

        public final void setCompromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType.BuilderImpl compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration != null ? compromisedCredentialsRiskConfiguration.build() : null;
        }

        public final AccountTakeoverRiskConfigurationType.Builder getAccountTakeoverRiskConfiguration() {
            return this.accountTakeoverRiskConfiguration != null ? this.accountTakeoverRiskConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration;
            return this;
        }

        public final void setAccountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType.BuilderImpl accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration != null ? accountTakeoverRiskConfiguration.build() : null;
        }

        public final RiskExceptionConfigurationType.Builder getRiskExceptionConfiguration() {
            return this.riskExceptionConfiguration != null ? this.riskExceptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder riskExceptionConfiguration(RiskExceptionConfigurationType riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration;
            return this;
        }

        public final void setRiskExceptionConfiguration(RiskExceptionConfigurationType.BuilderImpl riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration != null ? riskExceptionConfiguration.build() : null;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public RiskConfigurationType build() {
            return new RiskConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RiskConfigurationType> {
        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationType var1);

        default public Builder compromisedCredentialsRiskConfiguration(Consumer<CompromisedCredentialsRiskConfigurationType.Builder> compromisedCredentialsRiskConfiguration) {
            return this.compromisedCredentialsRiskConfiguration((CompromisedCredentialsRiskConfigurationType)((CompromisedCredentialsRiskConfigurationType.Builder)CompromisedCredentialsRiskConfigurationType.builder().applyMutation(compromisedCredentialsRiskConfiguration)).build());
        }

        public Builder accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationType var1);

        default public Builder accountTakeoverRiskConfiguration(Consumer<AccountTakeoverRiskConfigurationType.Builder> accountTakeoverRiskConfiguration) {
            return this.accountTakeoverRiskConfiguration((AccountTakeoverRiskConfigurationType)((AccountTakeoverRiskConfigurationType.Builder)AccountTakeoverRiskConfigurationType.builder().applyMutation(accountTakeoverRiskConfiguration)).build());
        }

        public Builder riskExceptionConfiguration(RiskExceptionConfigurationType var1);

        default public Builder riskExceptionConfiguration(Consumer<RiskExceptionConfigurationType.Builder> riskExceptionConfiguration) {
            return this.riskExceptionConfiguration((RiskExceptionConfigurationType)((RiskExceptionConfigurationType.Builder)RiskExceptionConfigurationType.builder().applyMutation(riskExceptionConfiguration)).build());
        }

        public Builder lastModifiedDate(Instant var1);
    }
}

