/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssetCategoryType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssetExtensionType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ColorSchemeModeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetType> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(AssetType.getter(AssetType::categoryAsString)).setter(AssetType.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> COLOR_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorMode").getter(AssetType.getter(AssetType::colorModeAsString)).setter(AssetType.setter(Builder::colorMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorMode").build()}).build();
    private static final SdkField<String> EXTENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Extension").getter(AssetType.getter(AssetType::extensionAsString)).setter(AssetType.setter(Builder::extension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extension").build()}).build();
    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Bytes").getter(AssetType.getter(AssetType::bytes)).setter(AssetType.setter(Builder::bytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bytes").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(AssetType.getter(AssetType::resourceId)).setter(AssetType.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, COLOR_MODE_FIELD, EXTENSION_FIELD, BYTES_FIELD, RESOURCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Category", CATEGORY_FIELD);
            this.put("ColorMode", COLOR_MODE_FIELD);
            this.put("Extension", EXTENSION_FIELD);
            this.put("Bytes", BYTES_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String category;
    private final String colorMode;
    private final String extension;
    private final SdkBytes bytes;
    private final String resourceId;

    private AssetType(BuilderImpl builder) {
        this.category = builder.category;
        this.colorMode = builder.colorMode;
        this.extension = builder.extension;
        this.bytes = builder.bytes;
        this.resourceId = builder.resourceId;
    }

    public final AssetCategoryType category() {
        return AssetCategoryType.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final ColorSchemeModeType colorMode() {
        return ColorSchemeModeType.fromValue(this.colorMode);
    }

    public final String colorModeAsString() {
        return this.colorMode;
    }

    public final AssetExtensionType extension() {
        return AssetExtensionType.fromValue(this.extension);
    }

    public final String extensionAsString() {
        return this.extension;
    }

    public final SdkBytes bytes() {
        return this.bytes;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetType)) {
            return false;
        }
        AssetType other = (AssetType)obj;
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.colorModeAsString(), other.colorModeAsString()) && Objects.equals(this.extensionAsString(), other.extensionAsString()) && Objects.equals(this.bytes(), other.bytes()) && Objects.equals(this.resourceId(), other.resourceId());
    }

    public final String toString() {
        return ToString.builder((String)"AssetType").add("Category", (Object)this.categoryAsString()).add("ColorMode", (Object)this.colorModeAsString()).add("Extension", (Object)this.extensionAsString()).add("Bytes", (Object)this.bytes()).add("ResourceId", (Object)this.resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "ColorMode": {
                return Optional.ofNullable(clazz.cast(this.colorModeAsString()));
            }
            case "Extension": {
                return Optional.ofNullable(clazz.cast(this.extensionAsString()));
            }
            case "Bytes": {
                return Optional.ofNullable(clazz.cast(this.bytes()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetType, T> g) {
        return obj -> g.apply((AssetType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String colorMode;
        private String extension;
        private SdkBytes bytes;
        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetType model) {
            this.category(model.category);
            this.colorMode(model.colorMode);
            this.extension(model.extension);
            this.bytes(model.bytes);
            this.resourceId(model.resourceId);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(AssetCategoryType category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getColorMode() {
            return this.colorMode;
        }

        public final void setColorMode(String colorMode) {
            this.colorMode = colorMode;
        }

        @Override
        public final Builder colorMode(String colorMode) {
            this.colorMode = colorMode;
            return this;
        }

        @Override
        public final Builder colorMode(ColorSchemeModeType colorMode) {
            this.colorMode(colorMode == null ? null : colorMode.toString());
            return this;
        }

        public final String getExtension() {
            return this.extension;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        @Override
        public final Builder extension(AssetExtensionType extension) {
            this.extension(extension == null ? null : extension.toString());
            return this;
        }

        public final ByteBuffer getBytes() {
            return this.bytes == null ? null : this.bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            this.bytes(bytes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public AssetType build() {
            return new AssetType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetType> {
        public Builder category(String var1);

        public Builder category(AssetCategoryType var1);

        public Builder colorMode(String var1);

        public Builder colorMode(ColorSchemeModeType var1);

        public Builder extension(String var1);

        public Builder extension(AssetExtensionType var1);

        public Builder bytes(SdkBytes var1);

        public Builder resourceId(String var1);
    }
}

