/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignUpResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, SignUpResponse> {
    private static final SdkField<Boolean> USER_CONFIRMED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserConfirmed").getter(SignUpResponse.getter(SignUpResponse::userConfirmed)).setter(SignUpResponse.setter(Builder::userConfirmed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserConfirmed").build()}).build();
    private static final SdkField<CodeDeliveryDetailsType> CODE_DELIVERY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeDeliveryDetails").getter(SignUpResponse.getter(SignUpResponse::codeDeliveryDetails)).setter(SignUpResponse.setter(Builder::codeDeliveryDetails)).constructor(CodeDeliveryDetailsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeliveryDetails").build()}).build();
    private static final SdkField<String> USER_SUB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserSub").getter(SignUpResponse.getter(SignUpResponse::userSub)).setter(SignUpResponse.setter(Builder::userSub)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSub").build()}).build();
    private static final SdkField<String> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Session").getter(SignUpResponse.getter(SignUpResponse::session)).setter(SignUpResponse.setter(Builder::session)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_CONFIRMED_FIELD, CODE_DELIVERY_DETAILS_FIELD, USER_SUB_FIELD, SESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserConfirmed", USER_CONFIRMED_FIELD);
            this.put("CodeDeliveryDetails", CODE_DELIVERY_DETAILS_FIELD);
            this.put("UserSub", USER_SUB_FIELD);
            this.put("Session", SESSION_FIELD);
        }
    });
    private final Boolean userConfirmed;
    private final CodeDeliveryDetailsType codeDeliveryDetails;
    private final String userSub;
    private final String session;

    private SignUpResponse(BuilderImpl builder) {
        super(builder);
        this.userConfirmed = builder.userConfirmed;
        this.codeDeliveryDetails = builder.codeDeliveryDetails;
        this.userSub = builder.userSub;
        this.session = builder.session;
    }

    public final Boolean userConfirmed() {
        return this.userConfirmed;
    }

    public final CodeDeliveryDetailsType codeDeliveryDetails() {
        return this.codeDeliveryDetails;
    }

    public final String userSub() {
        return this.userSub;
    }

    public final String session() {
        return this.session;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userConfirmed());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeliveryDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSub());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignUpResponse)) {
            return false;
        }
        SignUpResponse other = (SignUpResponse)((Object)obj);
        return Objects.equals(this.userConfirmed(), other.userConfirmed()) && Objects.equals(this.codeDeliveryDetails(), other.codeDeliveryDetails()) && Objects.equals(this.userSub(), other.userSub()) && Objects.equals(this.session(), other.session());
    }

    public final String toString() {
        return ToString.builder((String)"SignUpResponse").add("UserConfirmed", (Object)this.userConfirmed()).add("CodeDeliveryDetails", (Object)this.codeDeliveryDetails()).add("UserSub", (Object)this.userSub()).add("Session", (Object)(this.session() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserConfirmed": {
                return Optional.ofNullable(clazz.cast(this.userConfirmed()));
            }
            case "CodeDeliveryDetails": {
                return Optional.ofNullable(clazz.cast(this.codeDeliveryDetails()));
            }
            case "UserSub": {
                return Optional.ofNullable(clazz.cast(this.userSub()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SignUpResponse, T> g) {
        return obj -> g.apply((SignUpResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private Boolean userConfirmed;
        private CodeDeliveryDetailsType codeDeliveryDetails;
        private String userSub;
        private String session;

        private BuilderImpl() {
        }

        private BuilderImpl(SignUpResponse model) {
            super(model);
            this.userConfirmed(model.userConfirmed);
            this.codeDeliveryDetails(model.codeDeliveryDetails);
            this.userSub(model.userSub);
            this.session(model.session);
        }

        public final Boolean getUserConfirmed() {
            return this.userConfirmed;
        }

        public final void setUserConfirmed(Boolean userConfirmed) {
            this.userConfirmed = userConfirmed;
        }

        @Override
        public final Builder userConfirmed(Boolean userConfirmed) {
            this.userConfirmed = userConfirmed;
            return this;
        }

        public final CodeDeliveryDetailsType.Builder getCodeDeliveryDetails() {
            return this.codeDeliveryDetails != null ? this.codeDeliveryDetails.toBuilder() : null;
        }

        public final void setCodeDeliveryDetails(CodeDeliveryDetailsType.BuilderImpl codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails != null ? codeDeliveryDetails.build() : null;
        }

        @Override
        public final Builder codeDeliveryDetails(CodeDeliveryDetailsType codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails;
            return this;
        }

        public final String getUserSub() {
            return this.userSub;
        }

        public final void setUserSub(String userSub) {
            this.userSub = userSub;
        }

        @Override
        public final Builder userSub(String userSub) {
            this.userSub = userSub;
            return this;
        }

        public final String getSession() {
            return this.session;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        @Override
        public SignUpResponse build() {
            return new SignUpResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SignUpResponse> {
        public Builder userConfirmed(Boolean var1);

        public Builder codeDeliveryDetails(CodeDeliveryDetailsType var1);

        default public Builder codeDeliveryDetails(Consumer<CodeDeliveryDetailsType.Builder> codeDeliveryDetails) {
            return this.codeDeliveryDetails((CodeDeliveryDetailsType)((CodeDeliveryDetailsType.Builder)CodeDeliveryDetailsType.builder().applyMutation(codeDeliveryDetails)).build());
        }

        public Builder userSub(String var1);

        public Builder session(String var1);
    }
}

