/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssetListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssetType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateManagedLoginBrandingRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, CreateManagedLoginBrandingRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(CreateManagedLoginBrandingRequest.getter(CreateManagedLoginBrandingRequest::userPoolId)).setter(CreateManagedLoginBrandingRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(CreateManagedLoginBrandingRequest.getter(CreateManagedLoginBrandingRequest::clientId)).setter(CreateManagedLoginBrandingRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<Boolean> USE_COGNITO_PROVIDED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseCognitoProvidedValues").getter(CreateManagedLoginBrandingRequest.getter(CreateManagedLoginBrandingRequest::useCognitoProvidedValues)).setter(CreateManagedLoginBrandingRequest.setter(Builder::useCognitoProvidedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCognitoProvidedValues").build()}).build();
    private static final SdkField<Document> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("Settings").getter(CreateManagedLoginBrandingRequest.getter(CreateManagedLoginBrandingRequest::settings)).setter(CreateManagedLoginBrandingRequest.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<List<AssetType>> ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Assets").getter(CreateManagedLoginBrandingRequest.getter(CreateManagedLoginBrandingRequest::assets)).setter(CreateManagedLoginBrandingRequest.setter(Builder::assets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, CLIENT_ID_FIELD, USE_COGNITO_PROVIDED_VALUES_FIELD, SETTINGS_FIELD, ASSETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserPoolId", USER_POOL_ID_FIELD);
            this.put("ClientId", CLIENT_ID_FIELD);
            this.put("UseCognitoProvidedValues", USE_COGNITO_PROVIDED_VALUES_FIELD);
            this.put("Settings", SETTINGS_FIELD);
            this.put("Assets", ASSETS_FIELD);
        }
    });
    private final String userPoolId;
    private final String clientId;
    private final Boolean useCognitoProvidedValues;
    private final Document settings;
    private final List<AssetType> assets;

    private CreateManagedLoginBrandingRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.useCognitoProvidedValues = builder.useCognitoProvidedValues;
        this.settings = builder.settings;
        this.assets = builder.assets;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final Boolean useCognitoProvidedValues() {
        return this.useCognitoProvidedValues;
    }

    public final Document settings() {
        return this.settings;
    }

    public final boolean hasAssets() {
        return this.assets != null && !(this.assets instanceof SdkAutoConstructList);
    }

    public final List<AssetType> assets() {
        return this.assets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCognitoProvidedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssets() ? this.assets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateManagedLoginBrandingRequest)) {
            return false;
        }
        CreateManagedLoginBrandingRequest other = (CreateManagedLoginBrandingRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.useCognitoProvidedValues(), other.useCognitoProvidedValues()) && Objects.equals(this.settings(), other.settings()) && this.hasAssets() == other.hasAssets() && Objects.equals(this.assets(), other.assets());
    }

    public final String toString() {
        return ToString.builder((String)"CreateManagedLoginBrandingRequest").add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("UseCognitoProvidedValues", (Object)this.useCognitoProvidedValues()).add("Settings", (Object)this.settings()).add("Assets", this.hasAssets() ? this.assets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "UseCognitoProvidedValues": {
                return Optional.ofNullable(clazz.cast(this.useCognitoProvidedValues()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "Assets": {
                return Optional.ofNullable(clazz.cast(this.assets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateManagedLoginBrandingRequest, T> g) {
        return obj -> g.apply((CreateManagedLoginBrandingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientId;
        private Boolean useCognitoProvidedValues;
        private Document settings;
        private List<AssetType> assets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateManagedLoginBrandingRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.useCognitoProvidedValues(model.useCognitoProvidedValues);
            this.settings(model.settings);
            this.assets(model.assets);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Boolean getUseCognitoProvidedValues() {
            return this.useCognitoProvidedValues;
        }

        public final void setUseCognitoProvidedValues(Boolean useCognitoProvidedValues) {
            this.useCognitoProvidedValues = useCognitoProvidedValues;
        }

        @Override
        public final Builder useCognitoProvidedValues(Boolean useCognitoProvidedValues) {
            this.useCognitoProvidedValues = useCognitoProvidedValues;
            return this;
        }

        public final Document getSettings() {
            return this.settings;
        }

        public final void setSettings(Document settings) {
            this.settings = settings;
        }

        @Override
        @Transient
        public final Builder settings(Document settings) {
            this.settings = settings;
            return this;
        }

        public final List<AssetType.Builder> getAssets() {
            List<AssetType.Builder> result = AssetListTypeCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssets(Collection<AssetType.BuilderImpl> assets) {
            this.assets = AssetListTypeCopier.copyFromBuilder(assets);
        }

        @Override
        public final Builder assets(Collection<AssetType> assets) {
            this.assets = AssetListTypeCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(AssetType ... assets) {
            this.assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<AssetType.Builder> ... assets) {
            this.assets(Stream.of(assets).map(c -> (AssetType)((AssetType.Builder)AssetType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateManagedLoginBrandingRequest build() {
            return new CreateManagedLoginBrandingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateManagedLoginBrandingRequest> {
        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder useCognitoProvidedValues(Boolean var1);

        public Builder settings(Document var1);

        public Builder assets(Collection<AssetType> var1);

        public Builder assets(AssetType ... var1);

        public Builder assets(Consumer<AssetType.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

