/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CustomDomainConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainDescriptionType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainDescriptionType> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(DomainDescriptionType.getter(DomainDescriptionType::userPoolId)).setter(DomainDescriptionType.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AWSAccountId").getter(DomainDescriptionType.getter(DomainDescriptionType::awsAccountId)).setter(DomainDescriptionType.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DomainDescriptionType.getter(DomainDescriptionType::domain)).setter(DomainDescriptionType.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(DomainDescriptionType.getter(DomainDescriptionType::s3Bucket)).setter(DomainDescriptionType.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> CLOUD_FRONT_DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudFrontDistribution").getter(DomainDescriptionType.getter(DomainDescriptionType::cloudFrontDistribution)).setter(DomainDescriptionType.setter(Builder::cloudFrontDistribution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontDistribution").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(DomainDescriptionType.getter(DomainDescriptionType::version)).setter(DomainDescriptionType.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DomainDescriptionType.getter(DomainDescriptionType::statusAsString)).setter(DomainDescriptionType.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<CustomDomainConfigType> CUSTOM_DOMAIN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomDomainConfig").getter(DomainDescriptionType.getter(DomainDescriptionType::customDomainConfig)).setter(DomainDescriptionType.setter(Builder::customDomainConfig)).constructor(CustomDomainConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainConfig").build()}).build();
    private static final SdkField<Integer> MANAGED_LOGIN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManagedLoginVersion").getter(DomainDescriptionType.getter(DomainDescriptionType::managedLoginVersion)).setter(DomainDescriptionType.setter(Builder::managedLoginVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoginVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, AWS_ACCOUNT_ID_FIELD, DOMAIN_FIELD, S3_BUCKET_FIELD, CLOUD_FRONT_DISTRIBUTION_FIELD, VERSION_FIELD, STATUS_FIELD, CUSTOM_DOMAIN_CONFIG_FIELD, MANAGED_LOGIN_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserPoolId", USER_POOL_ID_FIELD);
            this.put("AWSAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("Domain", DOMAIN_FIELD);
            this.put("S3Bucket", S3_BUCKET_FIELD);
            this.put("CloudFrontDistribution", CLOUD_FRONT_DISTRIBUTION_FIELD);
            this.put("Version", VERSION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CustomDomainConfig", CUSTOM_DOMAIN_CONFIG_FIELD);
            this.put("ManagedLoginVersion", MANAGED_LOGIN_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String userPoolId;
    private final String awsAccountId;
    private final String domain;
    private final String s3Bucket;
    private final String cloudFrontDistribution;
    private final String version;
    private final String status;
    private final CustomDomainConfigType customDomainConfig;
    private final Integer managedLoginVersion;

    private DomainDescriptionType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.awsAccountId = builder.awsAccountId;
        this.domain = builder.domain;
        this.s3Bucket = builder.s3Bucket;
        this.cloudFrontDistribution = builder.cloudFrontDistribution;
        this.version = builder.version;
        this.status = builder.status;
        this.customDomainConfig = builder.customDomainConfig;
        this.managedLoginVersion = builder.managedLoginVersion;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String domain() {
        return this.domain;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String cloudFrontDistribution() {
        return this.cloudFrontDistribution;
    }

    public final String version() {
        return this.version;
    }

    public final DomainStatusType status() {
        return DomainStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final CustomDomainConfigType customDomainConfig() {
        return this.customDomainConfig;
    }

    public final Integer managedLoginVersion() {
        return this.managedLoginVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedLoginVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDescriptionType)) {
            return false;
        }
        DomainDescriptionType other = (DomainDescriptionType)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.cloudFrontDistribution(), other.cloudFrontDistribution()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.customDomainConfig(), other.customDomainConfig()) && Objects.equals(this.managedLoginVersion(), other.managedLoginVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DomainDescriptionType").add("UserPoolId", (Object)this.userPoolId()).add("AWSAccountId", (Object)this.awsAccountId()).add("Domain", (Object)this.domain()).add("S3Bucket", (Object)this.s3Bucket()).add("CloudFrontDistribution", (Object)this.cloudFrontDistribution()).add("Version", (Object)this.version()).add("Status", (Object)this.statusAsString()).add("CustomDomainConfig", (Object)this.customDomainConfig()).add("ManagedLoginVersion", (Object)this.managedLoginVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "AWSAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "CloudFrontDistribution": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontDistribution()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CustomDomainConfig": {
                return Optional.ofNullable(clazz.cast(this.customDomainConfig()));
            }
            case "ManagedLoginVersion": {
                return Optional.ofNullable(clazz.cast(this.managedLoginVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DomainDescriptionType, T> g) {
        return obj -> g.apply((DomainDescriptionType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String awsAccountId;
        private String domain;
        private String s3Bucket;
        private String cloudFrontDistribution;
        private String version;
        private String status;
        private CustomDomainConfigType customDomainConfig;
        private Integer managedLoginVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDescriptionType model) {
            this.userPoolId(model.userPoolId);
            this.awsAccountId(model.awsAccountId);
            this.domain(model.domain);
            this.s3Bucket(model.s3Bucket);
            this.cloudFrontDistribution(model.cloudFrontDistribution);
            this.version(model.version);
            this.status(model.status);
            this.customDomainConfig(model.customDomainConfig);
            this.managedLoginVersion(model.managedLoginVersion);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getCloudFrontDistribution() {
            return this.cloudFrontDistribution;
        }

        public final void setCloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
        }

        @Override
        public final Builder cloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final CustomDomainConfigType.Builder getCustomDomainConfig() {
            return this.customDomainConfig != null ? this.customDomainConfig.toBuilder() : null;
        }

        public final void setCustomDomainConfig(CustomDomainConfigType.BuilderImpl customDomainConfig) {
            this.customDomainConfig = customDomainConfig != null ? customDomainConfig.build() : null;
        }

        @Override
        public final Builder customDomainConfig(CustomDomainConfigType customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        public final Integer getManagedLoginVersion() {
            return this.managedLoginVersion;
        }

        public final void setManagedLoginVersion(Integer managedLoginVersion) {
            this.managedLoginVersion = managedLoginVersion;
        }

        @Override
        public final Builder managedLoginVersion(Integer managedLoginVersion) {
            this.managedLoginVersion = managedLoginVersion;
            return this;
        }

        public DomainDescriptionType build() {
            return new DomainDescriptionType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainDescriptionType> {
        public Builder userPoolId(String var1);

        public Builder awsAccountId(String var1);

        public Builder domain(String var1);

        public Builder s3Bucket(String var1);

        public Builder cloudFrontDistribution(String var1);

        public Builder version(String var1);

        public Builder status(String var1);

        public Builder status(DomainStatusType var1);

        public Builder customDomainConfig(CustomDomainConfigType var1);

        default public Builder customDomainConfig(Consumer<CustomDomainConfigType.Builder> customDomainConfig) {
            return this.customDomainConfig((CustomDomainConfigType)((CustomDomainConfigType.Builder)CustomDomainConfigType.builder().applyMutation(customDomainConfig)).build());
        }

        public Builder managedLoginVersion(Integer var1);
    }
}

